/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.Style;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.util.text.IAdvancedTextComponent;
import team.creative.creativecore.common.util.type.SingletonList;

public class CompiledText {
    private static final FontRenderer font = Minecraft.func_71410_x().field_71466_p;
    private int maxWidth;
    private int maxHeight;
    public int usedWidth;
    public int usedHeight;
    public int lineSpacing = 2;
    public boolean shadow = true;
    public int defaultColor = -1;
    public Align alignment = Align.LEFT;
    private List<CompiledLine> lines;
    private List<ITextComponent> original;

    public CompiledText(int width, int height) {
        this.maxWidth = width;
        this.maxHeight = height;
        this.setText(Collections.EMPTY_LIST);
    }

    public void setMaxHeight(int height) {
        this.maxHeight = height;
    }

    public void setDimension(int width, int height) {
        this.maxWidth = width;
        this.maxHeight = height;
        this.compile();
    }

    public int getMaxWidht() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setText(ITextComponent component) {
        this.setText(new SingletonList<ITextComponent>(component));
    }

    public void setText(List<ITextComponent> components) {
        this.original = components;
        this.compile();
    }

    private void compile() {
        ArrayList<IFormattableTextComponent> copy = new ArrayList<IFormattableTextComponent>();
        for (ITextComponent component : this.original) {
            copy.add(component.func_230532_e_());
        }
        this.lines = new ArrayList<CompiledLine>();
        this.compileNext(null, true, copy);
    }

    private CompiledLine compileNext(CompiledLine currentLine, boolean newLine, List<? extends ITextProperties> components) {
        for (ITextProperties iTextProperties : components) {
            if (newLine) {
                currentLine = new CompiledLine();
                this.lines.add(currentLine);
            }
            currentLine = this.compileNext(currentLine, iTextProperties);
        }
        return currentLine;
    }

    private CompiledLine compileNext(CompiledLine currentLine, ITextProperties component) {
        List<ITextProperties> properties;
        ArrayList siblings = null;
        if (component instanceof ITextComponent && !((ITextComponent)component).func_150253_a().isEmpty()) {
            siblings = new ArrayList(((ITextComponent)component).func_150253_a());
            ((ITextComponent)component).func_150253_a().clear();
        }
        if ((properties = currentLine.add(component)) != null) {
            currentLine = new CompiledLine();
            this.lines.add(currentLine);
            currentLine = this.compileNext(currentLine, false, properties);
        }
        if (siblings != null) {
            currentLine = this.compileNext(currentLine, false, siblings);
        }
        return currentLine;
    }

    public int getTotalHeight() {
        int height = -this.lineSpacing;
        for (CompiledLine line : this.lines) {
            height += line.height + this.lineSpacing;
        }
        return height;
    }

    public void calculateDimensions() {
        if (this.lines == null) {
            return;
        }
        this.usedWidth = 0;
        this.usedHeight = -this.lineSpacing;
        for (CompiledLine line : this.lines) {
            switch (this.alignment) {
                case LEFT: {
                    this.usedWidth = Math.max(this.usedWidth, line.width);
                    break;
                }
                case CENTER: {
                    this.usedWidth = Math.max(this.usedWidth, this.maxWidth);
                    break;
                }
                case RIGHT: {
                    this.usedWidth = Math.max(this.usedWidth, this.maxWidth);
                }
            }
            int height = line.height + this.lineSpacing;
            this.usedHeight += height;
            if (this.usedHeight <= this.maxHeight) continue;
            break;
        }
    }

    public void render(MatrixStack stack) {
        if (this.lines == null) {
            return;
        }
        this.usedWidth = 0;
        this.usedHeight = -this.lineSpacing;
        stack.func_227860_a_();
        for (CompiledLine line : this.lines) {
            switch (this.alignment) {
                case LEFT: {
                    line.render(stack);
                    this.usedWidth = Math.max(this.usedWidth, line.width);
                    break;
                }
                case CENTER: {
                    stack.func_227860_a_();
                    stack.func_227861_a_((double)(this.maxWidth / 2 - line.width / 2), 0.0, 0.0);
                    line.render(stack);
                    this.usedWidth = Math.max(this.usedWidth, this.maxWidth);
                    stack.func_227865_b_();
                    break;
                }
                case RIGHT: {
                    stack.func_227860_a_();
                    stack.func_227861_a_((double)(this.maxWidth - line.width), 0.0, 0.0);
                    line.render(stack);
                    this.usedWidth = Math.max(this.usedWidth, this.maxWidth);
                    stack.func_227865_b_();
                }
            }
            int height = line.height + this.lineSpacing;
            stack.func_227861_a_(0.0, (double)height, 0.0);
            this.usedHeight += height;
            if (this.usedHeight <= this.maxHeight) continue;
            break;
        }
        stack.func_227865_b_();
    }

    public int getTotalWidth() {
        return this.calculateWidth(0, true, this.original);
    }

    private int calculateWidth(int width, boolean newLine, List<? extends ITextProperties> components) {
        for (ITextProperties iTextProperties : components) {
            int result = this.calculateWidth(iTextProperties);
            if (newLine) {
                width = Math.max(width, result);
                continue;
            }
            width += result;
        }
        return width;
    }

    private int calculateWidth(ITextProperties component) {
        int width = 0;
        if (component instanceof IAdvancedTextComponent) {
            IAdvancedTextComponent advanced = (IAdvancedTextComponent)component;
            if (!advanced.isEmpty()) {
                width += advanced.getWidth(font);
            }
        } else {
            width += font.func_238414_a_(component);
        }
        if (component instanceof ITextComponent && !((ITextComponent)component).func_150253_a().isEmpty()) {
            width += this.calculateWidth(0, false, ((ITextComponent)component).func_150253_a());
        }
        return width;
    }

    public static CompiledText createAnySize() {
        return new CompiledText(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public class CompiledLine {
        private List<ITextProperties> components = new ArrayList<ITextProperties>();
        private int height = 0;
        private int width = 0;

        public void render(MatrixStack stack) {
            int xOffset = 0;
            IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            for (ITextProperties text : this.components) {
                int height;
                int width;
                if (text instanceof IAdvancedTextComponent) {
                    width = ((IAdvancedTextComponent)text).getWidth(font);
                    height = ((IAdvancedTextComponent)text).getHeight(font);
                } else {
                    width = font.func_238414_a_(text);
                    font.getClass();
                    height = 9;
                }
                int yOffset = 0;
                if (height < this.height) {
                    yOffset = (this.height - height) / 2;
                }
                stack.func_227860_a_();
                stack.func_227861_a_((double)xOffset, (double)yOffset, 0.0);
                if (text instanceof IAdvancedTextComponent) {
                    ((IAdvancedTextComponent)text).render(stack, font, CompiledText.this.defaultColor);
                } else {
                    font.func_238416_a_(LanguageMap.func_74808_a().func_241870_a(text), 0.0f, 0.0f, CompiledText.this.defaultColor, CompiledText.this.shadow, stack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderType, false, 0, 0xF000F0);
                    renderType.func_228461_a_();
                }
                stack.func_227865_b_();
                xOffset += width;
            }
        }

        public void updateDimension(int width, int height) {
            this.width = Math.max(width, this.width);
            this.height = Math.max(height, this.height);
        }

        public List<ITextProperties> add(ITextProperties component) {
            int remainingWidth = CompiledText.this.maxWidth - this.width;
            if (component instanceof IAdvancedTextComponent) {
                IAdvancedTextComponent advanced = (IAdvancedTextComponent)component;
                if (advanced.isEmpty()) {
                    return null;
                }
                int textWidth = advanced.getWidth(font);
                if (remainingWidth > textWidth) {
                    this.components.add((ITextProperties)advanced);
                    this.updateDimension(this.width + textWidth, advanced.getHeight(font));
                    return null;
                }
                if (advanced.canSplit()) {
                    List<IAdvancedTextComponent> remaining = advanced.split(remainingWidth, this.width == 0);
                    IAdvancedTextComponent toAdd = remaining.remove(0);
                    this.components.add((ITextProperties)toAdd);
                    this.updateDimension(this.width + toAdd.getWidth(font), toAdd.getHeight(font));
                    if (remaining.isEmpty()) {
                        return null;
                    }
                    return new SingletonList<IAdvancedTextComponent>(remaining.get(0));
                }
                if (this.width == 0) {
                    this.components.add((ITextProperties)advanced);
                    this.updateDimension(this.width + textWidth, advanced.getHeight(font));
                    return null;
                }
                return new SingletonList<IAdvancedTextComponent>(advanced);
            }
            int textWidth = font.func_238414_a_(component);
            if (remainingWidth > textWidth) {
                this.components.add(component);
                font.getClass();
                this.updateDimension(this.width + textWidth, 9);
                return null;
            }
            if (this.width == 0) {
                List wrappedLines = font.func_238420_b_().func_238362_b_(component, CompiledText.this.maxWidth - this.width, Style.field_240709_b_);
                int n = this.width + font.func_238414_a_((ITextProperties)wrappedLines.get(0));
                font.getClass();
                this.updateDimension(n, 9);
                if (wrappedLines.isEmpty()) {
                    return null;
                }
                this.components.add((ITextProperties)wrappedLines.get(0));
                wrappedLines.remove(0);
                if (wrappedLines.isEmpty()) {
                    return null;
                }
                return wrappedLines;
            }
            return new SingletonList<ITextProperties>(component);
        }
    }
}

