/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.controls.GuiFocusControl;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.util.math.Rect;

public class GuiTextfield
extends GuiFocusControl {
    private String text = "";
    private int maxStringLength = 128;
    private int cursorCounter;
    private boolean shift;
    private int lineScrollOffset;
    private int cursorPosition;
    private int selectionEnd;
    private String suggestion;
    private Predicate<String> validator = Objects::nonNull;
    private BiFunction<String, Integer, IReorderingProcessor> textFormatter = (text, pos) -> IReorderingProcessor.func_242239_a((String)text, (Style)Style.field_240709_b_);

    public GuiTextfield(String name, int x, int y, int width) {
        this(name, x, y, width, 20);
    }

    public GuiTextfield(String name, int x, int y, int width, int height) {
        this(name, "", x, y, width, height);
    }

    public GuiTextfield(String name, String text2, int x, int y, int width, int height) {
        super(name, x, y, width, height);
        this.setText(text2);
    }

    public GuiTextfield setFloatOnly() {
        this.validator = x -> {
            if (x.isEmpty()) {
                return true;
            }
            try {
                Float.parseFloat(x);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
        return this;
    }

    public GuiTextfield setNumbersIncludingNegativeOnly() {
        this.validator = x -> {
            if (x.isEmpty()) {
                return true;
            }
            try {
                Integer.parseInt(x);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
        return this;
    }

    public GuiTextfield setNumbersOnly() {
        this.validator = x -> {
            if (x.isEmpty()) {
                return true;
            }
            try {
                return Integer.parseInt(x) >= 0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
        return this;
    }

    public float parseFloat() {
        try {
            return Float.parseFloat(this.text);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public int parseInteger() {
        try {
            return Integer.parseInt(this.text);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void closed() {
    }

    @Override
    public void tick() {
        ++this.cursorCounter;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.NESTED;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(MatrixStack matrix, Rect rect, int mouseX, int mouseY) {
        FontRenderer fontRenderer = GuiRenderHelper.getFont();
        int j = this.cursorPosition - this.lineScrollOffset;
        int k = this.selectionEnd - this.lineScrollOffset;
        GuiStyle style = this.getStyle();
        int color = this.enabled ? style.fontColor.toInt() : style.fontColorDisabled.toInt();
        String s = fontRenderer.func_238412_a_(this.text.substring(this.lineScrollOffset), (int)rect.getWidth());
        boolean flag = j >= 0 && j <= s.length();
        boolean flag1 = this.isFocused() && this.cursorCounter / 6 % 2 == 0 && flag;
        int i1 = 0;
        int j1 = 0;
        if (!s.isEmpty()) {
            String s1 = flag ? s.substring(0, j) : s;
            j1 = fontRenderer.func_238407_a_(matrix, this.textFormatter.apply(s1, this.lineScrollOffset), 0.0f, (float)i1, color);
        }
        boolean flag2 = this.cursorPosition < this.text.length() || this.text.length() >= this.getMaxStringLength();
        int k1 = j1;
        if (!flag) {
            k1 = j > 0 ? this.getWidth() : 0;
        } else if (flag2) {
            k1 = j1 - 1;
            --j1;
        }
        if (!s.isEmpty() && flag && j < s.length()) {
            fontRenderer.func_238407_a_(matrix, this.textFormatter.apply(s.substring(j), this.cursorPosition), (float)j1, (float)i1, color);
        }
        if (!flag2 && this.suggestion != null) {
            fontRenderer.func_238405_a_(matrix, this.suggestion, (float)(k1 - 1), (float)i1, -8355712);
        }
        if (flag1) {
            if (flag2) {
                AbstractGui.func_238467_a_((MatrixStack)matrix, (int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + 9), (int)-3092272);
            } else {
                fontRenderer.func_238405_a_(matrix, "_", (float)k1, (float)i1, color);
            }
        }
        if (k != j) {
            int l1 = fontRenderer.func_78256_a(s.substring(0, k));
            this.drawSelectionBox(matrix.func_227866_c_().func_227870_a_(), k1, i1 - 1, l1 - 1, i1 + 1 + 9);
        }
    }

    public void setText(String textIn) {
        if (this.validator.test(textIn)) {
            this.text = textIn.length() > this.maxStringLength ? textIn.substring(0, this.maxStringLength) : textIn;
            this.setCursorPositionEnd();
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(textIn);
        }
    }

    public String getText() {
        return this.text;
    }

    public String getSelectedText() {
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        return this.text.substring(i, j);
    }

    public void setValidator(Predicate<String> validatorIn) {
        this.validator = validatorIn;
    }

    public void writeText(String textToWrite) {
        String s1;
        String s;
        int l;
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int k = this.maxStringLength - this.text.length() - (i - j);
        if (k < (l = (s = SharedConstants.func_71565_a((String)textToWrite)).length())) {
            s = s.substring(0, k);
            l = k;
        }
        if (this.validator.test(s1 = new StringBuilder(this.text).replace(i, j, s).toString())) {
            this.text = s1;
            this.clampCursorPosition(i + l);
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(this.text);
        }
    }

    private void onTextChanged(String newText) {
        this.raiseEvent(new GuiControlChangedEvent(this));
    }

    private void delete(int p_212950_1_) {
        if (Screen.func_231172_r_()) {
            this.deleteWords(p_212950_1_);
        } else {
            this.deleteFromCursor(p_212950_1_);
        }
    }

    public void deleteWords(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                String s;
                int k;
                int i = this.func_238516_r_(num);
                int j = Math.min(i, this.cursorPosition);
                if (j != (k = Math.max(i, this.cursorPosition)) && this.validator.test(s = new StringBuilder(this.text).delete(j, k).toString())) {
                    this.text = s;
                    this.setCursorPosition(j);
                }
            }
        }
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.getCursorPosition());
    }

    private int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    private int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.func_238516_r_(num));
    }

    private int func_238516_r_(int p_238516_1_) {
        return Util.func_240980_a_((String)this.text, (int)this.cursorPosition, (int)p_238516_1_);
    }

    public void setCursorPosition(int pos) {
        this.clampCursorPosition(pos);
        if (!this.shift) {
            this.setSelectionPos(this.cursorPosition);
        }
        this.onTextChanged(this.text);
    }

    public void clampCursorPosition(int pos) {
        this.cursorPosition = MathHelper.func_76125_a((int)pos, (int)0, (int)this.text.length());
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.canWrite()) {
            return false;
        }
        this.shift = Screen.func_231173_s_();
        if (Screen.func_231170_j_((int)keyCode)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (Screen.func_231169_i_((int)keyCode)) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getSelectedText());
            return true;
        }
        if (Screen.func_231168_h_((int)keyCode)) {
            this.writeText(Minecraft.func_71410_x().field_195559_v.func_197965_a());
            return true;
        }
        if (Screen.func_231166_g_((int)keyCode)) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getSelectedText());
            this.writeText("");
            return true;
        }
        switch (keyCode) {
            case 259: {
                this.shift = false;
                this.delete(-1);
                this.shift = Screen.func_231173_s_();
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                this.shift = false;
                this.delete(1);
                this.shift = Screen.func_231173_s_();
                return true;
            }
            case 262: {
                if (Screen.func_231172_r_()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 263: {
                if (Screen.func_231172_r_()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 268: {
                this.setCursorPositionZero();
                return true;
            }
            case 269: 
        }
        this.setCursorPositionEnd();
        return true;
    }

    public boolean canWrite() {
        return this.isFocused();
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        if (!this.canWrite()) {
            return false;
        }
        if (SharedConstants.func_71566_a((char)codePoint)) {
            this.writeText(Character.toString(codePoint));
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        if (button == 0) {
            int i = MathHelper.func_76128_c((double)mouseX);
            FontRenderer fontRenderer = GuiRenderHelper.getFont();
            String s = fontRenderer.func_238412_a_(this.text.substring(this.lineScrollOffset), this.getContentWidth());
            this.setCursorPosition(fontRenderer.func_238412_a_(s, i).length() + this.lineScrollOffset);
            return true;
        }
        return false;
    }

    private void drawSelectionBox(Matrix4f matrix, int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.getX() + this.getWidth()) {
            endX = this.getX() + this.getWidth();
        }
        if (startX > this.getX() + this.getWidth()) {
            startX = this.getX() + this.getWidth();
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_227888_a_(matrix, (float)startX, (float)endY, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)endX, (float)endY, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)endX, (float)startY, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)startX, (float)startY, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    public void setMaxStringLength(int length) {
        this.maxStringLength = length;
        if (this.text.length() > length) {
            this.text = this.text.substring(0, length);
            this.onTextChanged(this.text);
        }
    }

    private int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    @Override
    protected void focusChanged() {
        if (this.isFocused()) {
            this.cursorCounter = 0;
        }
    }

    public void setSelectionPos(int position) {
        int textLength = this.text.length();
        this.selectionEnd = MathHelper.func_76125_a((int)position, (int)0, (int)textLength);
        if (this.getParent() == null || !this.hasLayer()) {
            return;
        }
        FontRenderer fontRenderer = GuiRenderHelper.getFont();
        if (fontRenderer != null) {
            if (this.lineScrollOffset > textLength) {
                this.lineScrollOffset = textLength;
            }
            int j = this.getContentWidth();
            String s = fontRenderer.func_238412_a_(this.text.substring(this.lineScrollOffset), j);
            int k = s.length() + this.lineScrollOffset;
            if (this.selectionEnd == this.lineScrollOffset) {
                this.lineScrollOffset -= fontRenderer.func_238413_a_(this.text, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.lineScrollOffset += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - this.selectionEnd;
            }
            this.lineScrollOffset = MathHelper.func_76125_a((int)this.lineScrollOffset, (int)0, (int)textLength);
        }
    }

    public void setSuggestion(@Nullable String p_195612_1_) {
        this.suggestion = p_195612_1_;
    }
}

