/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.integration;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.gui.sync.LayerClosePacket;
import team.creative.creativecore.common.gui.sync.LayerOpenPacket;
import team.creative.creativecore.common.network.CreativePacket;

public class ContainerIntegration
extends Container
implements IGuiIntegratedParent {
    private List<GuiLayer> layers = new ArrayList<GuiLayer>();
    private final PlayerEntity player;

    public ContainerIntegration(ContainerType<ContainerIntegration> type, int id, PlayerEntity player, GuiLayer layer) {
        super(type, id);
        this.player = player;
        layer.setParent(this);
        this.layers.add(layer);
        layer.init();
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.tick();
    }

    public void tick() {
        for (GuiLayer layer : this.layers) {
            layer.tick();
        }
    }

    @Override
    public List<GuiLayer> getLayers() {
        return this.layers;
    }

    @Override
    public GuiLayer getTopLayer() {
        return this.layers.get(this.layers.size() - 1);
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        for (GuiLayer layer : this.layers) {
            layer.closed();
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    @Override
    public PlayerEntity getPlayer() {
        return this.player;
    }

    @Override
    public boolean isClient() {
        return this.player.field_70170_p.field_72995_K;
    }

    @Override
    public void openLayer(GuiLayer layer) {
        layer.setParent(this);
        this.layers.add(layer);
        layer.init();
    }

    @Override
    public GuiLayer openLayer(LayerOpenPacket packet) {
        packet.execute(this.player);
        if (this.isClient()) {
            CreativeCore.NETWORK.sendToServer(packet);
        } else {
            CreativeCore.NETWORK.sendToClient((CreativePacket)packet, (ServerPlayerEntity)this.player);
        }
        return this.layers.get(this.layers.size() - 1);
    }

    @Override
    public void closeTopLayer() {
        int index = this.layers.size() - 1;
        this.sendPacket(new LayerClosePacket());
        this.closeLayer(index);
    }

    @Override
    public void closeLayer(int layer) {
        this.layers.remove(layer);
        if (this.layers.isEmpty()) {
            if (this.isClient()) {
                Minecraft.func_71410_x().func_147108_a((Screen)null);
            } else {
                ((ServerPlayerEntity)this.player).func_71128_l();
            }
        }
    }

    public void sendPacket(CreativePacket packet) {
        if (this.isClient()) {
            this.sendPacketToServer(packet);
        } else {
            this.sendPacketToClient(packet);
        }
    }

    public void sendPacketToServer(CreativePacket packet) {
        CreativeCore.NETWORK.sendToServer(packet);
    }

    public void sendPacketToClient(CreativePacket packet) {
        CreativeCore.NETWORK.sendToClient(packet, (ServerPlayerEntity)this.player);
    }
}

