/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.integration;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.client.gui.GuiUtils;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.event.GuiTooltipEvent;
import team.creative.creativecore.common.gui.integration.ScreenEventListener;
import team.creative.creativecore.common.util.math.Rect;

public interface IGuiIntegratedParent
extends IGuiParent {
    public List<GuiLayer> getLayers();

    public GuiLayer getTopLayer();

    default public boolean isOpen(Class<? extends GuiLayer> clazz) {
        for (GuiLayer layer : this.getLayers()) {
            if (!clazz.isInstance(layer)) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void render(MatrixStack matrixStack, Screen screen, ScreenEventListener listener, int mouseX, int mouseY) {
        int width = screen.field_230708_k_;
        int height = screen.field_230709_l_;
        listener.tick();
        Rect screenRect = Rect.getScreenRect();
        List<GuiLayer> layers = this.getLayers();
        for (int i = 0; i < layers.size(); ++i) {
            GuiLayer layer = layers.get(i);
            if (i == layers.size() - 1) {
                if (layer.hasGrayBackground()) {
                    GuiRenderHelper.fillGradient(matrixStack, 0, 0, width, height, -1072689136, -804253680);
                }
                MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent(screen, matrixStack));
            }
            matrixStack.func_227860_a_();
            int offX = (width - layer.getWidth()) / 2;
            int offY = (height - layer.getHeight()) / 2;
            matrixStack.func_227861_a_((double)offX, (double)offY, 0.0);
            RenderSystem.blendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Rect controlRect = new Rect(offX, offY, offX + layer.getWidth(), offY + layer.getHeight());
            layer.render(matrixStack, controlRect, screenRect.intersection(controlRect), mouseX, mouseY);
            matrixStack.func_227865_b_();
            RenderSystem.disableScissor();
        }
        if (layers.isEmpty()) {
            return;
        }
        GuiLayer layer = this.getTopLayer();
        GuiTooltipEvent event = layer.getTooltipEvent(mouseX - listener.getOffsetX(), mouseY - listener.getOffsetY());
        if (event != null) {
            layer.raiseEvent(event);
            if (!event.isCanceled()) {
                GuiUtils.drawHoveringText((MatrixStack)matrixStack, event.tooltip, (int)mouseX, (int)mouseY, (int)width, (int)height, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
            }
        }
    }

    @Override
    default public void moveBehind(GuiControl toMove, GuiControl reference) {
        List<GuiLayer> layers = this.getLayers();
        layers.remove(toMove);
        int index = layers.indexOf(reference);
        if (index != -1 && index < layers.size() - 1) {
            layers.add(index + 1, (GuiLayer)toMove);
        } else {
            this.moveBottom(toMove);
        }
    }

    @Override
    default public void moveInFront(GuiControl toMove, GuiControl reference) {
        List<GuiLayer> layers = this.getLayers();
        layers.remove(toMove);
        int index = layers.indexOf(reference);
        if (index != -1) {
            layers.add(index, (GuiLayer)toMove);
        } else {
            this.moveTop(toMove);
        }
    }

    @Override
    default public void moveTop(GuiControl toMove) {
        List<GuiLayer> layers = this.getLayers();
        layers.remove(toMove);
        layers.add(0, (GuiLayer)toMove);
    }

    @Override
    default public void moveBottom(GuiControl toMove) {
        List<GuiLayer> layers = this.getLayers();
        layers.remove(toMove);
        layers.add((GuiLayer)toMove);
    }

    @Override
    default public void raiseEvent(GuiEvent event) {
    }

    @Override
    default public void initiateLayoutUpdate() {
    }

    public void openLayer(GuiLayer var1);

    public void closeLayer(int var1);
}

