/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;

public class CreativeIngredientMaterial
extends CreativeIngredient {
    public Material material;

    public CreativeIngredientMaterial(Material material) {
        this.material = material;
    }

    public CreativeIngredientMaterial() {
    }

    @Override
    protected void writeExtra(CompoundNBT nbt) {
        nbt.func_74778_a("material", this.getBlock().getRegistryName().toString());
    }

    @Override
    protected void readExtra(CompoundNBT nbt) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74779_i("material")));
        if (block != null) {
            this.material = block.func_176223_P().func_185904_a();
        }
    }

    public Block getBlock() {
        for (Block block : ForgeRegistries.BLOCKS) {
            if (block.func_176223_P().func_185904_a() != this.material) continue;
            return block;
        }
        return null;
    }

    @Override
    public ItemStack getExample() {
        return new ItemStack((IItemProvider)this.getBlock());
    }

    public static BlockState getState(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block != null) {
            return block.func_176223_P();
        }
        return null;
    }

    @Override
    public boolean is(CreativeIngredient info) {
        return info instanceof CreativeIngredientMaterial && ((CreativeIngredientMaterial)info).material == this.material;
    }

    @Override
    public boolean is(ItemStack stack) {
        BlockState state = CreativeIngredientMaterial.getState(stack);
        if (state != null) {
            return state.func_185904_a() == this.material;
        }
        return false;
    }

    @Override
    public boolean equals(CreativeIngredient object) {
        return object instanceof CreativeIngredientMaterial && ((CreativeIngredientMaterial)object).material == this.material;
    }

    @Override
    public CreativeIngredient copy() {
        return new CreativeIngredientMaterial(this.material);
    }
}

