/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.client;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import team.creative.cmdcam.CMDCam;
import team.creative.cmdcam.client.CamEventHandlerClient;
import team.creative.cmdcam.client.KeyHandler;
import team.creative.cmdcam.client.PathParseException;
import team.creative.cmdcam.client.interpolation.CamInterpolation;
import team.creative.cmdcam.common.command.argument.CamModeArgument;
import team.creative.cmdcam.common.command.argument.DurationArgument;
import team.creative.cmdcam.common.command.argument.InterpolationArgument;
import team.creative.cmdcam.common.command.argument.TargetArgument;
import team.creative.cmdcam.common.packet.GetPathPacket;
import team.creative.cmdcam.common.packet.SetPathPacket;
import team.creative.cmdcam.common.util.CamPath;
import team.creative.cmdcam.common.util.CamPoint;
import team.creative.cmdcam.common.util.CamTarget;
import team.creative.creativecore.client.command.ClientCommandRegistry;
import team.creative.creativecore.common.network.CreativePacket;

public class CMDCamClient {
    public static Minecraft mc;
    public static int lastLoop;
    public static long lastDuration;
    public static String lastMode;
    public static String lastInterpolation;
    public static CamTarget target;
    public static ArrayList<CamPoint> points;
    public static double cameraFollowSpeed;
    public static HashMap<String, CamPath> savedPaths;
    public static boolean isInstalledOnSever;
    private static CamPath currentPath;

    public static void init(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new CamEventHandlerClient());
        mc = (Minecraft)event.getMinecraftSupplier().get();
        KeyHandler.initKeys();
        event.enqueueWork(() -> ClientCommandRegistry.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"cam").executes(x -> {
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("" + TextFormatting.BOLD + TextFormatting.YELLOW + "/cam add [number] " + TextFormatting.RED + "register a point at the current position"), Util.field_240973_b_);
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("" + TextFormatting.BOLD + TextFormatting.YELLOW + "/cam clear " + TextFormatting.RED + "delete all registered points"), Util.field_240973_b_);
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("" + TextFormatting.BOLD + TextFormatting.YELLOW + "/cam start [time|ms|s|m|h|d] [loops (-1 -> endless)] " + TextFormatting.RED + "starts the animation"), Util.field_240973_b_);
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("" + TextFormatting.BOLD + TextFormatting.YELLOW + "/cam stop " + TextFormatting.RED + "stops the animation"), Util.field_240973_b_);
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("" + TextFormatting.BOLD + TextFormatting.YELLOW + "/cam goto <index> " + TextFormatting.RED + "tp to the given point"), Util.field_240973_b_);
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("" + TextFormatting.BOLD + TextFormatting.YELLOW + "/cam set <index> " + TextFormatting.RED + "updates point to current location"), Util.field_240973_b_);
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("" + TextFormatting.BOLD + TextFormatting.YELLOW + "/cam remove <index> " + TextFormatting.RED + "removes the given point"), Util.field_240973_b_);
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("" + TextFormatting.BOLD + TextFormatting.YELLOW + "/cam target <none:self> " + TextFormatting.RED + "set the camera target"), Util.field_240973_b_);
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("" + TextFormatting.BOLD + TextFormatting.YELLOW + "/cam mode <default:outside> " + TextFormatting.RED + "set current mode"), Util.field_240973_b_);
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("" + TextFormatting.BOLD + TextFormatting.YELLOW + "/cam interpolation <" + String.join((CharSequence)":", CamInterpolation.getMovementNames()) + "> " + TextFormatting.RED + "set the camera interpolation"), Util.field_240973_b_);
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("" + TextFormatting.BOLD + TextFormatting.YELLOW + "/cam follow-speed <number> " + TextFormatting.RED + "default is 1.0"), Util.field_240973_b_);
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("" + TextFormatting.BOLD + TextFormatting.YELLOW + "/cam show <all:" + String.join((CharSequence)":", CamInterpolation.getMovementNames()) + "> " + TextFormatting.RED + "shows the path using the given interpolation"), Util.field_240973_b_);
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("" + TextFormatting.BOLD + TextFormatting.YELLOW + "/cam hide <all:" + String.join((CharSequence)":", CamInterpolation.getMovementNames()) + "> " + TextFormatting.RED + "hides the path using the given interpolation"), Util.field_240973_b_);
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("" + TextFormatting.BOLD + TextFormatting.YELLOW + "/cam save <name> " + TextFormatting.RED + "saves the current path (including settings) with the given name"), Util.field_240973_b_);
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("" + TextFormatting.BOLD + TextFormatting.YELLOW + "/cam load <name> " + TextFormatting.RED + "tries to load the saved path with the given name"), Util.field_240973_b_);
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("" + TextFormatting.BOLD + TextFormatting.YELLOW + "/cam list " + TextFormatting.RED + "lists all saved paths"), Util.field_240973_b_);
            return 0;
        })).then(LiteralArgumentBuilder.literal((String)"clear").executes(x -> {
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Cleared all registered points!"), Util.field_240973_b_);
            points.clear();
            return 0;
        }))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"add").executes(x -> {
            points.add(new CamPoint());
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Registered " + points.size() + ". Point!"), Util.field_240973_b_);
            return 0;
        })).then(RequiredArgumentBuilder.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(x -> {
            Integer index;
            Integer n = index = Integer.valueOf(IntegerArgumentType.getInteger((CommandContext)x, (String)"index"));
            Integer n2 = index = Integer.valueOf(index - 1);
            if (index >= 0 && index < points.size()) {
                points.add(index, new CamPoint());
                CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Inserted " + index + ". Point!"), Util.field_240973_b_);
            } else {
                CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("The given index '" + index + "' is too high/low!"), Util.field_240973_b_);
            }
            return 0;
        })))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"start").executes(x -> {
            try {
                CMDCamClient.startPath(CMDCamClient.createPathFromCurrentConfiguration());
            }
            catch (PathParseException e) {
                CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent(e.getMessage()), Util.field_240973_b_);
            }
            return 0;
        })).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"duration", (ArgumentType)DurationArgument.duration()).executes(x -> {
            try {
                long duration = DurationArgument.getDuration(x, "duration");
                if (duration > 0L) {
                    lastDuration = duration;
                }
                CMDCamClient.startPath(CMDCamClient.createPathFromCurrentConfiguration());
            }
            catch (PathParseException e) {
                CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent(e.getMessage()), Util.field_240973_b_);
            }
            return 0;
        })).then(RequiredArgumentBuilder.argument((String)"loop", (ArgumentType)IntegerArgumentType.integer((int)-1)).executes(x -> {
            try {
                long duration = DurationArgument.getDuration(x, "duration");
                if (duration > 0L) {
                    lastDuration = duration;
                }
                lastLoop = IntegerArgumentType.getInteger((CommandContext)x, (String)"loop");
                CMDCamClient.startPath(CMDCamClient.createPathFromCurrentConfiguration());
            }
            catch (PathParseException e) {
                CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent(e.getMessage()), Util.field_240973_b_);
            }
            return 0;
        }))))).then(LiteralArgumentBuilder.literal((String)"stop").executes(x -> {
            CMDCamClient.stopPath();
            return 0;
        }))).then(LiteralArgumentBuilder.literal((String)"remove").then(RequiredArgumentBuilder.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(x -> {
            Integer index;
            Integer n = index = Integer.valueOf(IntegerArgumentType.getInteger((CommandContext)x, (String)"index"));
            Integer n2 = index = Integer.valueOf(index - 1);
            if (index >= 0 && index < points.size()) {
                points.remove(index);
                CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Removed " + (index + 1) + ". point!"), Util.field_240973_b_);
            } else {
                CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("The given index '" + index + "' is too high/low!"), Util.field_240973_b_);
            }
            return 0;
        })))).then(LiteralArgumentBuilder.literal((String)"set").then(RequiredArgumentBuilder.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(x -> {
            Integer index;
            Integer n = index = Integer.valueOf(IntegerArgumentType.getInteger((CommandContext)x, (String)"index"));
            Integer n2 = index = Integer.valueOf(index - 1);
            if (index >= 0 && index < points.size()) {
                points.set(index, new CamPoint());
                CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Updated " + (index + 1) + ". point!"), Util.field_240973_b_);
            } else {
                CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("The given index '" + index + "' is too high/low!"), Util.field_240973_b_);
            }
            return 0;
        })))).then(LiteralArgumentBuilder.literal((String)"goto").then(RequiredArgumentBuilder.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(x -> {
            Integer index;
            Integer n = index = Integer.valueOf(IntegerArgumentType.getInteger((CommandContext)x, (String)"index"));
            Integer n2 = index = Integer.valueOf(index - 1);
            if (index >= 0 && index < points.size()) {
                CamPoint point = points.get(index);
                CMDCamClient.mc.field_71439_g.field_71075_bZ.field_75100_b = true;
                CamEventHandlerClient.roll = (float)point.roll;
                CMDCamClient.mc.field_71474_y.field_74334_X = (float)point.zoom;
                CMDCamClient.mc.field_71439_g.func_70080_a(point.x, point.y, point.z, (float)point.rotationYaw, (float)point.rotationPitch);
                CMDCamClient.mc.field_71439_g.func_70080_a(point.x, point.y - (double)CMDCamClient.mc.field_71439_g.func_70047_e(), point.z, (float)point.rotationYaw, (float)point.rotationPitch);
            } else {
                CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("The given index '" + (index + 1) + "' is too high/low!"), Util.field_240973_b_);
            }
            return 0;
        })))).then(LiteralArgumentBuilder.literal((String)"mode").then(RequiredArgumentBuilder.argument((String)"mode", (ArgumentType)CamModeArgument.mode()).executes(x -> {
            String mode;
            lastMode = mode = StringArgumentType.getString((CommandContext)x, (String)"mode");
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Changed to " + mode + " path!"), Util.field_240973_b_);
            return 0;
        })))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"target").executes(x -> {
            CamEventHandlerClient.selectEntityMode = true;
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Please select a target either an entity or a block!"), Util.field_240973_b_);
            return 0;
        })).then(RequiredArgumentBuilder.argument((String)"target", (ArgumentType)TargetArgument.target()).executes(x -> {
            String target = StringArgumentType.getString((CommandContext)x, (String)"target");
            if (target.equalsIgnoreCase("self")) {
                target = new CamTarget.SelfTarget();
                CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("The camera will point towards you!"), Util.field_240973_b_);
            } else if (target.equals("none")) {
                target = null;
                CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Removed target!"), Util.field_240973_b_);
            }
            return 0;
        })))).then(LiteralArgumentBuilder.literal((String)"interpolation").then(RequiredArgumentBuilder.argument((String)"interpolation", (ArgumentType)InterpolationArgument.interpolation()).executes(x -> {
            String interpolation;
            lastInterpolation = interpolation = StringArgumentType.getString((CommandContext)x, (String)"interpolation");
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Interpolation is set to '" + interpolation + "'!"), Util.field_240973_b_);
            return 0;
        })))).then(LiteralArgumentBuilder.literal((String)"show").then(RequiredArgumentBuilder.argument((String)"interpolation", (ArgumentType)InterpolationArgument.interpolationAll()).executes(x -> {
            String interpolation = StringArgumentType.getString((CommandContext)x, (String)"interpolation");
            CamInterpolation move = CamInterpolation.getInterpolation(interpolation);
            if (move != null) {
                move.isRenderingEnabled = true;
                CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Showing '" + interpolation + "' interpolation path!"), Util.field_240973_b_);
            } else if (interpolation.equalsIgnoreCase("all")) {
                for (CamInterpolation movement : CamInterpolation.interpolationTypes.values()) {
                    movement.isRenderingEnabled = true;
                }
                CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Showing all interpolation paths!"), Util.field_240973_b_);
            }
            return 0;
        })))).then(LiteralArgumentBuilder.literal((String)"hide").then(RequiredArgumentBuilder.argument((String)"interpolation", (ArgumentType)InterpolationArgument.interpolationAll()).executes(x -> {
            String interpolation = StringArgumentType.getString((CommandContext)x, (String)"interpolation");
            CamInterpolation move = CamInterpolation.getInterpolation(interpolation);
            if (move != null) {
                move.isRenderingEnabled = false;
                CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Hiding '" + interpolation + "' interpolation path!"), Util.field_240973_b_);
            } else if (interpolation.equalsIgnoreCase("all")) {
                for (CamInterpolation movement : CamInterpolation.interpolationTypes.values()) {
                    movement.isRenderingEnabled = false;
                }
                CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Hiding all interpolation paths!"), Util.field_240973_b_);
            }
            return 0;
        })))).then(LiteralArgumentBuilder.literal((String)"follow-speed").then(RequiredArgumentBuilder.argument((String)"factor", (ArgumentType)DoubleArgumentType.doubleArg()).executes(x -> {
            double factor;
            cameraFollowSpeed = factor = DoubleArgumentType.getDouble((CommandContext)x, (String)"factor");
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Camera follow speed is set to  '" + factor + "'. Default is 1.0!"), Util.field_240973_b_);
            return 0;
        })))).then(LiteralArgumentBuilder.literal((String)"list").executes(x -> {
            if (isInstalledOnSever) {
                CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Use /cam-server list instead!"), Util.field_240973_b_);
                return 0;
            }
            String output = "There are " + savedPaths.size() + " path(s) in total. ";
            for (String key : savedPaths.keySet()) {
                output = output + key + ", ";
            }
            CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent(output), Util.field_240973_b_);
            return 0;
        }))).then(LiteralArgumentBuilder.literal((String)"load").then(RequiredArgumentBuilder.argument((String)"path", (ArgumentType)StringArgumentType.string()).executes(x -> {
            String pathArg = StringArgumentType.getString((CommandContext)x, (String)"path");
            if (isInstalledOnSever) {
                CMDCam.NETWORK.sendToServer((CreativePacket)new GetPathPacket(pathArg));
            } else {
                CamPath path = savedPaths.get(pathArg);
                if (path != null) {
                    path.overwriteClientConfig();
                    CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Loaded path '" + pathArg + "' successfully!"), Util.field_240973_b_);
                } else {
                    CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Could not find path '" + pathArg + "'!"), Util.field_240973_b_);
                }
            }
            return 0;
        })))).then(LiteralArgumentBuilder.literal((String)"save").then(RequiredArgumentBuilder.argument((String)"path", (ArgumentType)StringArgumentType.string()).executes(x -> {
            String pathArg = StringArgumentType.getString((CommandContext)x, (String)"path");
            try {
                CamPath path = CMDCamClient.createPathFromCurrentConfiguration();
                if (isInstalledOnSever) {
                    CMDCam.NETWORK.sendToServer((CreativePacket)new SetPathPacket(pathArg, path));
                } else {
                    savedPaths.put(pathArg, path);
                    CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Saved path '" + pathArg + "' successfully!"), Util.field_240973_b_);
                }
            }
            catch (PathParseException e) {
                CMDCamClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent(e.getMessage()), Util.field_240973_b_);
            }
            return 0;
        }))))));
    }

    public static void renderBefore(RenderPlayerEvent.Pre event) {
    }

    public static CamPath getCurrentPath() {
        return currentPath;
    }

    public static void startPath(CamPath path) throws PathParseException {
        try {
            currentPath = path;
            currentPath.start((World)CMDCamClient.mc.field_71441_e);
        }
        catch (PathParseException e) {
            currentPath = null;
            throw e;
        }
    }

    public static void stopPathServer() {
        currentPath.finish((World)CMDCamClient.mc.field_71441_e);
        currentPath = null;
    }

    public static void stopPath() {
        if (CMDCamClient.currentPath.serverPath) {
            return;
        }
        currentPath.finish((World)CMDCamClient.mc.field_71441_e);
        currentPath = null;
    }

    public static void tickPath(World world, float renderTickTime) {
        currentPath.tick(world, renderTickTime);
        if (currentPath.hasFinished()) {
            currentPath = null;
        }
    }

    public static CamPath createPathFromCurrentConfiguration() throws PathParseException {
        if (points.size() < 1) {
            throw new PathParseException("You have to register at least 1 point!");
        }
        ArrayList<CamPoint> newPoints = new ArrayList<CamPoint>(points);
        if (newPoints.size() == 1) {
            newPoints.add((CamPoint)newPoints.get(0));
        }
        return new CamPath(lastLoop, lastDuration, lastMode, lastInterpolation, target, newPoints, cameraFollowSpeed);
    }

    static {
        lastLoop = 0;
        lastDuration = 10000L;
        lastMode = "default";
        lastInterpolation = "hermite";
        target = null;
        points = new ArrayList();
        cameraFollowSpeed = 1.0;
        savedPaths = new HashMap();
        isInstalledOnSever = false;
    }
}

