/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import team.creative.cmdcam.client.CMDCamClient;
import team.creative.cmdcam.client.KeyHandler;
import team.creative.cmdcam.client.PathParseException;
import team.creative.cmdcam.client.interpolation.CamInterpolation;
import team.creative.cmdcam.client.mode.CamMode;
import team.creative.cmdcam.client.mode.OutsideMode;
import team.creative.cmdcam.common.util.CamPoint;
import team.creative.cmdcam.common.util.CamTarget;
import team.creative.creativecore.common.util.math.vec.Vec3d;

public class CamEventHandlerClient {
    public static Minecraft mc = Minecraft.func_71410_x();
    public static final float amountZoom = 0.1f;
    public static final float amountroll = 0.5f;
    public static double defaultFOV = 70.0;
    public static double currentFOV;
    public static float roll;
    public static long lastRenderTime;
    public static boolean selectEntityMode;
    public static Entity camera;

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (CamEventHandlerClient.mc.field_71441_e == null) {
            CMDCamClient.isInstalledOnSever = false;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (currentFOV != CamEventHandlerClient.mc.field_71474_y.field_74334_X) {
            currentFOV = defaultFOV = CamEventHandlerClient.mc.field_71474_y.field_74334_X;
        }
        if (CamEventHandlerClient.mc.field_71439_g != null && CamEventHandlerClient.mc.field_71441_e != null) {
            if (!mc.func_147113_T()) {
                if (CMDCamClient.getCurrentPath() == null) {
                    if (KeyHandler.zoomIn.func_151470_d()) {
                        currentFOV = CamEventHandlerClient.mc.field_71439_g.func_213453_ef() ? (currentFOV -= 1.0) : (currentFOV -= (double)0.1f);
                    }
                    if (KeyHandler.zoomOut.func_151470_d()) {
                        currentFOV = CamEventHandlerClient.mc.field_71439_g.func_213453_ef() ? (currentFOV += 1.0) : (currentFOV += (double)0.1f);
                    }
                    if (KeyHandler.zoomCenter.func_151470_d()) {
                        currentFOV = defaultFOV;
                    }
                    if (KeyHandler.rollLeft.func_151470_d()) {
                        roll -= 0.5f;
                    }
                    if (KeyHandler.rollRight.func_151470_d()) {
                        roll += 0.5f;
                    }
                    if (KeyHandler.rollCenter.func_151470_d()) {
                        roll = 0.0f;
                    }
                    if (KeyHandler.pointKey.func_151468_f()) {
                        CMDCamClient.points.add(new CamPoint());
                        CamEventHandlerClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Registered " + CMDCamClient.points.size() + ". Point!"), Util.field_240973_b_);
                    }
                } else {
                    CMDCamClient.tickPath((World)CamEventHandlerClient.mc.field_71441_e, event.renderTickTime);
                }
                if (KeyHandler.startStop.func_151468_f()) {
                    if (CMDCamClient.getCurrentPath() != null) {
                        CMDCamClient.stopPath();
                    } else {
                        try {
                            CMDCamClient.startPath(CMDCamClient.createPathFromCurrentConfiguration());
                        }
                        catch (PathParseException e) {
                            CamEventHandlerClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent(e.getMessage()), Util.field_240973_b_);
                        }
                    }
                }
                while (KeyHandler.clearPoint.func_151468_f()) {
                    CMDCamClient.points.clear();
                    CamEventHandlerClient.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Cleared all registered points!"), Util.field_240973_b_);
                }
            }
            CamEventHandlerClient.mc.field_71474_y.field_74334_X = currentFOV;
        }
        lastRenderTime = System.nanoTime();
    }

    @SubscribeEvent
    public void worldRender(RenderWorldLastEvent event) {
        boolean shouldRender = false;
        for (CamInterpolation movement : CamInterpolation.interpolationTypes.values()) {
            if (!movement.isRenderingEnabled) continue;
            shouldRender = true;
            break;
        }
        if (CMDCamClient.getCurrentPath() == null && shouldRender && CMDCamClient.points.size() > 0) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            RenderSystem.disableTexture();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableDepthTest();
            ActiveRenderInfo activerenderinfo = TileEntityRendererDispatcher.field_147556_a.field_217666_g;
            Vector3f view = activerenderinfo.func_227996_l_();
            for (int i = 0; i < CMDCamClient.points.size(); ++i) {
                CamPoint point = CMDCamClient.points.get(i);
                RenderSystem.pushMatrix();
                MatrixStack mat = event.getMatrixStack();
                mat.func_227860_a_();
                mat.func_227861_a_((double)(-view.func_195899_a()), (double)(-view.func_195900_b()), (double)(-view.func_195902_c()));
                RenderSystem.multMatrix((Matrix4f)mat.func_227866_c_().func_227870_a_());
                DebugRenderer.func_217732_a((String)(i + 1 + ""), (double)(point.x + (double)view.func_195899_a()), (double)(point.y + 0.2 + (double)view.func_195900_b()), (double)(point.z + (double)view.func_195902_c()), (int)-1);
                DebugRenderer.func_217733_a((double)(point.x - 0.05), (double)(point.y - 0.05), (double)(point.z - 0.05), (double)(point.x + 0.05), (double)(point.y + 0.05), (double)(point.z + 0.05), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.depthMask((boolean)false);
                RenderSystem.disableLighting();
                RenderSystem.disableTexture();
                mat.func_227865_b_();
                RenderSystem.popMatrix();
            }
            for (CamInterpolation movement : CamInterpolation.interpolationTypes.values()) {
                if (!movement.isRenderingEnabled) continue;
                this.renderMovement(event.getMatrixStack(), movement, new ArrayList<CamPoint>(CMDCamClient.points));
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableTexture();
            RenderSystem.enableBlend();
            RenderSystem.clearCurrentColor();
        }
    }

    public void renderMovement(MatrixStack mat, CamInterpolation movement, ArrayList<CamPoint> points) {
        try {
            movement.initMovement(points, 0, CMDCamClient.target);
        }
        catch (PathParseException e) {
            return;
        }
        double steps = 20 * (points.size() - 1);
        ActiveRenderInfo activerenderinfo = TileEntityRendererDispatcher.field_147556_a.field_217666_g;
        Vector3f view = activerenderinfo.func_227996_l_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        mat.func_227860_a_();
        RenderSystem.lineWidth((float)1.0f);
        mat.func_227861_a_((double)(-view.func_195899_a()), (double)(-view.func_195900_b()), (double)(-view.func_195902_c()));
        Vec3d color = movement.getColor();
        bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        int i = 0;
        while ((double)i < steps) {
            CamPoint pos = CamMode.getPoint(movement, points, (double)i / steps, 0, 0);
            bufferbuilder.func_227888_a_(mat.func_227866_c_().func_227870_a_(), (float)pos.x, (float)pos.y, (float)pos.z).func_227885_a_((float)color.x, (float)color.y, (float)color.z, 1.0f).func_181675_d();
            ++i;
        }
        bufferbuilder.func_227888_a_(mat.func_227866_c_().func_227870_a_(), (float)points.get((int)(points.size() - 1)).x, (float)points.get((int)(points.size() - 1)).y, (float)points.get((int)(points.size() - 1)).z).func_227885_a_((float)color.x, (float)color.y, (float)color.z, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        mat.func_227865_b_();
    }

    @SubscribeEvent
    public void cameraRoll(EntityViewRenderEvent.CameraSetup event) {
        event.setRoll(roll);
    }

    public static boolean isCurrentViewEntity() {
        if (CamEventHandlerClient.isPathActive()) {
            return true;
        }
        return CamEventHandlerClient.mc.field_175622_Z == CamEventHandlerClient.mc.field_71439_g;
    }

    public static boolean isPathActive() {
        return CMDCamClient.getCurrentPath() != null;
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!selectEntityMode || !event.getWorld().field_72995_K) {
            return;
        }
        if (event instanceof PlayerInteractEvent.EntityInteract) {
            CMDCamClient.target = new CamTarget.EntityTarget(((PlayerInteractEvent.EntityInteract)event).getTarget());
            event.getPlayer().func_145747_a((ITextComponent)new StringTextComponent("Target is set to " + ((PlayerInteractEvent.EntityInteract)event).getTarget().func_189512_bd() + "."), Util.field_240973_b_);
            selectEntityMode = false;
        }
        if (event instanceof PlayerInteractEvent.RightClickBlock) {
            CMDCamClient.target = new CamTarget.BlockTarget(event.getPos());
            event.getPlayer().func_145747_a((ITextComponent)new StringTextComponent("Target is set to " + event.getPos() + "."), Util.field_240973_b_);
            selectEntityMode = false;
        }
    }

    public static void setupMouseHandlerBefore() {
        if (CMDCamClient.getCurrentPath() != null && CMDCamClient.getCurrentPath().cachedMode instanceof OutsideMode) {
            camera = CamEventHandlerClient.mc.field_175622_Z;
            CamEventHandlerClient.mc.field_175622_Z = CamEventHandlerClient.mc.field_71439_g;
        }
    }

    public static void setupMouseHandlerAfter() {
        if (CMDCamClient.getCurrentPath() != null && CMDCamClient.getCurrentPath().cachedMode instanceof OutsideMode) {
            CamEventHandlerClient.mc.field_175622_Z = camera;
            camera = null;
        }
    }

    static {
        roll = 0.0f;
        selectEntityMode = false;
        camera = null;
    }
}

