/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.util.interpolation;

import team.creative.cmdcam.common.util.interpolation.Interpolation;
import team.creative.creativecore.common.util.math.vec.VecNd;

public class CubicInterpolation<T extends VecNd>
extends Interpolation<T> {
    public T beginVec;
    public T endVec;

    public CubicInterpolation(double[] times, T[] points) {
        super(times, points);
        this.beginVec = points[0].copy();
        this.beginVec.sub(points[1]);
        this.beginVec.add(points[0]);
        this.endVec = points[points.length - 1].copy();
        this.endVec.sub(points[points.length - 2]);
        this.endVec.add(points[points.length - 1]);
    }

    public CubicInterpolation(T ... points) {
        super(points);
        this.beginVec = points[0].copy();
        this.beginVec.sub(points[1]);
        this.beginVec.add(points[0]);
        this.endVec = points[points.length - 1].copy();
        this.endVec.sub(points[points.length - 2]);
        this.endVec.add(points[points.length - 1]);
    }

    @Override
    protected double getValue(int index, int dim) {
        if (index < 0) {
            return this.beginVec.get(dim);
        }
        if (index >= this.points.size()) {
            return this.endVec.get(dim);
        }
        return ((VecNd)this.pointVecs.get(index)).get(dim);
    }

    @Override
    public double valueAt(double mu, int pointIndex, int pointIndexNext, int dim) {
        double v0 = this.getValue(pointIndex - 1, dim);
        double v1 = this.getValue(pointIndex, dim);
        double v2 = this.getValue(pointIndexNext, dim);
        double v3 = this.getValue(pointIndexNext + 1, dim);
        double mu2 = mu * mu;
        double a0 = v3 - v2 - v0 + v1;
        double a1 = v0 - v1 - a0;
        double a2 = v2 - v0;
        double a3 = v1;
        return a0 * mu * mu2 + a1 * mu2 + a2 * mu + a3;
    }
}

