/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import team.creative.cmdcam.client.CMDCamClient;
import team.creative.cmdcam.client.KeyHandler;
import team.creative.cmdcam.client.PathParseException;
import team.creative.cmdcam.client.interpolation.CamInterpolation;
import team.creative.cmdcam.client.mode.CamMode;
import team.creative.cmdcam.client.mode.OutsideMode;
import team.creative.cmdcam.common.util.CamPoint;
import team.creative.cmdcam.common.util.CamTarget;
import team.creative.creativecore.common.util.math.vec.Vec3d;

public class CamEventHandlerClient {
    public static Minecraft mc = Minecraft.m_91087_();
    public static final float amountZoom = 0.1f;
    public static final float amountroll = 0.5f;
    public static double defaultFOV = 70.0;
    public static double currentFOV;
    public static float roll;
    public static long lastRenderTime;
    public static boolean selectEntityMode;
    public static Entity camera;

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (CamEventHandlerClient.mc.f_91073_ == null) {
            CMDCamClient.isInstalledOnSever = false;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (currentFOV != CamEventHandlerClient.mc.f_91066_.f_92068_) {
            currentFOV = defaultFOV = CamEventHandlerClient.mc.f_91066_.f_92068_;
        }
        if (CamEventHandlerClient.mc.f_91074_ != null && CamEventHandlerClient.mc.f_91073_ != null) {
            if (!mc.m_91104_()) {
                if (CMDCamClient.getCurrentPath() == null) {
                    if (KeyHandler.zoomIn.m_90857_()) {
                        currentFOV = CamEventHandlerClient.mc.f_91074_.m_6047_() ? (currentFOV -= 1.0) : (currentFOV -= (double)0.1f);
                    }
                    if (KeyHandler.zoomOut.m_90857_()) {
                        currentFOV = CamEventHandlerClient.mc.f_91074_.m_6047_() ? (currentFOV += 1.0) : (currentFOV += (double)0.1f);
                    }
                    if (KeyHandler.zoomCenter.m_90857_()) {
                        currentFOV = defaultFOV;
                    }
                    if (KeyHandler.rollLeft.m_90857_()) {
                        roll -= 0.5f;
                    }
                    if (KeyHandler.rollRight.m_90857_()) {
                        roll += 0.5f;
                    }
                    if (KeyHandler.rollCenter.m_90857_()) {
                        roll = 0.0f;
                    }
                    if (KeyHandler.pointKey.m_90859_()) {
                        CMDCamClient.points.add(new CamPoint());
                        CamEventHandlerClient.mc.f_91074_.m_6352_((Component)new TextComponent("Registered " + CMDCamClient.points.size() + ". Point!"), Util.f_137441_);
                    }
                } else {
                    CMDCamClient.tickPath((Level)CamEventHandlerClient.mc.f_91073_, event.renderTickTime);
                }
                if (KeyHandler.startStop.m_90859_()) {
                    if (CMDCamClient.getCurrentPath() != null) {
                        CMDCamClient.stopPath();
                    } else {
                        try {
                            CMDCamClient.startPath(CMDCamClient.createPathFromCurrentConfiguration());
                        }
                        catch (PathParseException e) {
                            CamEventHandlerClient.mc.f_91074_.m_6352_((Component)new TextComponent(e.getMessage()), Util.f_137441_);
                        }
                    }
                }
                while (KeyHandler.clearPoint.m_90859_()) {
                    CMDCamClient.points.clear();
                    CamEventHandlerClient.mc.f_91074_.m_6352_((Component)new TextComponent("Cleared all registered points!"), Util.f_137441_);
                }
            }
            CamEventHandlerClient.mc.f_91066_.f_92068_ = currentFOV;
        }
        lastRenderTime = System.nanoTime();
    }

    @SubscribeEvent
    public void worldRender(RenderWorldLastEvent event) {
        boolean shouldRender = false;
        for (CamInterpolation movement : CamInterpolation.interpolationTypes.values()) {
            if (!movement.isRenderingEnabled) continue;
            shouldRender = true;
            break;
        }
        if (CMDCamClient.getCurrentPath() == null && shouldRender && CMDCamClient.points.size() > 0) {
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.m_69472_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69482_();
            Vec3 view = CamEventHandlerClient.mc.f_91063_.m_109153_().m_90583_();
            RenderSystem.m_157425_((Matrix4f)event.getProjectionMatrix());
            PoseStack mat = RenderSystem.m_157191_();
            mat.m_85836_();
            mat.m_166856_();
            mat.m_166854_(event.getMatrixStack().m_85850_().m_85861_());
            mat.m_85837_(-view.m_7096_(), -view.m_7098_(), -view.m_7094_());
            RenderSystem.m_157182_();
            for (int i = 0; i < CMDCamClient.points.size(); ++i) {
                CamPoint point = CMDCamClient.points.get(i);
                DebugRenderer.m_113477_((String)("" + (i + 1)), (double)(point.x + view.f_82479_), (double)(point.y + 0.2 + view.f_82480_), (double)(point.z + view.f_82481_), (int)-1);
                DebugRenderer.m_113435_((double)(point.x - 0.05), (double)(point.y - 0.05), (double)(point.z - 0.05), (double)(point.x + 0.05), (double)(point.y + 0.05), (double)(point.z + 0.05), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_69458_((boolean)false);
                RenderSystem.m_69472_();
            }
            for (CamInterpolation movement : CamInterpolation.interpolationTypes.values()) {
                if (!movement.isRenderingEnabled) continue;
                this.renderMovement(mat, movement, new ArrayList<CamPoint>(CMDCamClient.points));
            }
            mat.m_85849_();
            RenderSystem.m_157182_();
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69493_();
            RenderSystem.m_69478_();
        }
    }

    public void renderMovement(PoseStack mat, CamInterpolation movement, ArrayList<CamPoint> points) {
        try {
            movement.initMovement(points, 0, CMDCamClient.target);
        }
        catch (PathParseException e) {
            return;
        }
        double steps = 20 * (points.size() - 1);
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69464_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69472_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        RenderSystem.m_69832_((float)1.0f);
        Vec3d color = movement.getColor();
        bufferbuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        int i = 0;
        while ((double)i < steps) {
            CamPoint pos = CamMode.getPoint(movement, points, (double)i / steps, 0, 0);
            bufferbuilder.m_5483_((double)((float)pos.x), (double)((float)pos.y), (double)((float)pos.z)).m_85950_((float)color.x, (float)color.y, (float)color.z, 1.0f).m_5752_();
            ++i;
        }
        bufferbuilder.m_5483_((double)((float)points.get((int)(points.size() - 1)).x), (double)((float)points.get((int)(points.size() - 1)).y), (double)((float)points.get((int)(points.size() - 1)).z)).m_85950_((float)color.x, (float)color.y, (float)color.z, 1.0f).m_5752_();
        tessellator.m_85914_();
    }

    @SubscribeEvent
    public void cameraRoll(EntityViewRenderEvent.CameraSetup event) {
        event.setRoll(roll);
    }

    public static boolean isCurrentViewEntity() {
        if (CamEventHandlerClient.isPathActive()) {
            return true;
        }
        return CamEventHandlerClient.mc.f_91075_ == CamEventHandlerClient.mc.f_91074_;
    }

    public static boolean isPathActive() {
        return CMDCamClient.getCurrentPath() != null;
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!selectEntityMode || !event.getWorld().f_46443_) {
            return;
        }
        if (event instanceof PlayerInteractEvent.EntityInteract) {
            CMDCamClient.target = new CamTarget.EntityTarget(((PlayerInteractEvent.EntityInteract)event).getTarget());
            event.getPlayer().m_6352_((Component)new TextComponent("Target is set to " + ((PlayerInteractEvent.EntityInteract)event).getTarget().m_20149_() + "."), Util.f_137441_);
            selectEntityMode = false;
        }
        if (event instanceof PlayerInteractEvent.RightClickBlock) {
            CMDCamClient.target = new CamTarget.BlockTarget(event.getPos());
            event.getPlayer().m_6352_((Component)new TextComponent("Target is set to " + event.getPos() + "."), Util.f_137441_);
            selectEntityMode = false;
        }
    }

    public static void setupMouseHandlerBefore() {
        if (CMDCamClient.getCurrentPath() != null && CMDCamClient.getCurrentPath().cachedMode instanceof OutsideMode) {
            camera = CamEventHandlerClient.mc.f_91075_;
            CamEventHandlerClient.mc.f_91075_ = CamEventHandlerClient.mc.f_91074_;
        }
    }

    public static void setupMouseHandlerAfter() {
        if (CMDCamClient.getCurrentPath() != null && CMDCamClient.getCurrentPath().cachedMode instanceof OutsideMode) {
            CamEventHandlerClient.mc.f_91075_ = camera;
            camera = null;
        }
    }

    static {
        roll = 0.0f;
        selectEntityMode = false;
        camera = null;
    }
}

