/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.client.interpolation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.cmdcam.client.PathParseException;
import team.creative.cmdcam.client.interpolation.HermiteMovement;
import team.creative.cmdcam.common.util.CamPoint;
import team.creative.cmdcam.common.util.CamTarget;
import team.creative.cmdcam.common.util.interpolation.HermiteInterpolation;
import team.creative.creativecore.common.util.math.matrix.Matrix3;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.VecNd;

public class CircularMovement
extends HermiteMovement {
    private static Minecraft mc = Minecraft.m_91087_();
    public Vec3d sphereOrigin;
    public double radius;
    public CamTarget target;
    public HermiteInterpolation<Vec1d> yAxis;

    @Override
    public void initMovement(List<CamPoint> points, int loops, CamTarget target) throws PathParseException {
        ArrayList<CamPoint> newPointsSorted;
        ArrayList<Double> times;
        ArrayList<Vec1d> vecs;
        Vec3d firstPoint;
        if (target == null) {
            throw new PathParseException("No target found");
        }
        Vec3 center = target.getTargetVec((Level)CircularMovement.mc.f_91073_, mc.m_91297_());
        if (center != null) {
            points.add(points.get(0));
            this.target = target;
            firstPoint = new Vec3d(points.get((int)0).x, points.get((int)0).y, points.get((int)0).z);
            Vec3d centerPoint = new Vec3d(center.f_82479_, center.f_82480_, center.f_82481_);
            this.sphereOrigin = new Vec3d(firstPoint);
            this.sphereOrigin.sub(centerPoint);
            this.radius = this.sphereOrigin.length();
            vecs = new ArrayList<Vec1d>();
            times = new ArrayList<Double>();
            times.add(0.0);
            vecs.add(new Vec1d(firstPoint.y));
            newPointsSorted = new ArrayList<CamPoint>();
            newPointsSorted.add(points.get(0));
            for (int i = 1; i < points.size() - 1; ++i) {
                Vec3d point = new Vec3d(points.get((int)i).x, firstPoint.y, points.get((int)i).z);
                point.sub(centerPoint);
                double dot = point.dot(this.sphereOrigin);
                double det = point.x * this.sphereOrigin.z - point.z * this.sphereOrigin.x;
                double angle = Math.toDegrees(Math.atan2(det, dot));
                if (angle < 0.0) {
                    angle += 360.0;
                }
                double time = angle / 360.0;
                for (int j = 0; j < times.size(); ++j) {
                    if (!((Double)times.get(j) > time)) continue;
                    times.add(j, time);
                    vecs.add(j, new Vec1d(points.get((int)i).y));
                    newPointsSorted.add(j, points.get(i));
                    break;
                }
                newPointsSorted.add(points.get(i));
                times.add(time);
                vecs.add(new Vec1d(points.get((int)i).y));
            }
            if (loops == 0) {
                newPointsSorted.add(((CamPoint)newPointsSorted.get(0)).copy());
            }
        } else {
            throw new PathParseException("Invalid target");
        }
        times.add(1.0);
        vecs.add(new Vec1d(firstPoint.y));
        this.yAxis = new HermiteInterpolation(ArrayUtils.toPrimitive((Double[])times.toArray(new Double[0])), (VecNd[])vecs.toArray(new Vec1d[0]));
        super.initMovement(times.toArray(new Double[0]), newPointsSorted, loops, target);
    }

    @Override
    public CamPoint getPointInBetween(CamPoint point1, CamPoint point2, double percent, double wholeProgress, boolean isFirstLoop, boolean isLastLoop) {
        CamPoint newCamPoint = super.getPointInBetween(point1, point2, percent, wholeProgress, isFirstLoop, isLastLoop);
        double angle = wholeProgress * 360.0;
        Vec3 center = this.target.getTargetVec((Level)CircularMovement.mc.f_91073_, mc.m_91297_());
        if (center != null) {
            Vec3d centerPoint = new Vec3d(center.f_82479_, center.f_82480_, center.f_82481_);
            Vec3d newPoint = new Vec3d(this.sphereOrigin);
            newPoint.y = 0.0;
            Matrix3 matrix = new Matrix3();
            matrix.rotY(Math.toRadians(angle));
            matrix.transform(newPoint);
            newPoint.y = ((Vec1d)this.yAxis.valueAt((double)wholeProgress)).x - center.f_82480_;
            newPoint.normalize();
            newPoint.scale(this.radius);
            newPoint.add(centerPoint);
            newCamPoint.x = newPoint.x;
            newCamPoint.y = newPoint.y;
            newCamPoint.z = newPoint.z;
        }
        return newCamPoint;
    }

    @Override
    public Vec3d getColor() {
        return new Vec3d(1.0, 1.0, 0.0);
    }
}

