/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.cmdcam.client.CMDCamClient;
import team.creative.cmdcam.common.command.argument.CamModeArgument;
import team.creative.cmdcam.common.command.argument.DurationArgument;
import team.creative.cmdcam.common.command.argument.InterpolationArgument;
import team.creative.cmdcam.common.command.argument.TargetArgument;
import team.creative.cmdcam.common.packet.ConnectPacket;
import team.creative.cmdcam.common.packet.GetPathPacket;
import team.creative.cmdcam.common.packet.SetPathPacket;
import team.creative.cmdcam.common.packet.StartPathPacket;
import team.creative.cmdcam.common.packet.StopPathPacket;
import team.creative.cmdcam.common.util.CamPath;
import team.creative.cmdcam.server.CMDCamServer;
import team.creative.cmdcam.server.CamEventHandler;
import team.creative.creativecore.common.network.CreativeNetwork;
import team.creative.creativecore.common.network.CreativePacket;

@Mod(value="cmdcam")
public class CMDCam {
    public static final String MODID = "cmdcam";
    private static final Logger LOGGER = LogManager.getLogger((String)"cmdcam");
    public static final CreativeNetwork NETWORK = new CreativeNetwork("1.0", LOGGER, new ResourceLocation("cmdcam", "main"));

    public CMDCam() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::client));
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void client(FMLClientSetupEvent event) {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        CMDCamClient.init(event);
    }

    private void init(FMLCommonSetupEvent event) {
        NETWORK.registerType(ConnectPacket.class, ConnectPacket::new);
        NETWORK.registerType(GetPathPacket.class, GetPathPacket::new);
        NETWORK.registerType(SetPathPacket.class, SetPathPacket::new);
        NETWORK.registerType(StartPathPacket.class, StartPathPacket::new);
        NETWORK.registerType(StopPathPacket.class, StopPathPacket::new);
        ArgumentTypes.m_121601_((String)"duration", DurationArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(() -> DurationArgument.duration()));
        ArgumentTypes.m_121601_((String)"cameramode", CamModeArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(() -> CamModeArgument.mode()));
        ArgumentTypes.m_121601_((String)"cameratarget", TargetArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(() -> TargetArgument.target()));
        ArgumentTypes.m_121601_((String)"interpolation", InterpolationArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(() -> InterpolationArgument.interpolation()));
        ArgumentTypes.m_121601_((String)"allinterpolation", InterpolationArgument.AllInterpolationArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(() -> InterpolationArgument.interpolationAll()));
        MinecraftForge.EVENT_BUS.register((Object)new CamEventHandler());
    }

    private void serverStarting(ServerStartingEvent event) {
        event.getServer().m_129892_().m_82094_().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cam-server").executes(x -> {
            ((CommandSourceStack)x.getSource()).m_81354_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam-server start <player> <path> [time|ms|s|m|h|d] [loops (-1 -> endless)] " + ChatFormatting.RED + "starts the animation"), false);
            ((CommandSourceStack)x.getSource()).m_81354_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam-server stop <player> " + ChatFormatting.RED + "stops the animation"), false);
            ((CommandSourceStack)x.getSource()).m_81354_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam-server list " + ChatFormatting.RED + "lists all saved paths"), false);
            ((CommandSourceStack)x.getSource()).m_81354_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam-server remove <name> " + ChatFormatting.RED + "removes the given path"), false);
            ((CommandSourceStack)x.getSource()).m_81354_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam-server clear " + ChatFormatting.RED + "clears all saved paths"), false);
            return 0;
        })).then(Commands.m_82127_((String)"start").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(x -> {
            Collection players = EntityArgument.m_91477_((CommandContext)x, (String)"players");
            if (players.isEmpty()) {
                return 0;
            }
            String pathName = StringArgumentType.getString((CommandContext)x, (String)"name");
            CamPath path = CMDCamServer.getPath((Level)((CommandSourceStack)x.getSource()).m_81372_(), pathName);
            if (path != null) {
                StartPathPacket packet = new StartPathPacket(path);
                for (ServerPlayer player : players) {
                    NETWORK.sendToClient((CreativePacket)packet, player);
                }
            } else {
                ((CommandSourceStack)x.getSource()).m_81354_((Component)new TextComponent("Path '" + pathName + "' could not be found!"), true);
            }
            return 0;
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"duration", (ArgumentType)DurationArgument.duration()).executes(x -> {
            Collection players = EntityArgument.m_91477_((CommandContext)x, (String)"players");
            if (players.isEmpty()) {
                return 0;
            }
            String pathName = StringArgumentType.getString((CommandContext)x, (String)"name");
            CamPath path = CMDCamServer.getPath((Level)((CommandSourceStack)x.getSource()).m_81372_(), pathName);
            if (path != null) {
                path = path.copy();
                long duration = DurationArgument.getDuration(x, "duration");
                if (duration > 0L) {
                    path.duration = duration;
                }
                StartPathPacket packet = new StartPathPacket(path);
                for (ServerPlayer player : players) {
                    NETWORK.sendToClient((CreativePacket)packet, player);
                }
            } else {
                ((CommandSourceStack)x.getSource()).m_81354_((Component)new TextComponent("Path '" + pathName + "' could not be found!"), true);
            }
            return 0;
        })).then(Commands.m_82129_((String)"loop", (ArgumentType)IntegerArgumentType.integer((int)-1)).executes(x -> {
            Collection players = EntityArgument.m_91477_((CommandContext)x, (String)"players");
            if (players.isEmpty()) {
                return 0;
            }
            String pathName = StringArgumentType.getString((CommandContext)x, (String)"name");
            CamPath path = CMDCamServer.getPath((Level)((CommandSourceStack)x.getSource()).m_81372_(), pathName);
            if (path != null) {
                path = path.copy();
                long duration = DurationArgument.getDuration(x, "duration");
                if (duration > 0L) {
                    path.duration = duration;
                }
                path.loop = IntegerArgumentType.getInteger((CommandContext)x, (String)"loop");
                StartPathPacket packet = new StartPathPacket(path);
                for (ServerPlayer player : players) {
                    NETWORK.sendToClient((CreativePacket)packet, player);
                }
            } else {
                ((CommandSourceStack)x.getSource()).m_81354_((Component)new TextComponent("Path '" + pathName + "' could not be found!"), true);
            }
            return 0;
        }))))))).then(Commands.m_82127_((String)"stop").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(x -> {
            StopPathPacket packet = new StopPathPacket();
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)x, (String)"players")) {
                NETWORK.sendToClient((CreativePacket)packet, player);
            }
            return 0;
        })))).then(Commands.m_82127_((String)"list").executes(x -> {
            Collection<String> names = CMDCamServer.getSavedPaths((Level)((CommandSourceStack)x.getSource()).m_81372_());
            String output = "There are " + names.size() + " path(s) in total. ";
            for (String key : names) {
                output = output + key + ", ";
            }
            ((CommandSourceStack)x.getSource()).m_81354_((Component)new TextComponent(output), true);
            return 0;
        }))).then(Commands.m_82127_((String)"clear").executes(x -> {
            CMDCamServer.clearPaths((Level)((CommandSourceStack)x.getSource()).m_81372_());
            ((CommandSourceStack)x.getSource()).m_81354_((Component)new TextComponent("Removed all existing paths (in this world)!"), true);
            return 0;
        }))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(x -> {
            String path = StringArgumentType.getString((CommandContext)x, (String)"name");
            if (CMDCamServer.removePath((Level)((CommandSourceStack)x.getSource()).m_81372_(), path)) {
                ((CommandSourceStack)x.getSource()).m_81354_((Component)new TextComponent("Path '" + path + "' has been removed!"), true);
            } else {
                ((CommandSourceStack)x.getSource()).m_81354_((Component)new TextComponent("Path '" + path + "' could not be found!"), true);
            }
            return 0;
        }))));
    }
}

