/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.client;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import team.creative.cmdcam.CMDCam;
import team.creative.cmdcam.client.CamEventHandlerClient;
import team.creative.cmdcam.client.KeyHandler;
import team.creative.cmdcam.client.PathParseException;
import team.creative.cmdcam.client.interpolation.CamInterpolation;
import team.creative.cmdcam.common.command.argument.CamModeArgument;
import team.creative.cmdcam.common.command.argument.DurationArgument;
import team.creative.cmdcam.common.command.argument.InterpolationArgument;
import team.creative.cmdcam.common.command.argument.TargetArgument;
import team.creative.cmdcam.common.packet.GetPathPacket;
import team.creative.cmdcam.common.packet.SetPathPacket;
import team.creative.cmdcam.common.util.CamPath;
import team.creative.cmdcam.common.util.CamPoint;
import team.creative.cmdcam.common.util.CamTarget;
import team.creative.creativecore.client.command.ClientCommandRegistry;
import team.creative.creativecore.common.network.CreativePacket;

public class CMDCamClient {
    public static Minecraft mc;
    public static int lastLoop;
    public static long lastDuration;
    public static String lastMode;
    public static String lastInterpolation;
    public static CamTarget target;
    public static ArrayList<CamPoint> points;
    public static double cameraFollowSpeed;
    public static HashMap<String, CamPath> savedPaths;
    public static boolean isInstalledOnSever;
    private static CamPath currentPath;

    public static void init(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new CamEventHandlerClient());
        mc = Minecraft.m_91087_();
        KeyHandler.initKeys();
        event.enqueueWork(() -> ClientCommandRegistry.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"cam").executes(x -> {
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam add [number] " + ChatFormatting.RED + "register a point at the current position"), Util.f_137441_);
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam clear " + ChatFormatting.RED + "delete all registered points"), Util.f_137441_);
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam start [time|ms|s|m|h|d] [loops (-1 -> endless)] " + ChatFormatting.RED + "starts the animation"), Util.f_137441_);
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam stop " + ChatFormatting.RED + "stops the animation"), Util.f_137441_);
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam goto <index> " + ChatFormatting.RED + "tp to the given point"), Util.f_137441_);
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam set <index> " + ChatFormatting.RED + "updates point to current location"), Util.f_137441_);
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam remove <index> " + ChatFormatting.RED + "removes the given point"), Util.f_137441_);
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam target <none:self> " + ChatFormatting.RED + "set the camera target"), Util.f_137441_);
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam mode <default:outside> " + ChatFormatting.RED + "set current mode"), Util.f_137441_);
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam interpolation <" + String.join((CharSequence)":", CamInterpolation.getMovementNames()) + "> " + ChatFormatting.RED + "set the camera interpolation"), Util.f_137441_);
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam follow-speed <number> " + ChatFormatting.RED + "default is 1.0"), Util.f_137441_);
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam show <all:" + String.join((CharSequence)":", CamInterpolation.getMovementNames()) + "> " + ChatFormatting.RED + "shows the path using the given interpolation"), Util.f_137441_);
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam hide <all:" + String.join((CharSequence)":", CamInterpolation.getMovementNames()) + "> " + ChatFormatting.RED + "hides the path using the given interpolation"), Util.f_137441_);
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam save <name> " + ChatFormatting.RED + "saves the current path (including settings) with the given name"), Util.f_137441_);
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam load <name> " + ChatFormatting.RED + "tries to load the saved path with the given name"), Util.f_137441_);
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam list " + ChatFormatting.RED + "lists all saved paths"), Util.f_137441_);
            return 0;
        })).then(LiteralArgumentBuilder.literal((String)"clear").executes(x -> {
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("Cleared all registered points!"), Util.f_137441_);
            points.clear();
            return 0;
        }))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"add").executes(x -> {
            points.add(new CamPoint());
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("Registered " + points.size() + ". Point!"), Util.f_137441_);
            return 0;
        })).then(RequiredArgumentBuilder.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(x -> {
            Integer index;
            Integer n = index = Integer.valueOf(IntegerArgumentType.getInteger((CommandContext)x, (String)"index"));
            index = index - 1;
            if (index >= 0 && index < points.size()) {
                points.add(index, new CamPoint());
                CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("Inserted " + index + ". Point!"), Util.f_137441_);
            } else {
                CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("The given index '" + index + "' is too high/low!"), Util.f_137441_);
            }
            return 0;
        })))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"start").executes(x -> {
            try {
                CMDCamClient.startPath(CMDCamClient.createPathFromCurrentConfiguration());
            }
            catch (PathParseException e) {
                CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(e.getMessage()), Util.f_137441_);
            }
            return 0;
        })).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"duration", (ArgumentType)DurationArgument.duration()).executes(x -> {
            try {
                long duration = DurationArgument.getDuration(x, "duration");
                if (duration > 0L) {
                    lastDuration = duration;
                }
                CMDCamClient.startPath(CMDCamClient.createPathFromCurrentConfiguration());
            }
            catch (PathParseException e) {
                CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(e.getMessage()), Util.f_137441_);
            }
            return 0;
        })).then(RequiredArgumentBuilder.argument((String)"loop", (ArgumentType)IntegerArgumentType.integer((int)-1)).executes(x -> {
            try {
                long duration = DurationArgument.getDuration(x, "duration");
                if (duration > 0L) {
                    lastDuration = duration;
                }
                lastLoop = IntegerArgumentType.getInteger((CommandContext)x, (String)"loop");
                CMDCamClient.startPath(CMDCamClient.createPathFromCurrentConfiguration());
            }
            catch (PathParseException e) {
                CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(e.getMessage()), Util.f_137441_);
            }
            return 0;
        }))))).then(LiteralArgumentBuilder.literal((String)"stop").executes(x -> {
            CMDCamClient.stopPath();
            return 0;
        }))).then(LiteralArgumentBuilder.literal((String)"remove").then(RequiredArgumentBuilder.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(x -> {
            Integer index;
            Integer n = index = Integer.valueOf(IntegerArgumentType.getInteger((CommandContext)x, (String)"index"));
            index = index - 1;
            if (index >= 0 && index < points.size()) {
                points.remove(index);
                CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("Removed " + (index + 1) + ". point!"), Util.f_137441_);
            } else {
                CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("The given index '" + index + "' is too high/low!"), Util.f_137441_);
            }
            return 0;
        })))).then(LiteralArgumentBuilder.literal((String)"set").then(RequiredArgumentBuilder.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(x -> {
            Integer index;
            Integer n = index = Integer.valueOf(IntegerArgumentType.getInteger((CommandContext)x, (String)"index"));
            index = index - 1;
            if (index >= 0 && index < points.size()) {
                points.set(index, new CamPoint());
                CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("Updated " + (index + 1) + ". point!"), Util.f_137441_);
            } else {
                CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("The given index '" + index + "' is too high/low!"), Util.f_137441_);
            }
            return 0;
        })))).then(LiteralArgumentBuilder.literal((String)"goto").then(RequiredArgumentBuilder.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(x -> {
            Integer index;
            Integer n = index = Integer.valueOf(IntegerArgumentType.getInteger((CommandContext)x, (String)"index"));
            index = index - 1;
            if (index >= 0 && index < points.size()) {
                CamPoint point = points.get(index);
                CMDCamClient.mc.f_91074_.m_150110_().f_35935_ = true;
                CamEventHandlerClient.roll = (float)point.roll;
                CMDCamClient.mc.f_91066_.f_92068_ = (float)point.zoom;
                CMDCamClient.mc.f_91074_.m_19890_(point.x, point.y, point.z, (float)point.rotationYaw, (float)point.rotationPitch);
                CMDCamClient.mc.f_91074_.m_19890_(point.x, point.y - (double)CMDCamClient.mc.f_91074_.m_20192_(), point.z, (float)point.rotationYaw, (float)point.rotationPitch);
            } else {
                CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("The given index '" + (index + 1) + "' is too high/low!"), Util.f_137441_);
            }
            return 0;
        })))).then(LiteralArgumentBuilder.literal((String)"mode").then(RequiredArgumentBuilder.argument((String)"mode", (ArgumentType)CamModeArgument.mode()).executes(x -> {
            String mode;
            lastMode = mode = StringArgumentType.getString((CommandContext)x, (String)"mode");
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("Changed to " + mode + " path!"), Util.f_137441_);
            return 0;
        })))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"target").executes(x -> {
            CamEventHandlerClient.selectEntityMode = true;
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("Please select a target either an entity or a block!"), Util.f_137441_);
            return 0;
        })).then(RequiredArgumentBuilder.argument((String)"target", (ArgumentType)TargetArgument.target()).executes(x -> {
            String target = StringArgumentType.getString((CommandContext)x, (String)"target");
            if (target.equalsIgnoreCase("self")) {
                target = new CamTarget.SelfTarget();
                CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("The camera will point towards you!"), Util.f_137441_);
            } else if (target.equals("none")) {
                target = null;
                CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("Removed target!"), Util.f_137441_);
            }
            return 0;
        })))).then(LiteralArgumentBuilder.literal((String)"interpolation").then(RequiredArgumentBuilder.argument((String)"interpolation", (ArgumentType)InterpolationArgument.interpolation()).executes(x -> {
            String interpolation;
            lastInterpolation = interpolation = StringArgumentType.getString((CommandContext)x, (String)"interpolation");
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("Interpolation is set to '" + interpolation + "'!"), Util.f_137441_);
            return 0;
        })))).then(LiteralArgumentBuilder.literal((String)"show").then(RequiredArgumentBuilder.argument((String)"interpolation", (ArgumentType)InterpolationArgument.interpolationAll()).executes(x -> {
            String interpolation = StringArgumentType.getString((CommandContext)x, (String)"interpolation");
            CamInterpolation move = CamInterpolation.getInterpolation(interpolation);
            if (move != null) {
                move.isRenderingEnabled = true;
                CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("Showing '" + interpolation + "' interpolation path!"), Util.f_137441_);
            } else if (interpolation.equalsIgnoreCase("all")) {
                for (CamInterpolation movement : CamInterpolation.interpolationTypes.values()) {
                    movement.isRenderingEnabled = true;
                }
                CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("Showing all interpolation paths!"), Util.f_137441_);
            }
            return 0;
        })))).then(LiteralArgumentBuilder.literal((String)"hide").then(RequiredArgumentBuilder.argument((String)"interpolation", (ArgumentType)InterpolationArgument.interpolationAll()).executes(x -> {
            String interpolation = StringArgumentType.getString((CommandContext)x, (String)"interpolation");
            CamInterpolation move = CamInterpolation.getInterpolation(interpolation);
            if (move != null) {
                move.isRenderingEnabled = false;
                CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("Hiding '" + interpolation + "' interpolation path!"), Util.f_137441_);
            } else if (interpolation.equalsIgnoreCase("all")) {
                for (CamInterpolation movement : CamInterpolation.interpolationTypes.values()) {
                    movement.isRenderingEnabled = false;
                }
                CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("Hiding all interpolation paths!"), Util.f_137441_);
            }
            return 0;
        })))).then(LiteralArgumentBuilder.literal((String)"follow-speed").then(RequiredArgumentBuilder.argument((String)"factor", (ArgumentType)DoubleArgumentType.doubleArg()).executes(x -> {
            double factor;
            cameraFollowSpeed = factor = DoubleArgumentType.getDouble((CommandContext)x, (String)"factor");
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("Camera follow speed is set to  '" + factor + "'. Default is 1.0!"), Util.f_137441_);
            return 0;
        })))).then(LiteralArgumentBuilder.literal((String)"list").executes(x -> {
            if (isInstalledOnSever) {
                CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("Use /cam-server list instead!"), Util.f_137441_);
                return 0;
            }
            String output = "There are " + savedPaths.size() + " path(s) in total. ";
            for (String key : savedPaths.keySet()) {
                output = output + key + ", ";
            }
            CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(output), Util.f_137441_);
            return 0;
        }))).then(LiteralArgumentBuilder.literal((String)"load").then(RequiredArgumentBuilder.argument((String)"path", (ArgumentType)StringArgumentType.string()).executes(x -> {
            String pathArg = StringArgumentType.getString((CommandContext)x, (String)"path");
            if (isInstalledOnSever) {
                CMDCam.NETWORK.sendToServer((CreativePacket)new GetPathPacket(pathArg));
            } else {
                CamPath path = savedPaths.get(pathArg);
                if (path != null) {
                    path.overwriteClientConfig();
                    CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("Loaded path '" + pathArg + "' successfully!"), Util.f_137441_);
                } else {
                    CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("Could not find path '" + pathArg + "'!"), Util.f_137441_);
                }
            }
            return 0;
        })))).then(LiteralArgumentBuilder.literal((String)"save").then(RequiredArgumentBuilder.argument((String)"path", (ArgumentType)StringArgumentType.string()).executes(x -> {
            String pathArg = StringArgumentType.getString((CommandContext)x, (String)"path");
            try {
                CamPath path = CMDCamClient.createPathFromCurrentConfiguration();
                if (isInstalledOnSever) {
                    CMDCam.NETWORK.sendToServer((CreativePacket)new SetPathPacket(pathArg, path));
                } else {
                    savedPaths.put(pathArg, path);
                    CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent("Saved path '" + pathArg + "' successfully!"), Util.f_137441_);
                }
            }
            catch (PathParseException e) {
                CMDCamClient.mc.f_91074_.m_6352_((Component)new TextComponent(e.getMessage()), Util.f_137441_);
            }
            return 0;
        }))))));
    }

    public static void renderBefore(RenderPlayerEvent.Pre event) {
    }

    public static CamPath getCurrentPath() {
        return currentPath;
    }

    public static void startPath(CamPath path) throws PathParseException {
        try {
            currentPath = path;
            currentPath.start((Level)CMDCamClient.mc.f_91073_);
        }
        catch (PathParseException e) {
            currentPath = null;
            throw e;
        }
    }

    public static void stopPathServer() {
        currentPath.finish((Level)CMDCamClient.mc.f_91073_);
        currentPath = null;
    }

    public static void stopPath() {
        if (CMDCamClient.currentPath.serverPath) {
            return;
        }
        currentPath.finish((Level)CMDCamClient.mc.f_91073_);
        currentPath = null;
    }

    public static void tickPath(Level level, float renderTickTime) {
        currentPath.tick(level, renderTickTime);
        if (currentPath.hasFinished()) {
            currentPath = null;
        }
    }

    public static CamPath createPathFromCurrentConfiguration() throws PathParseException {
        if (points.size() < 1) {
            throw new PathParseException("You have to register at least 1 point!");
        }
        ArrayList<CamPoint> newPoints = new ArrayList<CamPoint>(points);
        if (newPoints.size() == 1) {
            newPoints.add((CamPoint)newPoints.get(0));
        }
        return new CamPath(lastLoop, lastDuration, lastMode, lastInterpolation, target, newPoints, cameraFollowSpeed);
    }

    static {
        lastLoop = 0;
        lastDuration = 10000L;
        lastMode = "default";
        lastInterpolation = "hermite";
        target = null;
        points = new ArrayList();
        cameraFollowSpeed = 1.0;
        savedPaths = new HashMap();
        isInstalledOnSever = false;
    }
}

