/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.client.interpolation;

import java.util.List;
import team.creative.cmdcam.client.PathParseException;
import team.creative.cmdcam.client.interpolation.CamInterpolation;
import team.creative.cmdcam.common.util.CamPoint;
import team.creative.cmdcam.common.util.CamTarget;
import team.creative.cmdcam.common.util.interpolation.CosineInterpolation;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.VecNd;

public class SmoothMovement
extends CamInterpolation {
    public CosineInterpolation<Vec1d> rollSpline;
    public CosineInterpolation<Vec1d> zoomSpline;
    public CosineInterpolation<Vec1d> pitchSpline;
    public CosineInterpolation<Vec1d> yawSpline;
    public CosineInterpolation<Vec3d> positionSpline;
    public double sizeOfIteration;

    @Override
    public void initMovement(List<CamPoint> points, int loops, CamTarget target) throws PathParseException {
        if (points.size() == 1) {
            throw new PathParseException("At least two points are required");
        }
        int iterations = loops == 0 ? 1 : (loops == 1 ? 2 : 3);
        this.sizeOfIteration = 1.0 / (double)iterations;
        int size = points.size() * iterations;
        if (iterations > 1) {
            ++size;
        }
        Vec1d[] rollPoints = new Vec1d[size];
        Vec1d[] zoomPoints = new Vec1d[size];
        Vec1d[] yawPoints = new Vec1d[size];
        Vec1d[] pitchPoints = new Vec1d[size];
        Vec3d[] positionPoints = new Vec3d[size];
        for (int j = 0; j < iterations; ++j) {
            for (int i = 0; i < points.size(); ++i) {
                rollPoints[i + j * points.size()] = new Vec1d(points.get((int)i).roll);
                zoomPoints[i + j * points.size()] = new Vec1d(points.get((int)i).zoom);
                yawPoints[i + j * points.size()] = new Vec1d(points.get((int)i).rotationYaw);
                pitchPoints[i + j * points.size()] = new Vec1d(points.get((int)i).rotationPitch);
                positionPoints[i + j * points.size()] = new Vec3d(points.get((int)i).x, points.get((int)i).y, points.get((int)i).z);
            }
        }
        if (iterations > 1) {
            rollPoints[points.size() * iterations] = new Vec1d(points.get((int)0).roll);
            zoomPoints[points.size() * iterations] = new Vec1d(points.get((int)0).zoom);
            yawPoints[points.size() * iterations] = new Vec1d(points.get((int)0).rotationYaw);
            pitchPoints[points.size() * iterations] = new Vec1d(points.get((int)0).rotationPitch);
            positionPoints[points.size() * iterations] = new Vec3d(points.get((int)0).x, points.get((int)0).y, points.get((int)0).z);
        }
        this.rollSpline = new CosineInterpolation((VecNd[])rollPoints);
        this.zoomSpline = new CosineInterpolation((VecNd[])zoomPoints);
        this.pitchSpline = new CosineInterpolation((VecNd[])pitchPoints);
        this.yawSpline = new CosineInterpolation((VecNd[])yawPoints);
        this.positionSpline = new CosineInterpolation((VecNd[])positionPoints);
    }

    @Override
    public CamPoint getPointInBetween(CamPoint point1, CamPoint point2, double percent, double wholeProgress, boolean isFirstLoop, boolean isLastLoop) {
        CamPoint point = point1.getPointBetween(point2, percent);
        int iteration = isFirstLoop ? 0 : (isLastLoop && this.sizeOfIteration < 0.5 ? 2 : 1);
        double additionalProgress = (double)iteration * this.sizeOfIteration;
        wholeProgress = additionalProgress + wholeProgress * this.sizeOfIteration;
        if (this.rollSpline != null) {
            point.roll = ((Vec1d)this.rollSpline.valueAt((double)wholeProgress)).x;
        }
        if (this.zoomSpline != null) {
            point.zoom = ((Vec1d)this.zoomSpline.valueAt((double)wholeProgress)).x;
        }
        if (this.yawSpline != null) {
            point.rotationYaw = ((Vec1d)this.yawSpline.valueAt((double)wholeProgress)).x;
        }
        if (this.pitchSpline != null) {
            point.rotationPitch = ((Vec1d)this.pitchSpline.valueAt((double)wholeProgress)).x;
        }
        if (this.positionSpline != null) {
            Vec3d position = (Vec3d)this.positionSpline.valueAt(wholeProgress);
            point.x = position.x;
            point.y = position.y;
            point.z = position.z;
        }
        return point;
    }

    @Override
    public Vec3d getColor() {
        return new Vec3d(0.0, 1.0, 0.0);
    }
}

