/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.command.argument;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.TextComponent;
import team.creative.cmdcam.client.interpolation.CamInterpolation;

public class InterpolationArgument
implements ArgumentType<String> {
    public static InterpolationArgument interpolation() {
        return new InterpolationArgument();
    }

    public static AllInterpolationArgument interpolationAll() {
        return new AllInterpolationArgument();
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        String result = reader.readString();
        if (!this.isAllowed(result)) {
            reader.setCursor(start);
            throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)new LiteralMessage("Invalid interpolation")), (Message)new TextComponent("Invalid interpolation!"));
        }
        return result;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return context.getSource() instanceof SharedSuggestionProvider ? SharedSuggestionProvider.m_82970_(this.getAll(), (SuggestionsBuilder)builder) : Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return this.getAll();
    }

    public Collection<String> getAll() {
        return CamInterpolation.interpolationTypes.keySet();
    }

    public boolean isAllowed(String result) {
        return CamInterpolation.getInterpolation(result) != null;
    }

    public static class AllInterpolationArgument
    extends InterpolationArgument {
        public static final List<String> EXAMPLES = new ArrayList<String>();

        @Override
        public boolean isAllowed(String result) {
            return result.equalsIgnoreCase("all") || super.isAllowed(result);
        }

        @Override
        public Collection<String> getAll() {
            return EXAMPLES;
        }

        static {
            EXAMPLES.add("all");
            EXAMPLES.addAll(CamInterpolation.interpolationTypes.keySet());
        }
    }
}

