/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.cmdcam.client.CMDCamClient;
import team.creative.cmdcam.client.PathParseException;
import team.creative.cmdcam.client.interpolation.CamInterpolation;
import team.creative.cmdcam.client.mode.CamMode;
import team.creative.cmdcam.common.util.CamPoint;
import team.creative.cmdcam.common.util.CamTarget;

public class CamPath {
    public int loop;
    public long duration;
    public String mode;
    public String interpolation;
    public CamTarget target;
    public List<CamPoint> points;
    public double cameraFollowSpeed;
    public boolean serverPath = false;
    @OnlyIn(value=Dist.CLIENT)
    private boolean hideGui;
    @OnlyIn(value=Dist.CLIENT)
    public CamInterpolation cachedInterpolation;
    @OnlyIn(value=Dist.CLIENT)
    public CamMode cachedMode;
    public long timeStarted = System.currentTimeMillis();
    public int currentLoop;
    private boolean finished;
    private boolean running;
    public List<CamPoint> tempPoints;

    public CamPath(CompoundTag nbt) {
        this.loop = nbt.m_128451_("loop");
        this.duration = nbt.m_128454_("duration");
        this.mode = nbt.m_128461_("mode");
        this.interpolation = nbt.m_128461_("interpolation");
        if (nbt.m_128441_("target")) {
            this.target = CamTarget.readFromNBT(nbt.m_128469_("target"));
        }
        ListTag list = nbt.m_128437_("points", 10);
        this.points = new ArrayList<CamPoint>();
        for (Tag point : list) {
            this.points.add(new CamPoint((CompoundTag)point));
        }
        this.cameraFollowSpeed = nbt.m_128459_("cameraFollowSpeed");
    }

    public CamPath(int loop, long duration, String mode, String interpolation, CamTarget target, List<CamPoint> points, double cameraFollowSpeed) {
        this.loop = loop;
        this.duration = duration;
        this.mode = mode;
        this.interpolation = interpolation;
        this.target = target;
        this.points = points;
        this.cameraFollowSpeed = cameraFollowSpeed;
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.m_128405_("loop", this.loop);
        nbt.m_128356_("duration", this.duration);
        nbt.m_128359_("mode", this.mode);
        nbt.m_128359_("interpolation", this.interpolation);
        if (this.target != null) {
            nbt.m_128365_("target", (Tag)this.target.writeToNBT(new CompoundTag()));
        }
        ListTag list = new ListTag();
        for (CamPoint point : this.points) {
            list.add((Object)point.writeToNBT(new CompoundTag()));
        }
        nbt.m_128365_("points", (Tag)list);
        nbt.m_128347_("cameraFollowSpeed", this.cameraFollowSpeed);
        return nbt;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void overwriteClientConfig() {
        CMDCamClient.lastLoop = this.loop;
        CMDCamClient.lastDuration = this.duration;
        CMDCamClient.lastMode = this.mode;
        CMDCamClient.lastInterpolation = this.interpolation;
        CMDCamClient.target = this.target;
        CMDCamClient.points = new ArrayList<CamPoint>(this.points);
        CMDCamClient.cameraFollowSpeed = this.cameraFollowSpeed;
    }

    public void start(Level level) throws PathParseException {
        this.finished = false;
        this.running = true;
        if (this.target != null) {
            this.target.start(level);
        }
        this.timeStarted = System.currentTimeMillis();
        this.currentLoop = 0;
        this.tempPoints = new ArrayList<CamPoint>(this.points);
        if (this.loop != 0) {
            this.tempPoints.add(this.tempPoints.get(this.tempPoints.size() - 1).copy());
        }
        if (level.f_46443_) {
            CamMode parser = CamMode.getMode(this.mode);
            this.cachedMode = parser.createMode(this);
            this.cachedMode.onPathStart();
            this.cachedInterpolation = CamInterpolation.getInterpolationOrDefault(this.interpolation);
            this.cachedInterpolation.initMovement(this.tempPoints, this.loop, this.target);
            this.hideGui = Minecraft.m_91087_().f_91066_.f_92062_;
        }
    }

    public void finish(Level level) {
        this.finished = true;
        this.running = false;
        if (this.target != null) {
            this.target.finish();
        }
        if (level.f_46443_) {
            this.cachedMode.onPathFinish();
            this.tempPoints = null;
            this.cachedMode = null;
            this.cachedInterpolation = null;
            Minecraft.m_91087_().f_91066_.f_92062_ = this.hideGui;
        }
    }

    public void tick(Level level, float renderTickTime) {
        long time = System.currentTimeMillis() - this.timeStarted;
        if (time >= this.duration) {
            if (this.currentLoop < this.loop || this.loop < 0) {
                this.timeStarted = System.currentTimeMillis();
                ++this.currentLoop;
            } else {
                this.finish(level);
            }
        } else {
            double percent;
            CamPoint point2;
            long durationOfPoint;
            int currentPoint;
            CamPoint point1;
            CamPoint newPoint;
            if (level.f_46443_) {
                Minecraft.m_91087_().f_91066_.f_92062_ = true;
            }
            if ((newPoint = this.cachedMode.getCamPoint(point1 = this.tempPoints.get(currentPoint = Math.min((int)(time / (durationOfPoint = this.duration / (long)(this.tempPoints.size() - 1))), this.tempPoints.size() - 2)), point2 = this.tempPoints.get(currentPoint + 1), percent = (double)(time % durationOfPoint) / (double)durationOfPoint, (double)time / (double)this.duration, renderTickTime, this.currentLoop == 0, this.currentLoop == this.loop)) != null) {
                this.cachedMode.processPoint(newPoint);
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean hasFinished() {
        return this.finished;
    }

    public CamPath copy() {
        CamPath path = new CamPath(this.currentLoop, this.duration, this.mode, this.interpolation, this.target, new ArrayList<CamPoint>(this.points), this.cameraFollowSpeed);
        path.serverPath = this.serverPath;
        return path;
    }
}

