/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.util;

import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.cmdcam.client.CamEventHandlerClient;

public class CamPoint {
    public double x;
    public double y;
    public double z;
    public double rotationYaw;
    public double rotationPitch;
    public double roll;
    public double zoom;

    public CamPoint(double x, double y, double z, double rotationYaw, double rotationPitch, double roll, double zoom) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.rotationYaw = rotationYaw;
        this.rotationPitch = rotationPitch;
        this.roll = roll;
        this.zoom = zoom;
    }

    public CamPoint(CompoundTag nbt) {
        this.x = nbt.m_128459_("x");
        this.y = nbt.m_128459_("y");
        this.z = nbt.m_128459_("z");
        this.rotationYaw = nbt.m_128459_("rotationYaw");
        this.rotationPitch = nbt.m_128459_("rotationPitch");
        this.roll = nbt.m_128459_("roll");
        this.zoom = nbt.m_128459_("zoom");
    }

    @OnlyIn(value=Dist.CLIENT)
    public CamPoint() {
        Minecraft mc = Minecraft.m_91087_();
        this.x = mc.f_91074_.m_20185_();
        this.y = mc.f_91074_.m_20188_();
        this.z = mc.f_91074_.m_20189_();
        this.rotationYaw = mc.f_91074_.m_146908_();
        this.rotationPitch = mc.f_91074_.m_146909_();
        this.roll = CamEventHandlerClient.roll;
        this.zoom = CamEventHandlerClient.currentFOV;
    }

    public CamPoint getPointBetween(CamPoint point, double percent) {
        return new CamPoint(this.x + (point.x - this.x) * percent, this.y + (point.y - this.y) * percent, this.z + (point.z - this.z) * percent, this.rotationYaw + (point.rotationYaw - this.rotationYaw) * percent, this.rotationPitch + (point.rotationPitch - this.rotationPitch) * percent, this.roll + (point.roll - this.roll) * percent, this.zoom + (point.zoom - this.zoom) * percent);
    }

    public void faceEntity(Vec3 pos, float minYaw, float minPitch, double ticks) {
        double d0 = pos.f_82479_ - this.x;
        double d2 = pos.f_82481_ - this.z;
        double d1 = pos.f_82480_ - this.y;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        double f2 = Math.atan2(d2, d0) * 180.0 / Math.PI - 90.0;
        double f3 = -(Math.atan2(d1, d3) * 180.0 / Math.PI);
        this.rotationPitch = this.updateRotation(this.rotationPitch, f3, minPitch, ticks);
        this.rotationYaw = this.updateRotation(this.rotationYaw, f2, minYaw, ticks);
    }

    private double updateRotation(double rotation, double intended, double min, double ticks) {
        double f3 = Mth.m_14175_((double)(intended - rotation));
        f3 = f3 > 0.0 ? Math.min(Math.abs(f3 * ticks), f3) : Math.max(-Math.abs(f3 * ticks), f3);
        return rotation + f3;
    }

    public CamPoint copy() {
        return new CamPoint(this.x, this.y, this.z, this.rotationYaw, this.rotationPitch, this.roll, this.zoom);
    }

    public String toString() {
        return "x:" + this.x + ",y:" + this.y + ",z:" + this.z + ",yaw:" + this.rotationYaw + ",pitch:" + this.rotationPitch + ",roll:" + this.roll + ",zoom:" + this.zoom;
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.m_128347_("x", this.x);
        nbt.m_128347_("y", this.y);
        nbt.m_128347_("z", this.z);
        nbt.m_128347_("rotationYaw", this.rotationYaw);
        nbt.m_128347_("rotationPitch", this.rotationPitch);
        nbt.m_128347_("roll", this.roll);
        nbt.m_128347_("zoom", this.zoom);
        return nbt;
    }
}

