/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.util;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class CamTarget {
    private static HashMap<String, Class<? extends CamTarget>> targetTypes = new HashMap();
    private static HashMap<Class<? extends CamTarget>, String> targetTypesInverted = new HashMap();

    public static void registerTargetType(Class<? extends CamTarget> targetClass, String id) {
        targetTypes.put(id, targetClass);
        targetTypesInverted.put(targetClass, id);
    }

    public static Class<? extends CamTarget> getClassByID(String id) {
        return targetTypes.get(id);
    }

    public static CamTarget readFromNBT(CompoundTag nbt) {
        Class<? extends CamTarget> targetClass = CamTarget.getClassByID(nbt.m_128461_("id"));
        if (targetClass != null) {
            try {
                return targetClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                System.out.println("Invalid target class " + nbt.m_128461_("id") + "," + targetClass.getName());
            }
        }
        return null;
    }

    public abstract Vec3 getTargetVec(Level var1, float var2);

    protected abstract void write(CompoundTag var1);

    protected abstract void read(CompoundTag var1);

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.m_128359_("id", targetTypesInverted.get(this.getClass()));
        this.write(nbt);
        return nbt;
    }

    public void start(Level world) {
    }

    public void finish() {
    }

    static {
        CamTarget.registerTargetType(BlockTarget.class, "block");
        CamTarget.registerTargetType(EntityTarget.class, "entity");
        CamTarget.registerTargetType(SelfTarget.class, "self");
    }

    public static class BlockTarget
    extends CamTarget {
        public BlockPos pos;

        public BlockTarget() {
        }

        public BlockTarget(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public Vec3 getTargetVec(Level level, float partialTicks) {
            return new Vec3((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5);
        }

        @Override
        protected void write(CompoundTag nbt) {
            nbt.m_128385_("data", new int[]{this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_()});
        }

        @Override
        protected void read(CompoundTag nbt) {
            int[] array = nbt.m_128465_("data");
            if (array == null || array.length != 3) {
                throw new IllegalArgumentException("Invalid block target data=" + array);
            }
            this.pos = new BlockPos(array[0], array[1], array[2]);
        }
    }

    public static class EntityTarget
    extends CamTarget {
        public Entity cachedEntity;
        public String uuid;

        public EntityTarget() {
        }

        public EntityTarget(Entity entity) {
            this.cachedEntity = entity;
            this.uuid = entity.m_20149_();
        }

        @Override
        public void start(Level world) {
            for (Entity entity : world.m_45976_(Entity.class, new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY))) {
                if (!entity.m_20149_().equals(this.uuid)) continue;
                this.cachedEntity = entity;
                break;
            }
        }

        @Override
        public void finish() {
            this.cachedEntity = null;
        }

        @Override
        public Vec3 getTargetVec(Level level, float partialTicks) {
            if (this.cachedEntity != null && !this.cachedEntity.m_6084_()) {
                this.cachedEntity = null;
            }
            if (this.cachedEntity instanceof LivingEntity) {
                return ((LivingEntity)this.cachedEntity).m_20299_(partialTicks);
            }
            if (this.cachedEntity != null) {
                return this.cachedEntity.m_20299_(partialTicks);
            }
            return null;
        }

        @Override
        protected void write(CompoundTag nbt) {
            nbt.m_128359_("uuid", this.uuid);
        }

        @Override
        protected void read(CompoundTag nbt) {
            this.uuid = nbt.m_128461_("uuid");
        }
    }

    public static class SelfTarget
    extends CamTarget {
        @Override
        protected void write(CompoundTag nbt) {
        }

        @Override
        protected void read(CompoundTag nbt) {
        }

        @Override
        public Vec3 getTargetVec(Level level, float partialTicks) {
            LocalPlayer cachedEntity = Minecraft.m_91087_().f_91074_;
            if (cachedEntity instanceof LivingEntity) {
                return ((LivingEntity)cachedEntity).m_20299_(partialTicks);
            }
            if (cachedEntity != null) {
                return cachedEntity.m_20299_(partialTicks);
            }
            return null;
        }
    }
}

