/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.api.impl;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Tuple;
import yeelp.distinctdamagedescriptions.DistinctDamageDescriptions;
import yeelp.distinctdamagedescriptions.ModConfig;
import yeelp.distinctdamagedescriptions.api.DDDAPI;
import yeelp.distinctdamagedescriptions.api.IDistinctDamageDescriptionsAccessor;
import yeelp.distinctdamagedescriptions.api.IDistinctDamageDescriptionsMutator;
import yeelp.distinctdamagedescriptions.handlers.CapabilityHandler;
import yeelp.distinctdamagedescriptions.init.DDDEnchantments;
import yeelp.distinctdamagedescriptions.registries.DDDRegistries;
import yeelp.distinctdamagedescriptions.util.ArmorDistributionProvider;
import yeelp.distinctdamagedescriptions.util.CreatureTypeProvider;
import yeelp.distinctdamagedescriptions.util.DamageCategories;
import yeelp.distinctdamagedescriptions.util.DamageDistribution;
import yeelp.distinctdamagedescriptions.util.DamageDistributionProvider;
import yeelp.distinctdamagedescriptions.util.DamageType;
import yeelp.distinctdamagedescriptions.util.IArmorDistribution;
import yeelp.distinctdamagedescriptions.util.ICreatureType;
import yeelp.distinctdamagedescriptions.util.IDamageDistribution;
import yeelp.distinctdamagedescriptions.util.IMobResistances;
import yeelp.distinctdamagedescriptions.util.MobResistancesProvider;

public enum DistinctDamageDescriptionsAPIImpl implements IDistinctDamageDescriptionsAccessor,
IDistinctDamageDescriptionsMutator
{
    INSTANCE;

    private static final EntityEquipmentSlot[] armorSlots;

    private DistinctDamageDescriptionsAPIImpl() {
        DDDAPI.accessor = this;
        DDDAPI.mutator = this;
    }

    @Override
    @Nullable
    public IDamageDistribution getDamageDistribution(ItemStack stack) {
        return stack.func_190926_b() ? null : DamageDistributionProvider.getDamageDistribution(stack);
    }

    @Override
    public IDamageDistribution getDamageDistribution(EntityLivingBase entity) {
        return DamageDistributionProvider.getDamageDistribution(entity);
    }

    @Override
    public IDamageDistribution getDamageDistribution(IProjectile projectile) {
        return DamageDistributionProvider.getDamageDistribution(projectile);
    }

    @Override
    @Nullable
    public IArmorDistribution getArmorResistances(ItemStack stack) {
        return ArmorDistributionProvider.getArmorResistances(stack);
    }

    @Override
    public IMobResistances getMobResistances(EntityLivingBase entity) {
        return MobResistancesProvider.getMobResistances(entity);
    }

    @Override
    public ICreatureType getMobCreatureType(EntityLivingBase entity) {
        return CreatureTypeProvider.getCreatureType(entity);
    }

    @Override
    public Map<EntityEquipmentSlot, IArmorDistribution> getArmorDistributionsForEntity(EntityLivingBase entity) {
        HashMap<EntityEquipmentSlot, IArmorDistribution> map = new HashMap<EntityEquipmentSlot, IArmorDistribution>();
        for (EntityEquipmentSlot slot : armorSlots) {
            map.put(slot, DDDAPI.accessor.getArmorResistances(entity.func_184582_a(slot)));
        }
        return map;
    }

    @Override
    public Map<DamageType, Tuple<Float, Float>> getArmorValuesForEntity(EntityLivingBase entity, boolean bootsOnly, boolean helmetOnly) {
        HashMap<DamageType, Tuple<Float, Float>> map = new HashMap<DamageType, Tuple<Float, Float>>();
        float slashArmor = 0.0f;
        float pierceArmor = 0.0f;
        float bludgeArmor = 0.0f;
        float slashTough = 0.0f;
        float pierceTough = 0.0f;
        float bludgeTough = 0.0f;
        for (EntityEquipmentSlot slot : armorSlots) {
            ItemStack stack = entity.func_184582_a(slot);
            if (stack.func_190926_b() || bootsOnly && slot != EntityEquipmentSlot.FEET || helmetOnly && slot != EntityEquipmentSlot.HEAD || !(stack.func_77973_b() instanceof ItemArmor)) continue;
            ItemArmor armorItem = (ItemArmor)stack.func_77973_b();
            IArmorDistribution armorResists = this.getArmorResistances(stack);
            float armor = armorItem.field_77879_b;
            float toughness = armorItem.field_189415_e;
            float slashWeight = armorResists.getSlashingWeight();
            float pierceWeight = armorResists.getPiercingWeight();
            float bludgeWeight = armorResists.getBludgeoningWeight();
            slashArmor += armor * slashWeight;
            pierceArmor += armor * pierceWeight;
            bludgeArmor += armor * bludgeWeight;
            slashTough += toughness * slashWeight;
            pierceTough += toughness * pierceWeight;
            bludgeTough += toughness * bludgeWeight;
        }
        map.put(DamageType.SLASHING, new Tuple((Object)Float.valueOf(slashArmor), (Object)Float.valueOf(slashTough)));
        map.put(DamageType.PIERCING, new Tuple((Object)Float.valueOf(pierceArmor), (Object)Float.valueOf(pierceTough)));
        map.put(DamageType.BLUDGEONING, new Tuple((Object)Float.valueOf(bludgeArmor), (Object)Float.valueOf(bludgeTough)));
        return map;
    }

    @Override
    @Nullable
    public Map<DamageType, Float> classifyDamage(@Nonnull IMobResistances resistances, @Nonnull DamageSource src, float damage) {
        HashMap<DamageType, Float> map = new HashMap<DamageType, Float>();
        boolean slyStrike = false;
        DamageCategories damageCat = null;
        if (src.func_76364_f() instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)src.func_76364_f();
            ItemStack heldItem = attacker.func_184614_ca();
            boolean hasEmptyHand = heldItem.func_190926_b();
            if (!hasEmptyHand) {
                IDamageDistribution weaponDist = this.getDamageDistribution(heldItem);
                slyStrike = EnchantmentHelper.func_185284_a((Enchantment)DDDEnchantments.slyStrike, (EntityLivingBase)attacker) > 0;
                damageCat = weaponDist.distributeDamage(damage);
            } else {
                IDamageDistribution mobDist = this.getDamageDistribution(attacker);
                damageCat = mobDist.distributeDamage(damage);
            }
        } else if (DistinctDamageDescriptionsAPIImpl.isValidProjectile(src)) {
            IProjectile projectile = (IProjectile)src.func_76364_f();
            IDamageDistribution dist = this.getDamageDistribution(projectile);
            damageCat = dist.distributeDamage(damage);
        } else if (src.func_94541_c() && ModConfig.dmg.extraDamage.enableExplosionDamage) {
            damageCat = DamageDistribution.BLUDGEONING_DISTRIBUTION.distributeDamage(damage);
        } else if (src == DamageSource.field_76367_g && ModConfig.dmg.extraDamage.enableCactusDamage) {
            damageCat = DamageDistribution.PIERCING_DISTRIBUTION.distributeDamage(damage);
        } else if (src == DamageSource.field_82728_o && ModConfig.dmg.extraDamage.enableAnvilDamage) {
            damageCat = DamageDistribution.BLUDGEONING_DISTRIBUTION.distributeDamage(damage);
        } else if (src == DamageSource.field_82729_p && ModConfig.dmg.extraDamage.enableFallingBlockDamage) {
            damageCat = DamageDistribution.BLUDGEONING_DISTRIBUTION.distributeDamage(damage);
        } else if (src == DamageSource.field_76379_h && ModConfig.dmg.extraDamage.enableFallDamage) {
            damageCat = DamageDistribution.BLUDGEONING_DISTRIBUTION.distributeDamage(damage);
        } else if (src == DamageSource.field_188406_j && ModConfig.dmg.extraDamage.enableFlyIntoWallDamage) {
            damageCat = DamageDistribution.BLUDGEONING_DISTRIBUTION.distributeDamage(damage);
        } else {
            return null;
        }
        DistinctDamageDescriptions.debug(String.format("Damage Categories: %s", damageCat.toString()));
        float slashing = damageCat.getSlashingDamage();
        float piercing = damageCat.getPiercingDamage();
        float bludgeoning = damageCat.getBludgeoningDamage();
        if (slashing > 0.0f) {
            map.put(DamageType.SLASHING, Float.valueOf(resistances.isSlashingImmune() && !slyStrike ? -1.0f : slashing));
        }
        if (piercing > 0.0f) {
            map.put(DamageType.PIERCING, Float.valueOf(resistances.isPiercingImmune() && !slyStrike ? -1.0f : piercing));
        }
        if (bludgeoning > 0.0f) {
            map.put(DamageType.BLUDGEONING, Float.valueOf(resistances.isBludgeoningImmune() && !slyStrike ? -1.0f : bludgeoning));
        }
        return map;
    }

    private static boolean isValidProjectile(DamageSource src) {
        Entity entityIn = src.func_76364_f();
        if (entityIn instanceof IProjectile) {
            return DDDRegistries.projectileProperties.isProjectileRegistered(entityIn) || !src.func_82725_o();
        }
        return false;
    }

    @Override
    public void setPlayerResistances(EntityPlayer player, float slash, float pierce, float bludge, boolean slashImmune, boolean pierceImmune, boolean bludgeImmune, boolean adaptive) {
        IMobResistances mobResists = this.getMobResistances((EntityLivingBase)player);
        mobResists.setSlashingResistance(slash);
        mobResists.setPiercingResistance(pierce);
        mobResists.setBludgeoningResistance(bludge);
        mobResists.setSlashingImmunity(slashImmune);
        mobResists.setPiercingImmunity(pierceImmune);
        mobResists.setBludgeoningImmunity(bludgeImmune);
        mobResists.setAdaptiveResistance(adaptive);
        CapabilityHandler.syncResistances(player);
    }

    static {
        armorSlots = new EntityEquipmentSlot[]{EntityEquipmentSlot.CHEST, EntityEquipmentSlot.FEET, EntityEquipmentSlot.HEAD, EntityEquipmentSlot.LEGS};
    }
}

