/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.event;

import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import yeelp.distinctdamagedescriptions.event.DamageDescriptionEvent;

public final class CustomDamageEvent
extends DamageDescriptionEvent {
    private final HashSet<String> damageTypes;
    private float resistance;

    public CustomDamageEvent(@Nullable Entity attacker, @Nonnull EntityLivingBase defender, float amount, float resistance, String ... damageSources) {
        super(attacker, defender, amount);
        this.damageTypes = new HashSet<String>(Arrays.asList(damageSources));
        this.resistance = resistance;
    }

    public String[] getDamageTypes() {
        return this.damageTypes.toArray(new String[0]);
    }

    public boolean hasDamageType(String damageTypeName) {
        return this.damageTypes.contains(damageTypeName);
    }

    @Override
    public float getResistance() {
        return this.resistance;
    }

    @Override
    public void setResistance(float newResistance) {
        this.resistance = newResistance;
    }
}

