/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.event;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import yeelp.distinctdamagedescriptions.event.DamageDescriptionEvent;
import yeelp.distinctdamagedescriptions.util.DamageType;

public abstract class PhysicalDamageEvent
extends DamageDescriptionEvent {
    private final DamageType type;
    private float resistance;

    public PhysicalDamageEvent(DamageType type, float amount, float resistance, @Nullable Entity attacker, @Nonnull EntityLivingBase defender) {
        super(attacker, defender, amount);
        this.type = type;
        this.resistance = resistance;
    }

    public DamageType getDamageType() {
        return this.type;
    }

    @Override
    public float getResistance() {
        return this.resistance;
    }

    @Override
    public void setResistance(float newResistance) {
        this.resistance = newResistance;
    }

    public static class PiercingDamage
    extends PhysicalDamageEvent {
        public PiercingDamage(float amount, float resistance, @Nullable Entity attacker, @Nonnull EntityLivingBase defender) {
            super(DamageType.PIERCING, amount, resistance, attacker, defender);
        }
    }

    public static class BludgeoningDamage
    extends PhysicalDamageEvent {
        public BludgeoningDamage(float amount, float resistance, @Nullable Entity attacker, @Nonnull EntityLivingBase defender) {
            super(DamageType.BLUDGEONING, amount, resistance, attacker, defender);
        }
    }

    public static class SlashingDamage
    extends PhysicalDamageEvent {
        public SlashingDamage(float amount, float resistance, @Nullable Entity attacker, @Nonnull EntityLivingBase defender) {
            super(DamageType.SLASHING, amount, resistance, attacker, defender);
        }
    }
}

