/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.handlers;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import yeelp.distinctdamagedescriptions.api.DDDAPI;
import yeelp.distinctdamagedescriptions.handlers.Handler;
import yeelp.distinctdamagedescriptions.handlers.PacketHandler;
import yeelp.distinctdamagedescriptions.network.MobResistancesMessage;
import yeelp.distinctdamagedescriptions.registries.DDDRegistries;
import yeelp.distinctdamagedescriptions.util.ArmorDistribution;
import yeelp.distinctdamagedescriptions.util.ComparableTriple;
import yeelp.distinctdamagedescriptions.util.CreatureType;
import yeelp.distinctdamagedescriptions.util.CreatureTypeData;
import yeelp.distinctdamagedescriptions.util.DamageDistribution;
import yeelp.distinctdamagedescriptions.util.MobResistanceCategories;
import yeelp.distinctdamagedescriptions.util.MobResistances;

public class CapabilityHandler
extends Handler {
    private static final ResourceLocation dmg = new ResourceLocation("distinctdamagedescriptions", "dmgDistribution");
    private static final ResourceLocation armor = new ResourceLocation("distinctdamagedescriptions", "armorResists");
    private static final ResourceLocation mobs = new ResourceLocation("distinctdamagedescriptions", "mobResists");
    private static final ResourceLocation projDmg = new ResourceLocation("distinctdamagedescriptions", "projectileDmgDistribution");
    private static final ResourceLocation creatureType = new ResourceLocation("distinctdamagedescriptions", "creatureTypes");

    @SubscribeEvent
    public void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> evt) {
        Entity entity = (Entity)evt.getObject();
        if (entity instanceof EntityPlayer) {
            evt.addCapability(dmg, (ICapabilityProvider)new DamageDistribution());
            evt.addCapability(mobs, (ICapabilityProvider)new MobResistances(0.0f, 0.0f, 0.0f, false, false, false, false, 0.0f));
            evt.addCapability(creatureType, (ICapabilityProvider)CreatureType.UNKNOWN);
        } else if (entity instanceof EntityLivingBase) {
            String key = EntityList.func_191301_a((Entity)entity).toString();
            ComparableTriple<Float, Float, Float> dmges = DDDRegistries.mobDamage.getMobDamage(key);
            MobResistanceCategories resists = DDDRegistries.mobResists.getResistancesForMob(key);
            Tuple<CreatureTypeData, CreatureTypeData> types = DDDRegistries.creatureTypes.getCreatureTypeForMob(key);
            evt.addCapability(dmg, (ICapabilityProvider)new DamageDistribution(dmges.getLeft().floatValue(), dmges.getMiddle().floatValue(), dmges.getRight().floatValue()));
            evt.addCapability(mobs, (ICapabilityProvider)new MobResistances(resists.getSlashingResistance(), resists.getPiercingResistance(), resists.getBludgeoningResistance(), resists.getSlashingImmunity(), resists.getPiercingImmunity(), resists.getBludgeoningImmunity(), Math.random() < (double)resists.adaptiveChance(), resists.getAdaptiveAmount()));
            evt.addCapability(creatureType, (ICapabilityProvider)new CreatureType((CreatureTypeData)types.func_76341_a(), (CreatureTypeData)types.func_76340_b()));
        } else if (entity instanceof IProjectile) {
            String key = EntityList.func_191301_a((Entity)entity).toString();
            ComparableTriple<Float, Float, Float> dmges = DDDRegistries.projectileProperties.getProjectileDamageTypes(key);
            evt.addCapability(projDmg, (ICapabilityProvider)new DamageDistribution(dmges.getLeft().floatValue(), dmges.getMiddle().floatValue(), dmges.getRight().floatValue()));
        }
    }

    @SubscribeEvent
    public void attachItemCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        Item item = ((ItemStack)evt.getObject()).func_77973_b();
        String key = item.getRegistryName().toString();
        ComparableTriple<Float, Float, Float> dmges = DDDRegistries.itemProperties.getDamageDistributionForItem(key);
        evt.addCapability(dmg, (ICapabilityProvider)new DamageDistribution(dmges.getLeft().floatValue(), dmges.getMiddle().floatValue(), dmges.getRight().floatValue()));
        if (item instanceof ItemArmor) {
            ComparableTriple<Float, Float, Float> resists = DDDRegistries.itemProperties.getArmorDistributionForItem(key);
            evt.addCapability(armor, (ICapabilityProvider)new ArmorDistribution(resists.getLeft().floatValue(), resists.getMiddle().floatValue(), resists.getRight().floatValue()));
        }
    }

    public static void syncResistances(EntityPlayer player) {
        PacketHandler.INSTANCE.sendTo((IMessage)new MobResistancesMessage(DDDAPI.accessor.getMobResistances((EntityLivingBase)player)), (EntityPlayerMP)player);
    }
}

