/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.handlers;

import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import yeelp.distinctdamagedescriptions.DistinctDamageDescriptions;
import yeelp.distinctdamagedescriptions.ModConfig;
import yeelp.distinctdamagedescriptions.api.DDDAPI;
import yeelp.distinctdamagedescriptions.client.render.patricle.DDDParticle;
import yeelp.distinctdamagedescriptions.client.render.patricle.DDDParticleType;
import yeelp.distinctdamagedescriptions.event.CustomDamageEvent;
import yeelp.distinctdamagedescriptions.event.PhysicalDamageEvent;
import yeelp.distinctdamagedescriptions.handlers.Handler;
import yeelp.distinctdamagedescriptions.init.DDDEnchantments;
import yeelp.distinctdamagedescriptions.init.DDDSounds;
import yeelp.distinctdamagedescriptions.registries.DDDRegistries;
import yeelp.distinctdamagedescriptions.util.DDDDamageType;
import yeelp.distinctdamagedescriptions.util.DamageType;
import yeelp.distinctdamagedescriptions.util.IArmorDistribution;
import yeelp.distinctdamagedescriptions.util.ICreatureType;
import yeelp.distinctdamagedescriptions.util.IMobResistances;
import yeelp.distinctdamagedescriptions.util.NonNullMap;

public class DamageHandler
extends Handler {
    private static Map<UUID, Boolean> shouldKnockback = new NonNullMap<UUID, Boolean>(false);
    private static Random particleDisplacement = new Random();

    @SubscribeEvent
    public void onDeath(LivingDeathEvent evt) {
        if (evt.getEntityLiving() instanceof EntityPlayerMP) {
            DamageSource source = ModConfig.dmg.useCustomDamageTypes ? DDDRegistries.damageTypes.getDamageType(evt.getSource()) : evt.getSource();
            ((EntityPlayerMP)evt.getEntityLiving()).field_71133_b.func_184103_al().func_148539_a(source.func_151519_b(evt.getEntityLiving()));
        } else if (evt.getEntityLiving() instanceof EntityTameable) {
            DamageSource source = ModConfig.dmg.useCustomDamageTypes ? DDDRegistries.damageTypes.getDamageType(evt.getSource()) : evt.getSource();
            ((EntityTameable)evt.getEntityLiving()).func_70902_q().func_145747_a(source.func_151519_b(evt.getEntityLiving()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void classifyDamage(LivingHurtEvent evt) {
        IMobResistances mobResists;
        Map<DamageType, Float> dmgMap;
        float finalModifier = 0.0f;
        EntityLivingBase defender = evt.getEntityLiving();
        DamageSource dmgSource = ModConfig.dmg.useCustomDamageTypes ? DDDRegistries.damageTypes.getDamageType(evt.getSource()) : evt.getSource();
        Entity attacker = dmgSource.func_76364_f();
        if (ModConfig.showDotsOn) {
            Entity trueAttacker = dmgSource.func_76346_g();
            ResourceLocation attackerLoc = attacker == null || attacker instanceof EntityPlayer ? null : EntityList.func_191301_a((Entity)attacker);
            ResourceLocation defendLoc = defender == null ? null : EntityList.func_191301_a((Entity)defender);
            ResourceLocation trueAttackerLoc = trueAttacker == null ? null : EntityList.func_191301_a((Entity)trueAttacker);
            String s1 = attackerLoc != null ? attackerLoc.toString() : "null";
            String s2 = defendLoc != null ? defendLoc.toString() : "null";
            String s3 = trueAttackerLoc != null ? trueAttackerLoc.toString() : "null";
            DistinctDamageDescriptions.debug("Damage Type: " + dmgSource.field_76373_n + " Attacker: " + (attacker != null && attacker instanceof EntityPlayer ? "player" : s1) + ", True Attacker: " + s3 + " Defender: " + s2);
        }
        String[] damageTypes = new String[]{};
        if (ModConfig.resist.useCreatureTypes && ModConfig.dmg.useCustomDamageTypes) {
            ICreatureType type = DDDAPI.accessor.getMobCreatureType(defender);
            if (dmgSource instanceof DDDDamageType) {
                DDDDamageType dmgType = (DDDDamageType)dmgSource;
                damageTypes = dmgType.getExtendedTypes().toArray(damageTypes);
                for (String s : dmgType.getExtendedTypes()) {
                    finalModifier += type.getModifierForDamageType(s);
                }
            } else {
                damageTypes = new String[]{dmgSource.field_76373_n};
                finalModifier = type.getModifierForDamageType(dmgSource.field_76373_n);
            }
        }
        if ((dmgMap = DDDAPI.accessor.classifyDamage(mobResists = DDDAPI.accessor.getMobResistances(defender), dmgSource, evt.getAmount())) == null) {
            if (ModConfig.dmg.useCustomDamageTypes && ModConfig.resist.useCreatureTypes) {
                float amount = evt.getAmount();
                CustomDamageEvent custEvt = new CustomDamageEvent(attacker, defender, amount, finalModifier, damageTypes);
                MinecraftForge.EVENT_BUS.post((Event)custEvt);
                evt.setAmount(MathHelper.func_76131_a((float)(custEvt.getDamage() - custEvt.getDamage() * custEvt.getResistance()), (float)0.0f, (float)Float.MAX_VALUE));
                shouldKnockback.put(defender.func_110124_au(), evt.getAmount() == 0.0f);
            }
            return;
        }
        DistinctDamageDescriptions.debug("starting damage: " + evt.getAmount());
        boolean bootsOnly = false;
        boolean helmetOnly = false;
        boolean applyAnvilReductionCap = false;
        float bruteForceAmount = 0.0f;
        if (dmgSource == DamageSource.field_76379_h) {
            bootsOnly = true;
        } else if (dmgSource == DamageSource.field_82728_o) {
            helmetOnly = true;
            applyAnvilReductionCap = true;
        } else if (dmgSource == DamageSource.field_82729_p) {
            helmetOnly = true;
        } else if (dmgSource.func_76364_f() instanceof EntityLivingBase) {
            bruteForceAmount = 0.1f * (float)EnchantmentHelper.func_185284_a((Enchantment)DDDEnchantments.bruteForce, (EntityLivingBase)((EntityLivingBase)dmgSource.func_76364_f()));
        }
        Map<DamageType, Tuple<Float, Float>> armors = DDDAPI.accessor.getArmorValuesForEntity(defender, bootsOnly, helmetOnly);
        DistinctDamageDescriptions.debug("Damage Total: (" + dmgMap.get((Object)DamageType.SLASHING) + ", " + dmgMap.get((Object)DamageType.PIERCING) + ", " + dmgMap.get((Object)DamageType.BLUDGEONING) + ")");
        float[] absorb = new float[3];
        boolean blockKnockbackFlag = true;
        boolean immunityResisted = false;
        boolean resisted = false;
        boolean weakness = false;
        for (Float f : dmgMap.values()) {
            if (f == null || !(f.floatValue() > 0.0f)) continue;
            blockKnockbackFlag = false;
            break;
        }
        shouldKnockback.put(defender.func_110124_au(), blockKnockbackFlag);
        float totalDamage = 0.0f;
        for (DamageType type : DamageType.values()) {
            boolean isVeryClose;
            if (!dmgMap.containsKey((Object)type)) continue;
            float dmg = dmgMap.get((Object)type).floatValue();
            if (dmg < 0.0f) {
                immunityResisted = true;
                continue;
            }
            float mobMod = 0.0f;
            switch (type) {
                case SLASHING: {
                    PhysicalDamageEvent.SlashingDamage slashEvent = new PhysicalDamageEvent.SlashingDamage(dmgMap.get((Object)type).floatValue(), mobResists.getSlashingResistance(), attacker, defender);
                    MinecraftForge.EVENT_BUS.post((Event)slashEvent);
                    dmg = slashEvent.getDamage();
                    mobMod = slashEvent.getResistance();
                    break;
                }
                case PIERCING: {
                    PhysicalDamageEvent.PiercingDamage pierceEvent = new PhysicalDamageEvent.PiercingDamage(dmgMap.get((Object)type).floatValue(), mobResists.getPiercingResistance(), attacker, defender);
                    MinecraftForge.EVENT_BUS.post((Event)pierceEvent);
                    dmg = pierceEvent.getDamage();
                    mobMod = pierceEvent.getResistance();
                    break;
                }
                case BLUDGEONING: {
                    PhysicalDamageEvent.BludgeoningDamage bludgeoningEvent = new PhysicalDamageEvent.BludgeoningDamage(dmgMap.get((Object)type).floatValue(), mobResists.getBludgeoningResistance(), attacker, defender);
                    MinecraftForge.EVENT_BUS.post((Event)bludgeoningEvent);
                    dmg = bludgeoningEvent.getDamage();
                    mobMod = bludgeoningEvent.getResistance();
                }
            }
            if (mobMod > 0.0f) {
                mobMod = MathHelper.func_76131_a((float)(mobMod - bruteForceAmount), (float)0.0f, (float)Float.MAX_VALUE);
            }
            Tuple<Float, Float> resists = armors.get((Object)type);
            float newDmg = DamageHandler.modDmg(dmg, ((Float)resists.func_76341_a()).floatValue(), ((Float)resists.func_76340_b()).floatValue(), applyAnvilReductionCap);
            boolean bl = isVeryClose = (double)Math.abs((newDmg -= newDmg * mobMod) - dmg) < 1.0E-7;
            if (!resisted && newDmg < dmg && !isVeryClose) {
                resisted = true;
            }
            if (!weakness && newDmg > dmg && !isVeryClose) {
                weakness = true;
            }
            absorb[type.ordinal()] = dmg - newDmg;
            totalDamage += newDmg;
        }
        DistinctDamageDescriptions.debug("new damage after physical deductions: " + totalDamage);
        if (finalModifier != 0.0f) {
            CustomDamageEvent customDamageEvent = new CustomDamageEvent(attacker, defender, totalDamage, finalModifier, damageTypes);
            MinecraftForge.EVENT_BUS.post((Event)customDamageEvent);
            totalDamage = customDamageEvent.getDamage();
            finalModifier = customDamageEvent.getResistance();
            totalDamage -= totalDamage * finalModifier;
            DistinctDamageDescriptions.debug("new damage after additional reductions: " + totalDamage);
        }
        float f = MathHelper.func_76131_a((float)(totalDamage / evt.getAmount()), (float)0.0f, (float)Float.MAX_VALUE);
        evt.setAmount(totalDamage < 0.0f ? 0.0f : totalDamage);
        dmgSource.func_76348_h();
        EntityPlayer attackerPlayer = null;
        if (dmgSource.func_76346_g() instanceof EntityPlayer) {
            attackerPlayer = (EntityPlayer)dmgSource.func_76346_g();
            if (resisted || finalModifier > 0.0f) {
                DamageHandler.spawnRandomAmountOfParticles((Entity)defender, DDDParticleType.RESISTANCE);
            }
            if (weakness || finalModifier < 0.0f) {
                DamageHandler.spawnRandomAmountOfParticles((Entity)defender, DDDParticleType.WEAKNESS);
            }
            if (immunityResisted) {
                DamageHandler.spawnRandomAmountOfParticles((Entity)defender, DDDParticleType.IMMUNITY);
                DDDSounds.playSound(attackerPlayer, DDDSounds.IMMUNITY_HIT, 1.5f, 1.0f);
                evt.setCanceled(f == 0.0f && ModConfig.dmg.cancelLivingHurtEventOnImmunity);
            } else if (f != 0.0f) {
                if (f > 1.0f) {
                    DDDSounds.playSound(attackerPlayer, DDDSounds.WEAKNESS_HIT, 0.6f, 1.0f);
                } else if (f < 1.0f) {
                    DDDSounds.playSound(attackerPlayer, DDDSounds.RESIST_DING, 1.7f, 1.0f);
                }
            } else if (f == 0.0f) {
                DDDSounds.playSound(attackerPlayer, DDDSounds.HIGH_RESIST_HIT, 1.7f, 1.0f);
            }
        }
        if (mobResists.hasAdaptiveResistance()) {
            DistinctDamageDescriptions.debug("Updating mob's adaptive resistance, since it is present...");
            if (mobResists.updateAdaptiveResistance(dmgMap.keySet().toArray(new DamageType[0])) && attackerPlayer != null) {
                DDDSounds.playSound(attackerPlayer, DDDSounds.ADAPTABILITY_CHANGE, 2.0f, 1.0f);
            }
        }
        Map<EntityEquipmentSlot, IArmorDistribution> armorMap = DDDAPI.accessor.getArmorDistributionsForEntity(defender);
        for (ItemStack stack : defender.func_184193_aE()) {
            Item item = stack.func_77973_b();
            if (!(item instanceof ItemArmor) && !(item instanceof ISpecialArmor)) continue;
            ItemArmor armorItem = (ItemArmor)item;
            if (helmetOnly && armorItem.field_77881_a != EntityEquipmentSlot.HEAD || bootsOnly && armorItem.field_77881_a != EntityEquipmentSlot.FEET) continue;
            IArmorDistribution armorDist = armorMap.get(armorItem.field_77881_a);
            int damageAmount = (int)MathHelper.func_151237_a((double)Math.floor(absorb[0] * armorDist.getSlashingWeight() + absorb[1] * armorDist.getPiercingWeight() + absorb[2] * armorDist.getBludgeoningWeight()), (double)1.0, (double)3.4028234663852886E38);
            if (item instanceof ISpecialArmor) {
                ISpecialArmor armor = (ISpecialArmor)item;
                if (armor.handleUnblockableDamage(defender, stack, dmgSource, (double)totalDamage, armorItem.func_185083_B_().ordinal())) continue;
                DistinctDamageDescriptions.debug("Damaging ISpecialArmor by: " + damageAmount);
                armor.damageArmor(defender, stack, dmgSource, damageAmount, armorItem.func_185083_B_().ordinal());
                continue;
            }
            DistinctDamageDescriptions.debug("Damaging ItemArmor by: " + damageAmount);
            stack.func_77972_a(damageAmount, defender);
        }
    }

    @SubscribeEvent
    public void onKnockback(LivingKnockBackEvent evt) {
        UUID uuid = evt.getEntityLiving().func_110124_au();
        if (shouldKnockback.get(uuid).booleanValue()) {
            evt.setCanceled(true);
            shouldKnockback.remove(uuid);
        }
    }

    private static float modDmg(float damage, float armor, float toughness, boolean applyAnvilReductionCap) {
        return (float)MathHelper.func_151237_a((double)(damage * (1.0f - Math.max(armor / 5.0f, armor - damage / (6.0f + toughness / 4.0f)) / 25.0f)), (double)0.0, (double)(applyAnvilReductionCap ? 0.75 * (double)damage : 3.4028234663852886E38));
    }

    private static void spawnRandomAmountOfParticles(Entity origin, DDDParticleType type) {
        ParticleManager manager = Minecraft.func_71410_x().field_71452_i;
        int amount = (int)(2.0 * Math.random()) + 2;
        for (int i = 0; i < amount; ++i) {
            manager.func_78873_a((Particle)new DDDParticle(origin, 0.0, 4.0, 0.0, type, particleDisplacement));
        }
    }
}

