/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.handlers;

import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import yeelp.distinctdamagedescriptions.api.DDDAPI;
import yeelp.distinctdamagedescriptions.handlers.Handler;
import yeelp.distinctdamagedescriptions.registries.DDDRegistries;
import yeelp.distinctdamagedescriptions.util.ComparableTriple;
import yeelp.distinctdamagedescriptions.util.DamageType;
import yeelp.distinctdamagedescriptions.util.IArmorDistribution;
import yeelp.distinctdamagedescriptions.util.IDamageDistribution;
import yeelp.distinctdamagedescriptions.util.KeyHelper;
import yeelp.distinctdamagedescriptions.util.MobResistanceCategories;

public class TooltipHandler
extends Handler {
    private static final DecimalFormat formatter = new DecimalFormat("##.##%");
    private static final Style GRAY = new Style().func_150238_a(TextFormatting.GRAY);
    private static final Style WHITE = new Style().func_150238_a(TextFormatting.WHITE);
    private static final Style LIGHT_PURPLE = new Style().func_150238_a(TextFormatting.LIGHT_PURPLE);
    private static final Style YELLOW = new Style().func_150238_a(TextFormatting.YELLOW);
    private static final Style AQUA = new Style().func_150238_a(TextFormatting.AQUA);
    private static final Style DARK_RED = new Style().func_150238_a(TextFormatting.DARK_RED);
    private static final ITextComponent slashTooltip = new TextComponentTranslation("damagetypes.distinctdamagedescriptions.slashing", new Object[0]).func_150255_a(WHITE);
    private static final ITextComponent pierceTooltip = new TextComponentTranslation("damagetypes.distinctdamagedescriptions.piercing", new Object[0]).func_150255_a(WHITE);
    private static final ITextComponent bludgeTooltip = new TextComponentTranslation("damagetypes.distinctdamagedescriptions.bludgeoning", new Object[0]).func_150255_a(WHITE);
    private static final ITextComponent shiftTooltip = new TextComponentTranslation("keys.distinctdamagedescriptions.shift", new Object[0]).func_150255_a(YELLOW);
    private static final ITextComponent ctrlTooltip = new TextComponentTranslation("keys.distinctdamagedescriptions.ctrl", new Object[0]).func_150255_a(YELLOW);
    private static final ITextComponent damageTooltip = new TextComponentTranslation("tooltips.distinctdamagedescriptions.damage", new Object[0]).func_150255_a(GRAY);
    private static final ITextComponent resistanceTooltip = new TextComponentTranslation("tooltips.distinctdamagedescriptions.resistance", new Object[0]).func_150255_a(GRAY);
    private static final ITextComponent weaknessTooltip = new TextComponentTranslation("tooltips.distinctdamagedescriptions.weakness", new Object[0]).func_150255_a(DARK_RED);
    private static final ITextComponent effectivenessTooltip = new TextComponentTranslation("tooltips.distinctdamagedescriptions.effectiveness", new Object[0]).func_150255_a(GRAY);
    private static final ITextComponent damageDistTooltip = new TextComponentTranslation("tooltips.distinctdamagedescriptions.damagedistribution", new Object[0]).func_150255_a(GRAY);
    private static final ITextComponent projDistTooltip = new TextComponentTranslation("tooltips.distinctdamagedescriptions.projectiledistribution", new Object[0]).func_150255_a(GRAY);
    private static final ITextComponent armorResistTooltip = new TextComponentTranslation("tooltips.distinctdamagedescriptions.armorresistances", new Object[0]).func_150255_a(GRAY);
    private static final ITextComponent mobResistTooltip = new TextComponentTranslation("tooltips.distinctdamagedescriptions.mobresistances", new Object[0]).func_150255_a(GRAY);
    private static final ITextComponent mobImmunityTooltip = new TextComponentTranslation("tooltips.distinctdamagedescriptions.immunities", new Object[0]).func_150255_a(AQUA);
    private static final ITextComponent mobAdaptiveTooltip = new TextComponentTranslation("tooltips.distinctdamagedescriptions.adaptivechance", new Object[0]).func_150255_a(LIGHT_PURPLE);
    private static final ITextComponent mobAdaptiveAmountTooltip = new TextComponentTranslation("tooltips.distinctdamagedescriptions.adaptiveamount", new Object[0]).func_150255_a(LIGHT_PURPLE);
    private static final ITextComponent[] damageTypeTooltips = new ITextComponent[]{slashTooltip, pierceTooltip, bludgeTooltip};
    private static final String resistanceColor = TextFormatting.GRAY.toString();
    private static final String weaknessColor = TextFormatting.DARK_RED.toString();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @SideOnly(value=Side.CLIENT)
    public void onTooltip(ItemTooltipEvent evt) {
        int index;
        IDamageDistribution damages = DDDAPI.accessor.getDamageDistribution(evt.getItemStack());
        IArmorDistribution armors = DDDAPI.accessor.getArmorResistances(evt.getItemStack());
        List tooltips = evt.getToolTip();
        boolean advanced = evt.getFlags().func_194127_a();
        Item item = evt.getItemStack().func_77973_b();
        ComparableTriple<Float, Float, Float> projDist = DDDRegistries.projectileProperties.getProjectileDamageTypesFromItemID(item.getRegistryName().toString());
        boolean shiftHeld = KeyHelper.isShiftHeld();
        boolean ctrlHeld = KeyHelper.isCtrlHeld();
        if (damages != null) {
            index = 1;
            if (projDist != null) {
                if (ctrlHeld) {
                    for (DamageType type : DamageType.values()) {
                        int i = type.ordinal();
                        float percent = ((Float)projDist.get(i)).floatValue();
                        if (!(percent > 0.0f)) continue;
                        tooltips.add(index, TooltipHandler.makeDamagePercentTooltip(percent, damageTypeTooltips[i]));
                    }
                }
                tooltips.add(index, projDistTooltip.func_150254_d() + (ctrlHeld ? "" : " " + ctrlTooltip.func_150254_d()));
            }
            if (shiftHeld) {
                float slashPercent = damages.getSlashingWeight();
                float piercePercent = damages.getPiercingWeight();
                float bludgePercent = damages.getBludgeoningWeight();
                if (slashPercent > 0.0f) {
                    tooltips.add(index, TooltipHandler.makeDamagePercentTooltip(slashPercent, slashTooltip));
                }
                if (piercePercent > 0.0f) {
                    tooltips.add(index, TooltipHandler.makeDamagePercentTooltip(piercePercent, pierceTooltip));
                }
                if (bludgePercent > 0.0f) {
                    tooltips.add(index, TooltipHandler.makeDamagePercentTooltip(bludgePercent, bludgeTooltip));
                }
            }
            tooltips.add(index, damageDistTooltip.func_150254_d() + (shiftHeld ? "" : " " + shiftTooltip.func_150254_d()));
        }
        if (item instanceof ItemMonsterPlacer) {
            ItemMonsterPlacer spawnegg = (ItemMonsterPlacer)item;
            MobResistanceCategories mobCats = DDDRegistries.mobResists.getResistancesForMob(ItemMonsterPlacer.func_190908_h((ItemStack)evt.getItemStack()).toString());
            int index2 = tooltips.size();
            if (advanced) {
                index2 = tooltips.size() - 2;
            }
            int startingIndex = index2;
            if (ctrlHeld) {
                float[] resistsPercents = new float[]{mobCats.getSlashingResistance(), mobCats.getPiercingResistance(), mobCats.getBludgeoningResistance()};
                boolean[] immunities = new boolean[]{mobCats.getSlashingImmunity(), mobCats.getPiercingImmunity(), mobCats.getBludgeoningImmunity()};
                float adaptive = mobCats.adaptiveChance();
                float adaptiveAmount = mobCats.getAdaptiveAmount();
                Tuple adaptiveInfo = new Tuple((Object)Float.valueOf(adaptive), (Object)Float.valueOf(adaptiveAmount));
                boolean hasImmunities = false;
                for (DamageType type : DamageType.values()) {
                    tooltips.add(index2, TooltipHandler.makeMobResistTooltip(resistsPercents[type.ordinal()], damageTypeTooltips[type.ordinal()]));
                    hasImmunities = hasImmunities || immunities[type.ordinal()];
                }
                if (hasImmunities) {
                    index2 = tooltips.size();
                    if (advanced) {
                        index2 = tooltips.size() - 2;
                    }
                    tooltips.add(index2, TooltipHandler.makeMobImmunityTooltip(immunities));
                }
                if (adaptive > 0.0f) {
                    index2 = tooltips.size();
                    if (advanced) {
                        index2 = tooltips.size() - 2;
                    }
                    Tuple<String, String> adaptiveTooltips = TooltipHandler.makeMobAdaptiveTooltip((Tuple<Float, Float>)adaptiveInfo);
                    tooltips.add(index2, adaptiveTooltips.func_76340_b());
                    tooltips.add(index2, adaptiveTooltips.func_76341_a());
                }
            }
            tooltips.add(startingIndex, mobResistTooltip.func_150254_d() + (ctrlHeld ? "" : " " + ctrlTooltip.func_150254_d()));
        }
        if (armors != null) {
            index = 1;
            if (ctrlHeld) {
                float slashResist = armors.getSlashingWeight();
                float pierceResist = armors.getPiercingWeight();
                float bludgeResist = armors.getBludgeoningWeight();
                if (slashResist != 0.0f) {
                    tooltips.add(index, TooltipHandler.makeArmorTooltip(slashResist, slashTooltip));
                }
                if (pierceResist != 0.0f) {
                    tooltips.add(index, TooltipHandler.makeArmorTooltip(pierceResist, pierceTooltip));
                }
                if (bludgeResist != 0.0f) {
                    tooltips.add(index, TooltipHandler.makeArmorTooltip(bludgeResist, bludgeTooltip));
                }
            }
            tooltips.add(index, armorResistTooltip.func_150254_d() + (ctrlHeld ? "" : " " + ctrlTooltip.func_150254_d()));
        }
    }

    private static String makeArmorTooltip(float percent, ITextComponent tooltip) {
        return String.format("   %s %s %s", TooltipHandler.formatNum(percent).substring(1), tooltip.func_150254_d(), effectivenessTooltip.func_150254_d());
    }

    private static String makeDamagePercentTooltip(float percent, ITextComponent tooltip) {
        return String.format("   %s %s %s", TooltipHandler.formatNum(percent).substring(1), tooltip.func_150254_d(), damageTooltip.func_150254_d());
    }

    private static String makeMobResistTooltip(float percent, ITextComponent tooltip) {
        boolean isNegative = percent < 0.0f;
        return String.format("   %s%s %s %s", isNegative ? weaknessColor : resistanceColor, TooltipHandler.formatNum(percent).substring(1), tooltip.func_150254_d(), isNegative ? weaknessTooltip.func_150254_d() : resistanceTooltip.func_150254_d());
    }

    private static String makeMobImmunityTooltip(boolean[] immunities) {
        String str = mobImmunityTooltip.func_150254_d() + " ";
        for (DamageType type : DamageType.values()) {
            if (!immunities[type.ordinal()]) continue;
            str = str + damageTypeTooltips[type.ordinal()].func_150254_d() + ", ";
        }
        str = str.trim();
        return str.substring(0, str.length() - 1);
    }

    private static Tuple<String, String> makeMobAdaptiveTooltip(Tuple<Float, Float> adaptiveInfo) {
        String str1 = String.format("%s %s", mobAdaptiveTooltip.func_150254_d(), TooltipHandler.formatNum(((Float)adaptiveInfo.func_76341_a()).floatValue()).substring(1));
        String str2 = String.format("   %s %s", mobAdaptiveAmountTooltip.func_150254_d(), TooltipHandler.formatNum(((Float)adaptiveInfo.func_76340_b()).floatValue()).substring(1));
        return new Tuple((Object)str1, (Object)str2);
    }

    private static String formatNum(float num) {
        return String.format("%s%s", num < 0.0f ? "" : "+", formatter.format(num));
    }
}

