/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.init;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import yeelp.distinctdamagedescriptions.handlers.PacketHandler;
import yeelp.distinctdamagedescriptions.network.SoundMessage;

public final class DDDSounds {
    private static final Map<String, SoundEvent> SOUND_MAP = new HashMap<String, SoundEvent>();
    public static final SoundEvent RESIST_DING = DDDSounds.createSoundEvent("resist_ding");
    public static final SoundEvent WEAKNESS_HIT = DDDSounds.createSoundEvent("weakness_hit");
    public static final SoundEvent IMMUNITY_HIT = DDDSounds.createSoundEvent("immunity_hit");
    public static final SoundEvent HIGH_RESIST_HIT = DDDSounds.createSoundEvent("high_resist_hit");
    public static final SoundEvent ADAPTABILITY_CHANGE = DDDSounds.createSoundEvent("adaptability_change");

    public static void init() {
        for (Map.Entry<String, SoundEvent> entry : SOUND_MAP.entrySet()) {
            DDDSounds.registerSound(entry.getKey(), entry.getValue());
        }
    }

    private static SoundEvent createSoundEvent(String id) {
        SoundEvent sound = new SoundEvent(new ResourceLocation("distinctdamagedescriptions", id));
        SOUND_MAP.put(id, sound);
        return sound;
    }

    private static void registerSound(String name, SoundEvent sound) {
        sound.setRegistryName("distinctdamagedescriptions", name);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)sound);
    }

    public static boolean playSound(EntityPlayer player, SoundEvent name, float vol, float pitch) {
        if (player instanceof EntityPlayerMP) {
            PacketHandler.INSTANCE.sendTo((IMessage)new SoundMessage(name, vol, pitch), (EntityPlayerMP)player);
            return true;
        }
        return false;
    }
}

