/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import yeelp.distinctdamagedescriptions.network.NetworkHelper;

public final class SoundMessage
implements IMessage {
    private String id;
    private float volume;
    private float pitch;

    public SoundMessage() {
    }

    public SoundMessage(@Nonnull SoundEvent sound, float volume, float pitch) {
        this.id = sound.getRegistryName().toString();
        this.volume = volume;
        this.pitch = pitch;
    }

    public String getSoundID() {
        return this.id;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer pakBuf = new PacketBuffer(buf);
        this.id = pakBuf.func_150789_c(100);
        this.volume = pakBuf.readFloat();
        this.pitch = pakBuf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer pakBuf = new PacketBuffer(buf);
        pakBuf.func_180714_a(this.id);
        pakBuf.writeFloat(this.volume);
        pakBuf.writeFloat(this.pitch);
    }

    public static final class Handler
    implements IMessageHandler<SoundMessage, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(SoundMessage message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public void handle(SoundMessage msg, MessageContext ctx) {
            SoundEvent sound;
            EntityPlayer player = NetworkHelper.getSidedPlayer(ctx);
            if (player != null && (sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(msg.getSoundID()))) != null) {
                player.func_184185_a(sound, msg.getVolume(), msg.getPitch());
            }
        }
    }
}

