/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.registries;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Tuple;
import org.apache.commons.io.FilenameUtils;
import yeelp.distinctdamagedescriptions.DistinctDamageDescriptions;
import yeelp.distinctdamagedescriptions.ModConfig;
import yeelp.distinctdamagedescriptions.registries.DDDRegistries;
import yeelp.distinctdamagedescriptions.registries.IDDDCreatureTypeRegistry;
import yeelp.distinctdamagedescriptions.registries.IDDDDamageTypeRegistry;
import yeelp.distinctdamagedescriptions.registries.IDDDItemPropertiesRegistry;
import yeelp.distinctdamagedescriptions.registries.IDDDMobDamageRegistry;
import yeelp.distinctdamagedescriptions.registries.IDDDMobResistancesRegistry;
import yeelp.distinctdamagedescriptions.registries.IDDDProjectilePropertiesRegistry;
import yeelp.distinctdamagedescriptions.util.ComparableTriple;
import yeelp.distinctdamagedescriptions.util.CreatureTypeData;
import yeelp.distinctdamagedescriptions.util.DDDDamageType;
import yeelp.distinctdamagedescriptions.util.DamageTypeData;
import yeelp.distinctdamagedescriptions.util.FileHelper;
import yeelp.distinctdamagedescriptions.util.MobResistanceCategories;
import yeelp.distinctdamagedescriptions.util.NonNullMap;
import yeelp.distinctdamagedescriptions.util.SyntaxException;

public enum DDDRegistriesImpl implements IDDDCreatureTypeRegistry,
IDDDMobResistancesRegistry,
IDDDMobDamageRegistry,
IDDDItemPropertiesRegistry,
IDDDProjectilePropertiesRegistry,
IDDDDamageTypeRegistry
{
    INSTANCE;

    private final Map<String, MobResistanceCategories> mobResists = new NonNullMap<String, MobResistanceCategories>(new MobResistanceCategories(0.0f, 0.0f, 0.0f, false, false, false, 0.0f, 0.0f));
    private final Map<String, CreatureTypeData> creatureTypes = new NonNullMap<String, CreatureTypeData>(CreatureTypeData.UNKNOWN);
    private final Map<String, Tuple<String, String>> creatureMap = new NonNullMap<String, Tuple>(new Tuple((Object)"unknown", (Object)"unknown"));
    private final Map<String, ComparableTriple<Float, Float, Float>> mobDamage = new NonNullMap<String, ComparableTriple<Float, Float, Float>>(new ComparableTriple<Float, Float, Float>(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)));
    private final Map<String, ComparableTriple<Float, Float, Float>> itemArmorDist = new NonNullMap<String, ComparableTriple<Float, Float, Float>>(new ComparableTriple<Float, Float, Float>(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
    private final Map<String, ComparableTriple<Float, Float, Float>> itemDamageDist = new NonNullMap<String, ComparableTriple<Float, Float, Float>>(new ComparableTriple<Float, Float, Float>(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)));
    private final Map<String, ComparableTriple<Float, Float, Float>> projectileDist = new NonNullMap<String, ComparableTriple<Float, Float, Float>>(new ComparableTriple<Float, Float, Float>(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)));
    private final Map<String, String> itemIDToProjIDMap = new HashMap<String, String>();
    private final Map<String, String> itemDamageTypes = new NonNullMap<String, String>("ddd_normal");
    private final Map<String, Tuple<Map<String, String>, Map<String, String>>> damageTypeMap = new HashMap<String, Tuple<Map<String, String>, Map<String, String>>>();
    private final Map<String, Tuple<String, String>> deathMessages = new HashMap<String, Tuple<String, String>>();
    private final Map<String, String> includeAllMap = new NonNullMap<String, String>("ddd_normal");
    private static File[] creatureJsonFiles;
    private static File[] damageTypeJsonFiles;
    private static File creatureDirectory;
    private static File damageTypeDirectory;

    private DDDRegistriesImpl() {
        DDDRegistries.creatureTypes = this;
        DDDRegistries.mobResists = this;
        DDDRegistries.mobDamage = this;
        DDDRegistries.itemProperties = this;
        DDDRegistries.projectileProperties = this;
        DDDRegistries.damageTypes = this;
        try {
            this.init();
        }
        catch (Exception e) {
            DistinctDamageDescriptions.fatal("Encountered severe error loading registries!");
            DistinctDamageDescriptions.fatal("Exception type: " + e.getClass().getSimpleName() + ": " + e.getLocalizedMessage());
            DistinctDamageDescriptions.fatal("Trace: " + Arrays.toString(e.getStackTrace()));
            throw e;
        }
    }

    @Override
    public void init() {
        File mainDirectory = DistinctDamageDescriptions.getModConfigDirectory();
        creatureDirectory = new File(mainDirectory, "creatureTypes");
        damageTypeDirectory = new File(mainDirectory, "damageTypes");
        if (creatureDirectory.exists() && damageTypeDirectory.exists() || damageTypeDirectory.mkdirs() && creatureDirectory.mkdirs()) {
            creatureJsonFiles = creatureDirectory.listFiles();
            damageTypeJsonFiles = damageTypeDirectory.listFiles();
            if (DDDRegistriesImpl.writeExampleJSON("example_creature_type.json", creatureDirectory)) {
                creatureJsonFiles = creatureDirectory.listFiles();
            }
            if (DDDRegistriesImpl.writeExampleJSON("example_damage_type.json", damageTypeDirectory)) {
                damageTypeJsonFiles = damageTypeDirectory.listFiles();
            }
            DistinctDamageDescriptions.debug("Checked JSON");
            this.load();
        }
    }

    @Override
    public MobResistanceCategories getResistancesForMob(String key) {
        return this.mobResists.get(key);
    }

    @Override
    public Tuple<CreatureTypeData, CreatureTypeData> getCreatureTypeForMob(String key) {
        Tuple<String, String> t = this.creatureMap.get(key);
        CreatureTypeData main = null;
        CreatureTypeData sub = null;
        if (!((String)t.func_76341_a()).equals(CreatureTypeData.UNKNOWN.getTypeName())) {
            main = this.creatureTypes.get(t.func_76341_a());
            sub = !((String)t.func_76340_b()).equals(CreatureTypeData.UNKNOWN.getTypeName()) ? this.creatureTypes.get(t.func_76340_b()) : CreatureTypeData.UNKNOWN;
        } else {
            main = CreatureTypeData.UNKNOWN;
            sub = CreatureTypeData.UNKNOWN;
        }
        return new Tuple((Object)main, (Object)sub);
    }

    @Override
    public CreatureTypeData getCreatureTypeData(String key) {
        return this.creatureTypes.get(key);
    }

    @Override
    public ComparableTriple<Float, Float, Float> getMobDamage(String key) {
        return this.mobDamage.get(key);
    }

    @Override
    public ComparableTriple<Float, Float, Float> getDamageDistributionForItem(String key) {
        return this.itemDamageDist.get(key);
    }

    @Override
    public ComparableTriple<Float, Float, Float> getArmorDistributionForItem(String key) {
        return this.itemArmorDist.get(key);
    }

    @Override
    public ComparableTriple<Float, Float, Float> getProjectileDamageTypes(String key) {
        return this.projectileDist.get(key);
    }

    @Override
    public ComparableTriple<Float, Float, Float> getProjectileDamageTypesFromItemID(String itemID) {
        String str = this.itemIDToProjIDMap.get(itemID);
        if (str != null) {
            return this.projectileDist.get(str);
        }
        return null;
    }

    @Override
    public boolean isProjectileRegistered(Entity projectile) {
        return this.projectileDist.containsKey(EntityList.func_191301_a((Entity)projectile).toString());
    }

    @Override
    public void registerDamageType(String name, String entityMsg, String otherMsg, Set<String> items, DamageTypeData ... datas) {
        name = "ddd_" + name;
        this.deathMessages.put(name, (Tuple<String, String>)new Tuple((Object)entityMsg, (Object)otherMsg));
        for (String s2 : items) {
            this.itemDamageTypes.put(s2, name);
        }
        for (DamageTypeData d : datas) {
            NonNullMap direct = new NonNullMap("ddd_normal");
            NonNullMap indirect = new NonNullMap("ddd_normal");
            if (d.includeAll()) {
                this.includeAllMap.put(d.getOriginalSource(), name);
            }
            for (String s3 : d.getDirectSources()) {
                direct.put(s3, name);
            }
            for (String s3 : d.getIndirectSources()) {
                indirect.put(s3, name);
            }
            this.damageTypeMap.compute(d.getOriginalSource(), (s, t) -> this.damageTypeMap.containsKey(s) ? DDDRegistriesImpl.updateTuple((Tuple<Map<String, String>, Map<String, String>>)t, direct, indirect) : new Tuple((Object)direct, (Object)indirect));
        }
        DistinctDamageDescriptions.debug("Registered damage type: " + name);
    }

    @Override
    public DamageSource getDamageType(DamageSource originalSource) {
        Tuple<Map<String, String>, Map<String, String>> t;
        EntityLivingBase livingEntity;
        ItemStack stack;
        Entity entity = originalSource.func_76364_f();
        String weaponSource = "ddd_normal";
        String additionalSource = this.includeAllMap.get(originalSource.field_76373_n);
        if (entity instanceof EntityLivingBase && !(stack = (livingEntity = (EntityLivingBase)entity).func_184614_ca()).func_190926_b()) {
            weaponSource = this.itemDamageTypes.get(stack.func_77973_b().getRegistryName().toString());
        }
        if ((t = this.damageTypeMap.get(originalSource.field_76373_n)) == null) {
            if (weaponSource.equals("ddd_normal")) {
                return originalSource;
            }
            return new DDDDamageType(originalSource, weaponSource, additionalSource);
        }
        String direct = EntityList.func_191301_a((Entity)originalSource.func_76364_f()).toString();
        String indirect = EntityList.func_191301_a((Entity)originalSource.func_76346_g()).toString();
        DistinctDamageDescriptions.debug(direct + ", " + indirect);
        DistinctDamageDescriptions.debug((String)((Map)t.func_76341_a()).get(direct) + ", " + (String)((Map)t.func_76340_b()).get(indirect));
        return new DDDDamageType(originalSource, (String)((Map)t.func_76341_a()).get(direct), (String)((Map)t.func_76340_b()).get(indirect), weaponSource, additionalSource);
    }

    @Override
    public String getDeathMessage(@Nonnull String type, @Nonnull String defenderName, @Nullable String attackerName) {
        Tuple<String, String> t = this.deathMessages.get(type);
        if (t == null) {
            DistinctDamageDescriptions.debug("This makes no sense hello??");
            DistinctDamageDescriptions.debug(String.format("%s, %s %s", type, defenderName, attackerName == null ? "null" : attackerName));
        }
        if (attackerName == null) {
            return ((String)this.deathMessages.get(type).func_76340_b()).replaceAll("#defender", defenderName);
        }
        return ((String)this.deathMessages.get(type).func_76341_a()).replaceAll("#attacker", attackerName).replaceAll("#defender", defenderName);
    }

    private static Tuple<Map<String, String>, Map<String, String>> updateTuple(Tuple<Map<String, String>, Map<String, String>> t, Map<String, String> direct, Map<String, String> indirect) {
        ((Map)t.func_76341_a()).putAll(direct);
        ((Map)t.func_76340_b()).putAll(indirect);
        return t;
    }

    private static String[] tryPut(Map<String, ComparableTriple<Float, Float, Float>> map, String s) {
        String[] contents = s.split(";");
        try {
            map.put(contents[0], new ComparableTriple<Float, Float, Float>(Float.valueOf(contents[1]), Float.valueOf(contents[2]), Float.valueOf(contents[3])));
            return contents;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            DistinctDamageDescriptions.warn(s + " isn't a valid entry! Ignoring...");
            return null;
        }
    }

    private static boolean writeExampleJSON(String filename, File parentDirectory) {
        String relativePath = "example/" + filename;
        File dest = new File(parentDirectory, filename);
        try {
            boolean shouldOverwrite = DDDRegistriesImpl.shouldOverwriteExampleJSON(dest);
            if (DistinctDamageDescriptions.srcFile != null && DistinctDamageDescriptions.srcFile.isDirectory()) {
                File source = new File(DistinctDamageDescriptions.srcFile, relativePath);
                return FileHelper.copyFile(source, dest, shouldOverwrite);
            }
            InputStream stream = DDDRegistriesImpl.class.getClassLoader().getResourceAsStream(relativePath);
            boolean result = FileHelper.copyFile(stream, dest, shouldOverwrite);
            stream.close();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean shouldOverwriteExampleJSON(File json) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void load() {
        JsonObject obj;
        JsonElement elem;
        JsonReader reader;
        JsonParser parser;
        if (ModConfig.resist.useCreatureTypes) {
            DistinctDamageDescriptions.info("Creature Types Enabled!");
            parser = new JsonParser();
            for (File f : creatureJsonFiles) {
                if (FilenameUtils.getExtension((String)f.getName()).equalsIgnoreCase(".json")) continue;
                try {
                    Object j2;
                    reader = new JsonReader((Reader)new FileReader(f));
                    reader.setLenient(true);
                    elem = parser.parse(reader);
                    obj = elem.getAsJsonObject();
                    String type = obj.get("name").getAsString().toLowerCase();
                    if (type.equals("unknown")) {
                        throw new IllegalArgumentException("unknown is an invaild creature type!");
                    }
                    float slash = DDDRegistriesImpl.getJsonFloat(obj, "slashing_resistance", f);
                    float pierce = DDDRegistriesImpl.getJsonFloat(obj, "piercing_resistance", f);
                    float bludge = DDDRegistriesImpl.getJsonFloat(obj, "bludgeoning_resistance", f);
                    String immunities = DDDRegistriesImpl.getJsonString(obj, "physicalImmunities", f);
                    boolean slashImmune = immunities.contains("s");
                    boolean pierceImmune = immunities.contains("p");
                    boolean bludgeImmune = immunities.contains("b");
                    float adaptiveChance = DDDRegistriesImpl.getJsonFloat(obj, "adaptability_chance", f);
                    float adaptiveAmount = DDDRegistriesImpl.getJsonFloat(obj, "adaptability_amount", f);
                    boolean critImmunity = DDDRegistriesImpl.getJsonBoolean(obj, "critical_hit_immunity", f);
                    HashSet<String> potionImmunities = new HashSet<String>();
                    for (Object j2 : DDDRegistriesImpl.getJsonArray(obj, "potion_immunities", f)) {
                        if (j2.isJsonPrimitive() && j2.getAsJsonPrimitive().isString()) {
                            potionImmunities.add(j2.getAsString());
                            continue;
                        }
                        throw new SyntaxException("Invalid potion immunity in JSON " + f.getName());
                    }
                    for (Object j2 : DDDRegistriesImpl.getJsonArray(obj, "main_type_mobs", f)) {
                        if (j2.isJsonPrimitive() && j2.getAsJsonPrimitive().isString()) {
                            this.creatureMap.compute(j2.getAsString(), (s, t) -> new Tuple((Object)type, t.func_76340_b()));
                            continue;
                        }
                        throw new SyntaxException("Invalid Entity ID for main type in JSON " + f.getName());
                    }
                    for (Object j2 : DDDRegistriesImpl.getJsonArray(obj, "sub_type_mobs", f)) {
                        if (j2.isJsonPrimitive() && j2.getAsJsonPrimitive().isString()) {
                            this.creatureMap.compute(j2.getAsString(), (s, t) -> new Tuple(t.func_76341_a(), (Object)type));
                            continue;
                        }
                        throw new SyntaxException("Invalid Entity ID for sub type in JSON " + f.getName());
                    }
                    NonNullMap<String, Float> modifierMap = new NonNullMap<String, Float>(Float.valueOf(0.0f));
                    j2 = DDDRegistriesImpl.getJsonArray(obj, "extraProperties", f).iterator();
                    while (j2.hasNext()) {
                        JsonElement j3 = (JsonElement)j2.next();
                        try {
                            JsonObject o = j3.getAsJsonObject();
                            modifierMap.put(DDDRegistriesImpl.getJsonString(o, "damageTypeName", f), Float.valueOf(DDDRegistriesImpl.getJsonFloat(o, "resistance", f)));
                        }
                        catch (IllegalStateException e) {
                            throw new SyntaxException("Invalid JSON for extra properties in " + f.getName());
                        }
                    }
                    MobResistanceCategories cats = new MobResistanceCategories(slash, pierce, bludge, slashImmune, pierceImmune, bludgeImmune, adaptiveChance, adaptiveAmount);
                    this.creatureTypes.put(type, new CreatureTypeData(type, cats, potionImmunities, critImmunity, modifierMap));
                    DistinctDamageDescriptions.debug("registered creature type: " + type);
                }
                catch (FileNotFoundException e) {
                    DistinctDamageDescriptions.err("Could not find JSON!");
                }
                catch (ClassCastException | IllegalStateException e1) {
                    DistinctDamageDescriptions.err("Could not parse " + f.getName() + " as a CreatureType!");
                }
            }
            for (String s2 : this.creatureMap.keySet()) {
                Tuple<CreatureTypeData, CreatureTypeData> data = this.getCreatureTypeForMob(s2);
                CreatureTypeData main = (CreatureTypeData)data.func_76341_a();
                CreatureTypeData sub = (CreatureTypeData)data.func_76340_b();
                if (main == CreatureTypeData.UNKNOWN) continue;
                if (sub == CreatureTypeData.UNKNOWN) {
                    this.mobResists.put(s2, main.getMobResistances());
                    continue;
                }
                MobResistanceCategories mainCat = main.getMobResistances();
                MobResistanceCategories subCat = sub.getMobResistances();
                MobResistanceCategories cats = new MobResistanceCategories(0.75f * mainCat.getSlashingResistance() + 0.25f * subCat.getSlashingResistance(), 0.75f * mainCat.getPiercingResistance() + 0.25f * subCat.getPiercingResistance(), 0.75f * mainCat.getBludgeoningResistance() + 0.25f * subCat.getBludgeoningResistance(), mainCat.getSlashingImmunity(), mainCat.getPiercingImmunity(), mainCat.getBludgeoningImmunity(), mainCat.adaptiveChance(), mainCat.getAdaptiveAmount());
                this.mobResists.put(s2, cats);
            }
            DistinctDamageDescriptions.info("Loaded Creature Types!");
        }
        if (ModConfig.dmg.useCustomDamageTypes) {
            DistinctDamageDescriptions.info("Custom Damage Types Enabled!");
            parser = new JsonParser();
            File[] fileArray = damageTypeJsonFiles;
            int n = fileArray.length;
            for (int data = 0; data < n; ++data) {
                File f;
                f = fileArray[data];
                if (FilenameUtils.getExtension((String)f.getName()).equalsIgnoreCase(".json")) continue;
                try {
                    reader = new JsonReader((Reader)new FileReader(f));
                    reader.setLenient(true);
                    elem = parser.parse(reader);
                    obj = elem.getAsJsonObject();
                    String name = DDDRegistriesImpl.getJsonString(obj, "name", f);
                    JsonArray arr = DDDRegistriesImpl.getJsonArray(obj, "damageTypes", f);
                    JsonObject msgs = obj.get("deathMessages").getAsJsonObject();
                    String entityMsg = DDDRegistriesImpl.getJsonString(msgs, "deathHasAttacker", f);
                    String otherMsg = DDDRegistriesImpl.getJsonString(msgs, "deathHasNoAttacker", f);
                    DamageTypeData[] datas = new DamageTypeData[arr.size()];
                    int i = 0;
                    for (JsonElement j : DDDRegistriesImpl.getJsonArray(obj, "damageTypes", f)) {
                        try {
                            JsonObject dmgObj = j.getAsJsonObject();
                            String damageName = DDDRegistriesImpl.getJsonString(dmgObj, "dmgSource", f);
                            boolean includeAll = DDDRegistriesImpl.getJsonBoolean(dmgObj, "includeAll", f);
                            Set<String> indirectSources = DDDRegistriesImpl.parsePrimitiveJsonArrayAsSet(DDDRegistriesImpl.getJsonArray(dmgObj, "indirectSources", f));
                            Set<String> directSources = DDDRegistriesImpl.parsePrimitiveJsonArrayAsSet(DDDRegistriesImpl.getJsonArray(dmgObj, "directSources", f));
                            datas[i++] = new DamageTypeData(damageName, directSources, indirectSources, includeAll);
                        }
                        catch (IllegalStateException e) {
                            DistinctDamageDescriptions.err("Invalid Json for damage type in file " + f.getName());
                            throw e;
                        }
                    }
                    Set<String> items = DDDRegistriesImpl.parsePrimitiveJsonArrayAsSet(DDDRegistriesImpl.getJsonArray(obj, "items", f));
                    this.registerDamageType(name, entityMsg, otherMsg, items, datas);
                    continue;
                }
                catch (FileNotFoundException e) {
                    DistinctDamageDescriptions.err("Could not find JSON!");
                }
            }
            DistinctDamageDescriptions.info("Loaded Custom Damage Types!");
        }
        for (String s3 : ModConfig.resist.mobBaseResist) {
            try {
                String[] contents = s3.split(";");
                this.mobResists.put(contents[0], new MobResistanceCategories(Float.valueOf(contents[1]).floatValue(), Float.valueOf(contents[2]).floatValue(), Float.valueOf(contents[3]).floatValue(), contents[4].contains("s"), contents[4].contains("p"), contents[4].contains("b"), Float.valueOf(contents[5]).floatValue(), Float.valueOf(contents[6]).floatValue()));
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                DistinctDamageDescriptions.warn(s3 + " isn't a valid entry! Ignoring...");
            }
        }
        DistinctDamageDescriptions.info("Mob resistances from config loaded!");
        for (String s4 : ModConfig.dmg.mobBaseDmg) {
            DDDRegistriesImpl.tryPut(this.mobDamage, s4);
        }
        DistinctDamageDescriptions.info("Mob damage loaded!");
        for (String s5 : ModConfig.resist.armorResist) {
            DDDRegistriesImpl.tryPut(this.itemArmorDist, s5);
        }
        DistinctDamageDescriptions.info("Armor resistances loaded!");
        for (String s6 : ModConfig.dmg.itemBaseDamage) {
            DDDRegistriesImpl.tryPut(this.itemDamageDist, s6);
        }
        DistinctDamageDescriptions.info("Weapon damage loaded!");
        for (String s7 : ModConfig.dmg.projectileDamageTypes) {
            String[] entry = DDDRegistriesImpl.tryPut(this.projectileDist, s7);
            if (entry.length != 5) continue;
            if (!entry[4].trim().isEmpty()) {
                for (String i : entry[4].split(",")) {
                    this.itemIDToProjIDMap.put(i, entry[0]);
                }
                continue;
            }
            DistinctDamageDescriptions.warn("Expected projectile item forms for " + entry[0] + " but found none! Either remove the trailing semicolon from this entry, or add item id's!");
        }
        DistinctDamageDescriptions.info("Projectile damage loaded!");
    }

    private static float getJsonFloat(JsonObject obj, String memberName, File f) {
        return DDDRegistriesImpl.getJsonElement(obj, memberName, f).getAsFloat();
    }

    private static String getJsonString(JsonObject obj, String memberName, File f) {
        return DDDRegistriesImpl.getJsonElement(obj, memberName, f).getAsString();
    }

    private static boolean getJsonBoolean(JsonObject obj, String memberName, File f) {
        return DDDRegistriesImpl.getJsonElement(obj, memberName, f).getAsBoolean();
    }

    private static JsonArray getJsonArray(JsonObject obj, String memberName, File f) {
        return DDDRegistriesImpl.getJsonElement(obj, memberName, f).getAsJsonArray();
    }

    @Nonnull
    private static JsonElement getJsonElement(JsonObject obj, String memberName, File f) {
        JsonElement e = obj.get(memberName);
        if (e == null) {
            throw new SyntaxException(memberName + " not found in JSON file " + f.getName() + "! Verify it's present and spelled correctly.");
        }
        return e;
    }

    private static Set<String> parsePrimitiveJsonArrayAsSet(JsonArray arr) {
        HashSet<String> set = new HashSet<String>();
        for (JsonElement e : arr) {
            if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
                set.add(e.getAsString());
                continue;
            }
            throw new SyntaxException("Invalid String JSON!");
        }
        return set;
    }
}

