/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.util;

import java.util.HashSet;
import java.util.Set;
import yeelp.distinctdamagedescriptions.util.ComparableTriple;
import yeelp.distinctdamagedescriptions.util.DamageType;

public final class ArmorCategories {
    private ComparableTriple<Float, Float, Float> armor;
    private ComparableTriple<Float, Float, Float> toughness;

    public ArmorCategories(float slashing, float piercing, float bludgeoning, float slashTough, float pierceTough, float bludgeTough) {
        this.armor = new ComparableTriple<Float, Float, Float>(Float.valueOf(slashing), Float.valueOf(piercing), Float.valueOf(bludgeoning));
        this.toughness = new ComparableTriple<Float, Float, Float>(Float.valueOf(slashTough), Float.valueOf(pierceTough), Float.valueOf(bludgeTough));
    }

    public ArmorCategories(ComparableTriple<Float, Float, Float> armor, ComparableTriple<Float, Float, Float> toughness) {
        this.armor = armor;
        this.toughness = toughness;
    }

    public float getSlashingArmor() {
        return this.armor.getLeft().floatValue();
    }

    public float getPiercingArmor() {
        return this.armor.getMiddle().floatValue();
    }

    public float getBludgeoningArmor() {
        return this.armor.getRight().floatValue();
    }

    public float getSlashingToughness() {
        return this.toughness.getLeft().floatValue();
    }

    public float getPiercingToughness() {
        return this.toughness.getMiddle().floatValue();
    }

    public float getBludgeoningToughness() {
        return this.toughness.getRight().floatValue();
    }

    public static Set<DamageType> getDamageTypes(ArmorCategories ... armorCategories) {
        HashSet<DamageType> set = new HashSet<DamageType>();
        for (ArmorCategories cat : armorCategories) {
            if (cat.getSlashingArmor() > 0.0f) {
                set.add(DamageType.SLASHING);
            }
            if (cat.getPiercingArmor() > 0.0f) {
                set.add(DamageType.PIERCING);
            }
            if (cat.getBludgeoningArmor() > 0.0f) {
                set.add(DamageType.BLUDGEONING);
            }
            if (set.size() != DamageType.values().length) continue;
            return set;
        }
        return set;
    }

    public String toString() {
        return String.format("(slashing: %f, piercing: %f, bludgeoning: %f)", Float.valueOf(this.getSlashingArmor()), Float.valueOf(this.getPiercingArmor()), Float.valueOf(this.getBludgeoningArmor()));
    }
}

