/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.util;

import java.util.concurrent.Callable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import yeelp.distinctdamagedescriptions.util.ArmorCategories;
import yeelp.distinctdamagedescriptions.util.ArmorDistributionProvider;
import yeelp.distinctdamagedescriptions.util.Distribution;
import yeelp.distinctdamagedescriptions.util.IArmorDistribution;

public class ArmorDistribution
extends Distribution
implements IArmorDistribution {
    public ArmorDistribution() {
        this(0.0f, 0.0f, 0.0f);
    }

    public ArmorDistribution(float slashing, float piercing, float bludgeoning) {
        super(slashing, piercing, bludgeoning);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == ArmorDistributionProvider.armorResist;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == ArmorDistributionProvider.armorResist ? ArmorDistributionProvider.armorResist.cast((Object)this) : null);
    }

    @Override
    public ArmorCategories distributeArmor(float armor, float toughness) {
        return new ArmorCategories(super.distribute(armor), super.distribute(toughness));
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IArmorDistribution.class, (Capability.IStorage)new ArmorResistancesStorage(), (Callable)new ArmorResistancesFactory());
    }

    private static class ArmorResistancesStorage
    implements Capability.IStorage<IArmorDistribution> {
        private ArmorResistancesStorage() {
        }

        public NBTBase writeNBT(Capability<IArmorDistribution> capability, IArmorDistribution instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<IArmorDistribution> capability, IArmorDistribution instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTBase)((NBTTagCompound)nbt));
        }
    }

    private static class ArmorResistancesFactory
    implements Callable<IArmorDistribution> {
        private ArmorResistancesFactory() {
        }

        @Override
        public IArmorDistribution call() throws Exception {
            return new ArmorDistribution();
        }
    }
}

