/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public class ComparableTriple<U extends Comparable<U>, V extends Comparable<V>, W extends Comparable<W>>
implements Iterable<Comparable<?>>,
Comparable<ComparableTriple<U, V, W>> {
    private U left;
    private V middle;
    private W right;

    public ComparableTriple(U left, V middle, W right) {
        this.left = left;
        this.middle = middle;
        this.right = right;
    }

    public U getLeft() {
        return this.left;
    }

    public V getMiddle() {
        return this.middle;
    }

    public W getRight() {
        return this.right;
    }

    public <T extends Comparable<T>> T get(int i) {
        switch (i) {
            case 0: {
                return (T)this.getLeft();
            }
            case 1: {
                return (T)this.getMiddle();
            }
            case 2: {
                return (T)this.getRight();
            }
        }
        throw new IllegalArgumentException("Only values 0, 1, 2 valid for get(int)!");
    }

    public <T extends Comparable<T>> void set(Comparable<T> obj, int i) {
        switch (i) {
            case 0: {
                this.left = obj;
                break;
            }
            case 1: {
                this.middle = obj;
                break;
            }
            case 2: {
                this.right = obj;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only values 0, 1, 2 valid for <T>set(T, int)!");
            }
        }
    }

    public void setLeft(U left) {
        this.left = left;
    }

    public void setMiddle(V middle) {
        this.middle = middle;
    }

    public void setRight(W right) {
        this.right = right;
    }

    @Override
    public int compareTo(ComparableTriple<U, V, W> otherTriple) {
        int compareU = this.left.compareTo(otherTriple.left);
        if (compareU == 0) {
            int compareV = this.middle.compareTo(otherTriple.middle);
            if (compareV == 0) {
                return this.right.compareTo(otherTriple.right);
            }
            return compareV;
        }
        return compareU;
    }

    @Override
    public Iterator<Comparable<?>> iterator() {
        return new TripleIterator(this);
    }

    public boolean equals(Object o) {
        if (o instanceof ComparableTriple) {
            ComparableTriple other = (ComparableTriple)o;
            return this.left.equals(other.left) && this.middle.equals(other.middle) && this.right.equals(other.right);
        }
        return false;
    }

    private static class TripleIterator
    implements Iterator<Comparable<?>> {
        Stack<Comparable<?>> elements = new Stack();

        <U extends Comparable<U>, V extends Comparable<V>, W extends Comparable<W>> TripleIterator(ComparableTriple<U, V, W> triple) {
            this.elements.push(((ComparableTriple)triple).right);
            this.elements.push(((ComparableTriple)triple).middle);
            this.elements.push(((ComparableTriple)triple).left);
        }

        @Override
        public boolean hasNext() {
            return !this.elements.isEmpty();
        }

        @Override
        public Comparable<?> next() {
            if (this.hasNext()) {
                return this.elements.pop();
            }
            throw new NoSuchElementException("Iteration tried to iterate over more elements after already iterating over them all!");
        }
    }
}

