/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.util;

import java.util.concurrent.Callable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import yeelp.distinctdamagedescriptions.registries.DDDRegistries;
import yeelp.distinctdamagedescriptions.util.CreatureTypeData;
import yeelp.distinctdamagedescriptions.util.CreatureTypeProvider;
import yeelp.distinctdamagedescriptions.util.ICreatureType;

public class CreatureType
implements ICreatureType {
    public static final CreatureType UNKNOWN = new CreatureType(CreatureTypeData.UNKNOWN, CreatureTypeData.UNKNOWN);
    public String mainType;
    public String subType;

    public CreatureType(CreatureTypeData main, CreatureTypeData sub) {
        this.mainType = main.getTypeName();
        this.subType = sub.getTypeName();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CreatureTypeProvider.creatureType;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CreatureTypeProvider.creatureType ? CreatureTypeProvider.creatureType.cast((Object)this) : null);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("mainType", this.mainType);
        tag.func_74778_a("subType", this.subType);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.mainType = nbt.func_74779_i("mainType");
        this.subType = nbt.func_74779_i("subType");
    }

    @Override
    public CreatureTypeData getMainCreatureTypeData() {
        return DDDRegistries.creatureTypes.getCreatureTypeData(this.mainType);
    }

    @Override
    public CreatureTypeData getSubCreatureTypeData() {
        return DDDRegistries.creatureTypes.getCreatureTypeData(this.subType);
    }

    @Override
    public boolean isImmuneToPotionEffect(PotionEffect effect) {
        return this.getMainCreatureTypeData().isImmuneToPotionEffect(effect) || this.getSubCreatureTypeData().isImmuneToPotionEffect(effect);
    }

    @Override
    public boolean isImmuneToCriticalHits() {
        return this.getMainCreatureTypeData().isImmuneToCriticals();
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(ICreatureType.class, (Capability.IStorage)new CreatureTypeStorage(), (Callable)new CreatureTypeFactory());
    }

    private static class CreatureTypeStorage
    implements Capability.IStorage<ICreatureType> {
        private CreatureTypeStorage() {
        }

        public NBTBase writeNBT(Capability<ICreatureType> capability, ICreatureType instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<ICreatureType> capability, ICreatureType instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTBase)((NBTTagCompound)nbt));
        }
    }

    private static class CreatureTypeFactory
    implements Callable<ICreatureType> {
        private CreatureTypeFactory() {
        }

        @Override
        public ICreatureType call() throws Exception {
            return UNKNOWN;
        }
    }
}

