/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.util;

import java.util.HashSet;
import java.util.Map;
import net.minecraft.potion.PotionEffect;
import yeelp.distinctdamagedescriptions.util.MobResistanceCategories;
import yeelp.distinctdamagedescriptions.util.NonNullMap;

public final class CreatureTypeData {
    public static final CreatureTypeData UNKNOWN = new CreatureTypeData();
    private String type;
    private MobResistanceCategories resists;
    private HashSet<String> potionImmunities;
    private Map<String, Float> extraResistances;
    private boolean criticalImmunity;

    public CreatureTypeData(String name, MobResistanceCategories resistances, HashSet<String> potionImmunities, boolean criticalImmunity, Map<String, Float> extraResistances) {
        this.type = name;
        this.resists = resistances;
        this.potionImmunities = potionImmunities;
        this.criticalImmunity = criticalImmunity;
        this.extraResistances = extraResistances;
    }

    private CreatureTypeData() {
        this.type = "unknown";
        this.resists = new MobResistanceCategories(0.0f, 0.0f, 0.0f, false, false, false, 0.0f, 0.0f);
        this.potionImmunities = new HashSet();
        this.criticalImmunity = false;
        this.extraResistances = new NonNullMap<String, Float>(Float.valueOf(0.0f));
    }

    public String getTypeName() {
        return this.type;
    }

    public MobResistanceCategories getMobResistances() {
        return this.resists;
    }

    public boolean isImmuneToPotionEffect(PotionEffect effect) {
        return this.potionImmunities.contains(effect.func_188419_a().getRegistryName().toString());
    }

    public boolean isImmuneToCriticals() {
        return this.criticalImmunity;
    }

    public float getModifierForDamageType(String damageTypeName) {
        return this.extraResistances.get(damageTypeName).floatValue();
    }
}

