/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.util;

import java.util.HashSet;
import java.util.Set;
import yeelp.distinctdamagedescriptions.util.ComparableTriple;
import yeelp.distinctdamagedescriptions.util.DamageType;

public final class DamageCategories {
    private ComparableTriple<Float, Float, Float> damage;

    public DamageCategories(float slashing, float piercing, float bludgeoning) {
        this.damage = new ComparableTriple<Float, Float, Float>(Float.valueOf(slashing), Float.valueOf(piercing), Float.valueOf(bludgeoning));
    }

    public DamageCategories(ComparableTriple<Float, Float, Float> triple) {
        this.damage = triple;
    }

    public float getSlashingDamage() {
        return this.damage.getLeft().floatValue();
    }

    public float getPiercingDamage() {
        return this.damage.getMiddle().floatValue();
    }

    public float getBludgeoningDamage() {
        return this.damage.getRight().floatValue();
    }

    public static Set<DamageType> getDamageTypes(DamageCategories ... damageCategories) {
        HashSet<DamageType> set = new HashSet<DamageType>();
        for (DamageCategories cat : damageCategories) {
            if (cat.getSlashingDamage() > 0.0f) {
                set.add(DamageType.SLASHING);
            }
            if (cat.getPiercingDamage() > 0.0f) {
                set.add(DamageType.PIERCING);
            }
            if (cat.getBludgeoningDamage() > 0.0f) {
                set.add(DamageType.BLUDGEONING);
            }
            if (set.size() != DamageType.values().length) continue;
            return set;
        }
        return set;
    }

    public String toString() {
        return String.format("(slashing: %f, piercing: %f, bludgeoning: %f)", Float.valueOf(this.getSlashingDamage()), Float.valueOf(this.getPiercingDamage()), Float.valueOf(this.getBludgeoningDamage()));
    }
}

