/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.util;

import java.util.concurrent.Callable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import yeelp.distinctdamagedescriptions.util.DamageCategories;
import yeelp.distinctdamagedescriptions.util.DamageDistributionProvider;
import yeelp.distinctdamagedescriptions.util.Distribution;
import yeelp.distinctdamagedescriptions.util.IDamageDistribution;

public class DamageDistribution
extends Distribution
implements IDamageDistribution {
    public static final IDamageDistribution PIERCING_DISTRIBUTION = new DamageDistribution(0.0f, 1.0f, 0.0f);
    public static final IDamageDistribution BLUDGEONING_DISTRIBUTION = new DamageDistribution(0.0f, 0.0f, 1.0f);
    public static final IDamageDistribution SLASHING_DISTRIBUTION = new DamageDistribution(1.0f, 0.0f, 0.0f);

    @Override
    protected boolean invariantViolated(float slash, float pierce, float bludge) {
        return slash + pierce + bludge > 1.0f && super.invariantViolated(slash, pierce, bludge);
    }

    public DamageDistribution() {
        this(0.0f, 0.0f, 1.0f);
    }

    public DamageDistribution(float slash, float pierce, float bludge) {
        super(slash, pierce, bludge);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == DamageDistributionProvider.damageDist;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == DamageDistributionProvider.damageDist ? DamageDistributionProvider.damageDist.cast((Object)this) : null);
    }

    @Override
    public DamageCategories distributeDamage(float dmg) {
        return new DamageCategories(super.distribute(dmg));
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IDamageDistribution.class, (Capability.IStorage)new DamageDistributionStorage(), (Callable)new DamageDistributionFactory());
    }

    private static class DamageDistributionStorage
    implements Capability.IStorage<IDamageDistribution> {
        private DamageDistributionStorage() {
        }

        public NBTBase writeNBT(Capability<IDamageDistribution> capability, IDamageDistribution instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<IDamageDistribution> capability, IDamageDistribution instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTBase)((NBTTagCompound)nbt));
        }
    }

    private static class DamageDistributionFactory
    implements Callable<IDamageDistribution> {
        private DamageDistributionFactory() {
        }

        @Override
        public IDamageDistribution call() throws Exception {
            return new DamageDistribution();
        }
    }
}

