/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.util;

import net.minecraft.nbt.NBTTagCompound;
import yeelp.distinctdamagedescriptions.util.IDamageResistances;
import yeelp.distinctdamagedescriptions.util.InvariantViolationException;

public abstract class DamageResistances
implements IDamageResistances {
    protected float slashing;
    protected float piercing;
    protected float bludgeoning;
    private boolean slashImmune;
    private boolean pierceImmune;
    private boolean bludgeImmune;

    DamageResistances(float slashing, float piercing, float bludgeoning, boolean slashImmune, boolean pierceImmune, boolean bludgeImmune) {
        this.slashing = slashing;
        this.piercing = piercing;
        this.bludgeoning = bludgeoning;
        this.slashImmune = slashImmune;
        this.pierceImmune = pierceImmune;
        this.bludgeImmune = bludgeImmune;
    }

    @Override
    public float getSlashingResistance() {
        return this.slashing;
    }

    @Override
    public float getPiercingResistance() {
        return this.piercing;
    }

    @Override
    public float getBludgeoningResistance() {
        return this.bludgeoning;
    }

    @Override
    public void setSlashingResistance(float resist) throws InvariantViolationException {
        if (resist > 1.0f) {
            throw new InvariantViolationException("Damage resistance can't be greater than 1!");
        }
        this.slashing = resist;
    }

    @Override
    public void setPiercingResistance(float resist) throws InvariantViolationException {
        if (resist > 1.0f) {
            throw new InvariantViolationException("Damage resistance can't be greater than 1!");
        }
        this.piercing = resist;
    }

    @Override
    public void setBludgeoningResistance(float resist) throws InvariantViolationException {
        if (resist > 1.0f) {
            throw new InvariantViolationException("Damage resistance can't be greater than 1!");
        }
        this.bludgeoning = resist;
    }

    @Override
    public void setSlashingImmunity(boolean immune) {
        this.slashImmune = immune;
    }

    @Override
    public void setPiercingImmunity(boolean immune) {
        this.pierceImmune = immune;
    }

    @Override
    public void setBludgeoningImmunity(boolean immune) {
        this.bludgeImmune = immune;
    }

    @Override
    public boolean isSlashingImmune() {
        return this.slashImmune;
    }

    @Override
    public boolean isPiercingImmune() {
        return this.pierceImmune;
    }

    @Override
    public boolean isBludgeoningImmune() {
        return this.bludgeImmune;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("slashingResist", this.slashing);
        tag.func_74776_a("piercingResist", this.piercing);
        tag.func_74776_a("bludgeoningResist", this.bludgeoning);
        tag.func_74757_a("slashingImmunity", this.slashImmune);
        tag.func_74757_a("piercingImmunity", this.pierceImmune);
        tag.func_74757_a("bludgeoningImmunity", this.bludgeImmune);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.slashing = tag.func_74760_g("slashingResist");
        this.piercing = tag.func_74760_g("piercingResist");
        this.bludgeoning = tag.func_74760_g("bludgeoningResist");
        this.slashImmune = tag.func_74767_n("slashingImmunity");
        this.pierceImmune = tag.func_74767_n("piercingImmunity");
        this.bludgeImmune = tag.func_74767_n("bludgeoningImmunity");
    }
}

