/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.util;

import net.minecraft.nbt.NBTTagCompound;
import yeelp.distinctdamagedescriptions.util.ComparableTriple;
import yeelp.distinctdamagedescriptions.util.IDistribution;
import yeelp.distinctdamagedescriptions.util.InvariantViolationException;

public abstract class Distribution
implements IDistribution {
    private float slash;
    private float pierce;
    private float bludge;

    protected boolean invariantViolated(float slash, float pierce, float bludge) {
        return Math.min(Math.min(slash, pierce), bludge) < 0.0f;
    }

    Distribution(float slash, float pierce, float bludge) {
        if (this.invariantViolated(slash, pierce, bludge)) {
            throw new InvariantViolationException("New weights are invalid!");
        }
        this.slash = slash;
        this.pierce = pierce;
        this.bludge = bludge;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("slashing", this.slash);
        tag.func_74776_a("piercing", this.pierce);
        tag.func_74776_a("bludgeoning", this.bludge);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.slash = nbt.func_74760_g("slashing");
        this.pierce = nbt.func_74760_g("piercing");
        this.bludge = nbt.func_74760_g("bludgeoning");
    }

    @Override
    public float getSlashingWeight() {
        return this.slash;
    }

    @Override
    public float getPiercingWeight() {
        return this.pierce;
    }

    @Override
    public float getBludgeoningWeight() {
        return this.bludge;
    }

    @Override
    public void setNewWeights(float slashing, float piercing, float bludgeoning) throws InvariantViolationException {
        if (this.invariantViolated(slashing, piercing, bludgeoning)) {
            throw new InvariantViolationException("New damage weights are either non positive or do not add to 1!");
        }
        this.slash = slashing;
        this.pierce = piercing;
        this.bludge = bludgeoning;
    }

    ComparableTriple<Float, Float, Float> distribute(float value) {
        return new ComparableTriple<Float, Float, Float>(Float.valueOf(value * this.slash), Float.valueOf(value * this.pierce), Float.valueOf(value * this.bludge));
    }
}

