/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class FileHelper {
    public static boolean copyFile(File src, File dest, boolean overwrite) throws IOException {
        try (FileInputStream input = new FileInputStream(src);){
            boolean bl = FileHelper.copyFile(input, dest, overwrite);
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean copyFile(InputStream stream, File dest, boolean overwrite) throws IOException {
        if (dest.exists()) {
            if (!overwrite) return false;
            dest.delete();
        } else {
            dest.createNewFile();
        }
        try (FileOutputStream output = new FileOutputStream(dest);){
            int readBytes;
            byte[] buf = new byte[4096];
            while ((readBytes = stream.read(buf)) > 0) {
                output.write(buf);
            }
            return true;
        }
    }
}

