/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.util;

import java.util.concurrent.Callable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import yeelp.distinctdamagedescriptions.util.DamageResistances;
import yeelp.distinctdamagedescriptions.util.DamageType;
import yeelp.distinctdamagedescriptions.util.IMobResistances;
import yeelp.distinctdamagedescriptions.util.MobResistancesProvider;

public class MobResistances
extends DamageResistances
implements IMobResistances {
    private boolean adaptive;
    private float adaptiveAmount;
    private boolean[] adaptiveTo;

    public MobResistances() {
        this(0.0f, 0.0f, 0.0f, false, false, false, false, 0.0f);
    }

    public MobResistances(float slashing, float piercing, float bludgeoning, boolean slashImmune, boolean pierceImmune, boolean bludgeImmune, boolean adaptitability, float adaptiveAmount) {
        super(slashing, piercing, bludgeoning, slashImmune, pierceImmune, bludgeImmune);
        this.adaptive = adaptitability;
        this.adaptiveAmount = adaptiveAmount;
        this.adaptiveTo = new boolean[DamageType.values().length];
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == MobResistancesProvider.mobResist;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == MobResistancesProvider.mobResist ? MobResistancesProvider.mobResist.cast((Object)this) : null);
    }

    @Override
    public boolean hasAdaptiveResistance() {
        return this.adaptive;
    }

    @Override
    public void setAdaptiveResistance(boolean status) {
        this.adaptive = status;
    }

    @Override
    public float getAdaptiveAmount() {
        return this.adaptiveAmount;
    }

    @Override
    public boolean updateAdaptiveResistance(DamageType ... damageTypes) {
        int i;
        float[] netChange = new float[3];
        for (DamageType damageType : DamageType.values()) {
            i = damageType.ordinal();
            if (!this.adaptiveTo[i]) continue;
            this.adaptiveTo[i] = false;
            int n = i;
            netChange[n] = netChange[n] - this.adaptiveAmount;
        }
        for (DamageType damageType : damageTypes) {
            i = damageType.ordinal();
            this.adaptiveTo[i] = true;
            int n = i;
            netChange[n] = netChange[n] + this.adaptiveAmount;
        }
        this.slashing += netChange[0];
        this.piercing += netChange[1];
        this.bludgeoning += netChange[2];
        return netChange[0] != 0.0f || netChange[1] != 0.0f || netChange[2] != 0.0f;
    }

    private void setImmunity(DamageType damageType, boolean status) {
        switch (damageType) {
            case SLASHING: {
                super.setSlashingImmunity(status);
                break;
            }
            case PIERCING: {
                super.setPiercingImmunity(status);
                break;
            }
            case BLUDGEONING: {
                super.setBludgeoningImmunity(status);
                break;
            }
        }
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        tag.func_74757_a("adaptive", this.adaptive);
        tag.func_74776_a("adaptiveAmount", this.adaptiveAmount);
        byte[] bytes = new byte[this.adaptiveTo.length];
        for (int i = 0; i < this.adaptiveTo.length; ++i) {
            bytes[i] = MobResistances.booleanAsByte(this.adaptiveTo[i]);
        }
        tag.func_74773_a("adaptabilityStatus", bytes);
        return tag;
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        this.adaptive = tag.func_74767_n("adaptive");
        this.adaptiveAmount = tag.func_74760_g("adaptiveAmount");
        int i = 0;
        for (byte b : tag.func_74770_j("adaptabilityStatus")) {
            this.adaptiveTo[i++] = MobResistances.byteAsBoolean(b);
        }
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IMobResistances.class, (Capability.IStorage)new MobResistancesStorage(), (Callable)new MobResistancesFactory());
    }

    private static byte booleanAsByte(boolean b) {
        return (byte)(b ? 1 : 0);
    }

    private static boolean byteAsBoolean(byte b) {
        return b != 0;
    }

    private static class MobResistancesStorage
    implements Capability.IStorage<IMobResistances> {
        private MobResistancesStorage() {
        }

        public NBTBase writeNBT(Capability<IMobResistances> capability, IMobResistances instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<IMobResistances> capability, IMobResistances instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTBase)((NBTTagCompound)nbt));
        }
    }

    private static class MobResistancesFactory
    implements Callable<IMobResistances> {
        private MobResistancesFactory() {
        }

        @Override
        public IMobResistances call() throws Exception {
            return new MobResistances();
        }
    }
}

