/*
 * Decompiled with CFR 0.152.
 */
package yeelp.distinctdamagedescriptions.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.NonNullList;

public class NonNullMap<Key, Value>
extends AbstractMap<Key, Value>
implements Map<Key, Value> {
    private Value defaultVal;
    private List<Key> keys;
    private List<Value> vals;

    private NonNullMap() {
        throw new UnsupportedOperationException("A default value must be specifed for the NonNullMap");
    }

    public NonNullMap(Value defaultVal) {
        this.defaultVal = defaultVal;
        this.keys = new ArrayList<Key>();
        this.vals = NonNullList.func_191196_a();
    }

    @SafeVarargs
    public NonNullMap(Value defaultVal, Key ... keys) {
        this(defaultVal);
        this.keys = Arrays.asList(keys);
        for (int i = 0; i < keys.length; ++i) {
            this.vals.add(defaultVal);
        }
    }

    public Value getDefaultValue() {
        return this.defaultVal;
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keys.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        for (Key k : this.keys) {
            if (!k.equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Value v : this.vals) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Value get(Object key) {
        int index = this.keys.indexOf(key);
        return index == -1 ? this.defaultVal : this.vals.get(index);
    }

    @Override
    public Value put(Key key, Value value) {
        if (value == null) {
            throw new NullPointerException("Null values disallowed for NonNullMap");
        }
        if (key == null) {
            throw new NullPointerException("Null keys disallowed for NonNullMap");
        }
        int index = this.keys.indexOf(key);
        if (index == -1) {
            this.keys.add(key);
            this.vals.add(value);
            return null;
        }
        Value val = this.vals.remove(index);
        this.vals.add(index, value);
        return val;
    }

    @Override
    @Nullable
    public Value remove(Object key) {
        int index = this.keys.indexOf(key);
        if (index == -1) {
            return null;
        }
        Value val = this.vals.remove(index);
        this.keys.remove(index);
        return val;
    }

    @Nullable
    public Value setDefault(Object key) {
        int index = this.keys.indexOf(key);
        if (index == -1) {
            return null;
        }
        Value val = this.vals.remove(index);
        this.vals.add(index, this.defaultVal);
        return val;
    }

    @Override
    public void putAll(Map<? extends Key, ? extends Value> m) {
        for (Map.Entry<Key, Value> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.keys = new ArrayList<Key>();
        this.vals = NonNullList.func_191196_a();
    }

    @Override
    public Set<Key> keySet() {
        return super.keySet();
    }

    @Override
    public Collection<Value> values() {
        return super.values();
    }

    @Override
    public Set<Map.Entry<Key, Value>> entrySet() {
        HashSet<Map.Entry<Key, Value>> es = new HashSet<Map.Entry<Key, Value>>();
        for (Key k : this.keys) {
            es.add(new AbstractMap.SimpleEntry<Key, Value>(k, this.get(k)));
        }
        return es;
    }
}

