/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.boss;

import com.dainxt.dungeonsmod.init.EntityInit;
import com.dainxt.dungeonsmod.util.handlers.ConfigHandler;
import com.dainxt.dungeonsmod.util.handlers.LootTableHandler;
import com.dainxt.dungeonsmod.world.gen.WorldGenCustomStructures;
import com.dainxt.dungeonsmod.world.storage.WorldCustomData;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;

public class EntityKraken
extends EntityMob
implements IEntityMultiPart {
    private static final DataParameter<Integer> BINDED_PLAYER = EntityDataManager.func_187226_a(EntityKraken.class, (DataSerializer)DataSerializers.field_187192_b);
    public float krakenPitch;
    public float krakenYaw;
    public MultiPartEntityPart[] krakenPartArray;
    public MultiPartEntityPart krakenPartHead = new MultiPartEntityPart((IEntityMultiPart)this, "head", 6.0f, 6.0f);
    public MultiPartEntityPart krakenPartNeck = new MultiPartEntityPart((IEntityMultiPart)this, "neck", 6.0f, 6.0f);
    public MultiPartEntityPart krakenPartTentacle1 = new MultiPartEntityPart((IEntityMultiPart)this, "tentacle1", 6.0f, 6.0f);
    public MultiPartEntityPart krakenPartTentacle2 = new MultiPartEntityPart((IEntityMultiPart)this, "tentacle2", 6.0f, 6.0f);
    public MultiPartEntityPart krakenPartTentacle3 = new MultiPartEntityPart((IEntityMultiPart)this, "tentacle3", 6.0f, 6.0f);
    public MultiPartEntityPart krakenPartTentacle4 = new MultiPartEntityPart((IEntityMultiPart)this, "tentacle4", 6.0f, 6.0f);
    public MultiPartEntityPart krakenPartTentacle5 = new MultiPartEntityPart((IEntityMultiPart)this, "tentacle5", 6.0f, 6.0f);
    public MultiPartEntityPart krakenPartTentacle6 = new MultiPartEntityPart((IEntityMultiPart)this, "tentacle6", 6.0f, 6.0f);
    public MultiPartEntityPart krakenPartTentacle7 = new MultiPartEntityPart((IEntityMultiPart)this, "tentacle7", 6.0f, 6.0f);
    public MultiPartEntityPart krakenPartTentacle8 = new MultiPartEntityPart((IEntityMultiPart)this, "tentacle8", 6.0f, 6.0f);
    boolean moving = false;
    protected EntityAIWander wander;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS).func_186741_a(true);

    public EntityKraken(World worldIn) {
        super(worldIn);
        this.func_70105_a(12.0f, 10.0f);
        this.field_70728_aV = 2500;
        this.field_70765_h = new KrakenMoveHelper(this);
        this.func_110163_bv();
        this.krakenPartArray = new MultiPartEntityPart[]{this.krakenPartHead, this.krakenPartNeck, this.krakenPartTentacle1, this.krakenPartTentacle2, this.krakenPartTentacle3, this.krakenPartTentacle4, this.krakenPartTentacle5, this.krakenPartTentacle6, this.krakenPartTentacle7, this.krakenPartTentacle8};
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BINDED_PLAYER, (Object)-1);
    }

    public void setPlayerBinded(int bindedPlayer) {
        this.func_184212_Q().func_187227_b(BINDED_PLAYER, (Object)bindedPlayer);
    }

    public int getPlayerBinded() {
        return (Integer)this.func_184212_Q().func_187225_a(BINDED_PLAYER);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableHandler.KRAKEN;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76357_e()) {
            return super.func_70097_a(source, amount);
        }
        return source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        EntityAIMoveTowardsRestriction entityaimovetowardsrestriction = new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0);
        this.wander = new EntityAIWander((EntityCreature)this, 0.5, 80);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIKrakenAttack(this, 0.5, false));
        this.wander.func_75248_a(4);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)entityaimovetowardsrestriction);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.wander);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 20.0f, 1.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, false, (Predicate)new KrakenTargetSelector(this)));
    }

    protected void func_82167_n(Entity entityIn) {
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag && entityIn instanceof EntityPlayer && this.func_70681_au().nextInt(3) == 0 && this.func_70638_az() != null) {
            this.setPlayerBinded(this.func_70638_az().func_145782_y());
        }
        return flag;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_191958_b(strafe, vertical, forward, 0.1f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.9f;
            this.field_70181_x *= (double)0.9f;
            this.field_70179_y *= (double)0.9f;
            if (!this.isMoving() && this.func_70638_az() == null) {
                this.field_70181_x -= 0.005;
            }
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    private void setMoving(boolean Moving) {
        this.moving = Moving;
    }

    private boolean isMoving() {
        return this.moving;
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return super.func_70114_g(entityIn);
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
        if (this.bossInfo.func_186757_c().isEmpty()) {
            this.func_70606_j((float)this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
        }
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        WorldCustomData data = WorldCustomData.get(this.field_70170_p);
        data.dungeonData.resetData(WorldGenCustomStructures.THE_SHIP);
    }

    protected boolean func_70814_o() {
        return true;
    }

    public boolean func_70601_bi() {
        return EntityInit.rareSpawn(this.func_70681_au(), ConfigHandler.spawnRates.Kraken, super.func_70601_bi());
    }

    public void fixRotationPitch() {
        if (this.field_70125_A == 0.0f) {
            this.field_70125_A = this.krakenPitch;
        }
        this.krakenPitch = this.field_70125_A;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    public Vec3d func_174824_e(float partialTicks) {
        return super.func_174824_e(partialTicks);
    }

    public Vec3d func_70676_i(float partialTicks) {
        return super.func_70676_i(partialTicks);
    }

    public Vec3d getPositionFromVector(Vec3d origin, float yawOffset, float pitchOffset, double distanceOrigin) {
        float yaw = this.field_70761_aq + yawOffset;
        float pitch = this.field_70125_A + pitchOffset;
        float yawSin = MathHelper.func_76126_a((float)((float)((double)yaw * (Math.PI / 180))));
        float yawCos = MathHelper.func_76134_b((float)((float)((double)yaw * (Math.PI / 180))));
        float pitchSin = MathHelper.func_76126_a((float)((float)((double)pitch * (Math.PI / 180))));
        float pitchCos = MathHelper.func_76134_b((float)((float)((double)pitch * (Math.PI / 180))));
        double tentaclePosX = origin.field_72450_a - (double)yawSin * (distanceOrigin * (double)MathHelper.func_76135_e((float)pitchCos));
        double tentaclePosZ = origin.field_72449_c + (double)yawCos * (distanceOrigin * (double)MathHelper.func_76135_e((float)pitchCos));
        double tentaclePosY = origin.field_72448_b - (double)pitchSin * distanceOrigin;
        return new Vec3d(tentaclePosX, tentaclePosY, tentaclePosZ);
    }

    public void setPartBoundingPosition(MultiPartEntityPart tentacle, float yawOffset, float pitchOffset, double distanceOrigin) {
        Vec3d origin = this.func_174791_d();
        origin = origin.func_72441_c(0.0, (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) / 2.0, 0.0);
        this.setPartBoundingPosition(tentacle, origin, yawOffset, pitchOffset, distanceOrigin);
    }

    public void setPartBoundingPosition(MultiPartEntityPart tentacle, Vec3d origin, float yawOffset, float pitchOffset, double distanceOrigin) {
        if (tentacle != null) {
            Vec3d finalPos = this.getPositionFromVector(origin, yawOffset, pitchOffset, distanceOrigin);
            Vec3d finalTentaclePos = new Vec3d(finalPos.field_72450_a, finalPos.field_72448_b - (double)(tentacle.field_70131_O / 2.0f), finalPos.field_72449_c);
            tentacle.func_70071_h_();
            tentacle.func_70080_a(finalTentaclePos.field_72450_a, finalTentaclePos.field_72448_b, finalTentaclePos.field_72449_c, 0.0f, 0.0f);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70171_ac) {
            this.func_70050_g(300);
        }
        this.krakenPartHead.field_70130_N = 1.0f;
        this.krakenPartHead.field_70131_O = 1.0f;
        this.krakenPartNeck.field_70130_N = 7.0f;
        this.krakenPartNeck.field_70131_O = 7.0f;
        this.krakenPartTentacle1.field_70130_N = 1.0f;
        this.krakenPartTentacle1.field_70131_O = 1.0f;
        this.krakenPartTentacle2.field_70130_N = 1.0f;
        this.krakenPartTentacle2.field_70131_O = 1.0f;
        this.krakenPartTentacle3.field_70130_N = 1.0f;
        this.krakenPartTentacle3.field_70131_O = 1.0f;
        this.krakenPartTentacle4.field_70130_N = 1.0f;
        this.krakenPartTentacle4.field_70131_O = 1.0f;
        this.krakenPartTentacle5.field_70130_N = 1.0f;
        this.krakenPartTentacle5.field_70131_O = 1.0f;
        this.krakenPartTentacle6.field_70130_N = 1.0f;
        this.krakenPartTentacle6.field_70131_O = 1.0f;
        this.krakenPartTentacle7.field_70130_N = 1.0f;
        this.krakenPartTentacle7.field_70131_O = 1.0f;
        this.krakenPartTentacle8.field_70130_N = 1.0f;
        this.krakenPartTentacle8.field_70131_O = 1.0f;
        this.fixRotationPitch();
        this.setPartBoundingPosition(this.krakenPartHead, 0.0f, 0.0f, 0.0);
        this.setPartBoundingPosition(this.krakenPartNeck, 0.0f, 0.0f, -10.5);
        this.setPartBoundingPosition(this.krakenPartTentacle1, 20.0f, 0.0f, 4.5);
        this.setPartBoundingPosition(this.krakenPartTentacle2, -20.0f, 0.0f, 4.5);
        this.setPartBoundingPosition(this.krakenPartTentacle3, 0.0f, 20.0f, 4.5);
        this.setPartBoundingPosition(this.krakenPartTentacle4, 0.0f, -25.0f, 4.5);
        this.setPartBoundingPosition(this.krakenPartTentacle5, 20.0f, -20.0f, 4.5);
        this.setPartBoundingPosition(this.krakenPartTentacle6, -20.0f, -20.0f, 4.5);
        this.setPartBoundingPosition(this.krakenPartTentacle7, 20.0f, 20.0f, 4.5);
        this.setPartBoundingPosition(this.krakenPartTentacle8, -20.0f, 20.0f, 4.5);
        if (this.getPlayerBinded() >= 0) {
            EntityPlayer player = (EntityPlayer)this.field_70170_p.func_73045_a(this.getPlayerBinded());
            if (player != null) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100));
                player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 100));
                player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100));
                player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100));
                Vec3d tentaclePos = this.krakenPartHead.func_174791_d();
                player.func_70080_a(tentaclePos.field_72450_a, tentaclePos.field_72448_b, tentaclePos.field_72449_c, player.field_70177_z, player.field_70125_A);
            } else {
                this.setPlayerBinded(-1);
            }
        }
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateSwimmer((EntityLiving)this, worldIn);
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public boolean func_70965_a(MultiPartEntityPart krakenPart, DamageSource source, float damage) {
        if (krakenPart.field_146032_b.contains("tentacle")) {
            damage *= 2.0f;
            this.setPlayerBinded(-1);
        }
        return super.func_70097_a(source, damage);
    }

    public Entity[] func_70021_al() {
        return this.krakenPartArray;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187829_fQ;
    }

    public static class KrakenTargetSelector
    implements Predicate<EntityLivingBase> {
        private final EntityKraken parentEntity;

        public KrakenTargetSelector(EntityKraken guardian) {
            this.parentEntity = guardian;
        }

        public boolean apply(@Nullable EntityLivingBase p_apply_1_) {
            return p_apply_1_ instanceof EntityPlayer && p_apply_1_.func_70068_e((Entity)this.parentEntity) > 4.0;
        }
    }

    static class AIKrakenAttack
    extends EntityAIAttackMelee {
        EntityKraken Kraken;

        public AIKrakenAttack(EntityKraken creature, double speedIn, boolean useLongMemory) {
            super((EntityCreature)creature, speedIn, useLongMemory);
            this.Kraken = creature;
        }

        public void func_75251_c() {
            this.Kraken.wander.func_179480_f();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return this.field_75441_b.field_70130_N * this.field_75441_b.field_70130_N;
        }

        public void func_75246_d() {
            super.func_75246_d();
        }
    }

    static class KrakenMoveHelper
    extends EntityMoveHelper {
        private final EntityKraken entityKraken;

        public KrakenMoveHelper(EntityKraken Kraken) {
            super((EntityLiving)Kraken);
            this.entityKraken = Kraken;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.entityKraken.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.entityKraken.field_70165_t;
                double d1 = this.field_75647_c - this.entityKraken.field_70163_u;
                double d2 = this.field_75644_d - this.entityKraken.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                d1 /= d3;
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                this.entityKraken.field_70761_aq = this.entityKraken.field_70177_z = this.func_75639_a(this.entityKraken.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.entityKraken.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.entityKraken.func_70659_e(this.entityKraken.func_70689_ay() + (f1 - this.entityKraken.func_70689_ay()) * 0.125f);
                double d4 = Math.sin((double)(this.entityKraken.field_70173_aa + this.entityKraken.func_145782_y()) * 0.5) * 0.05;
                double d5 = Math.cos(this.entityKraken.field_70177_z * ((float)Math.PI / 180));
                double d6 = Math.sin(this.entityKraken.field_70177_z * ((float)Math.PI / 180));
                this.entityKraken.field_70159_w += d4 * d5;
                this.entityKraken.field_70179_y += d4 * d6;
                d4 = Math.sin((double)(this.entityKraken.field_70173_aa + this.entityKraken.func_145782_y()) * 0.75) * 0.05;
                this.entityKraken.field_70181_x += d4 * (d6 + d5) * 0.25;
                this.entityKraken.field_70181_x += (double)this.entityKraken.func_70689_ay() * d1 * 0.1;
                EntityLookHelper entitylookhelper = this.entityKraken.func_70671_ap();
                double d7 = this.entityKraken.field_70165_t + d0 / d3 * 2.0;
                double d8 = (double)this.entityKraken.func_70047_e() + this.entityKraken.field_70163_u + d1 / d3;
                double d9 = this.entityKraken.field_70161_v + d2 / d3 * 2.0;
                double d10 = entitylookhelper.func_180423_e();
                double d11 = entitylookhelper.func_180422_f();
                double d12 = entitylookhelper.func_180421_g();
                if (!entitylookhelper.func_180424_b()) {
                    d10 = d7;
                    d11 = d8;
                    d12 = d9;
                }
                this.entityKraken.func_70671_ap().func_75650_a(d10 + (d7 - d10) * 0.125, d11 + (d8 - d11) * 0.125, d12 + (d9 - d12) * 0.125, 10.0f, 40.0f);
                this.entityKraken.setMoving(true);
            } else {
                this.entityKraken.func_70659_e(0.0f);
                this.entityKraken.setMoving(false);
            }
        }
    }
}

