/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.boss;

import com.dainxt.dungeonsmod.util.handlers.LootTableHandler;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntitySun
extends EntityFlying
implements IMob {
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PINK, BossInfo.Overlay.PROGRESS).func_186741_a(true);

    public EntitySun(World worldIn) {
        super(worldIn);
        this.func_110163_bv();
        this.func_70105_a(25.0f, 25.0f);
        this.field_70178_ae = true;
        this.field_70728_aV = 20000;
        this.field_70765_h = new SunMoveHelper(this);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableHandler.SUN;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        super.func_70665_d(source, amount);
        if (source.equals(DamageSource.field_76368_d)) {
            return false;
        }
        if (source.func_76364_f() instanceof EntityArrow) {
            ((EntityArrow)source.func_76364_f()).func_70240_a(0);
        }
        if (source.func_76364_f() instanceof EntitySpectralArrow) {
            AxisAlignedBB box = this.func_174813_aQ().func_186662_g(50.0);
            List entities = this.field_70170_p.func_72872_a(EntityArmorStand.class, box);
            boolean isNear = false;
            for (Entity entity : entities) {
                if (!(entity instanceof EntityArmorStand)) continue;
                int count = 0;
                for (ItemStack itemstack : entity.func_184193_aE()) {
                    if (!(itemstack.func_77973_b() instanceof ItemArmor) || !((ItemArmor)itemstack.func_77973_b()).func_82812_d().equals((Object)ItemArmor.ArmorMaterial.IRON)) continue;
                    ++count;
                }
                if (count < 4) continue;
                AxisAlignedBB box1 = new AxisAlignedBB(entity.func_180425_c().func_177977_b()).func_72314_b(1.5, 0.0, 1.5);
                isNear = this.scanForIce(box1);
                this.field_70170_p.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
                entity.func_70106_y();
                break;
            }
            if (isNear) {
                List living = this.field_70170_p.func_72872_a(EntityLivingBase.class, box);
                for (EntityLivingBase entity : living) {
                    if (entity instanceof EntitySun) continue;
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), entity.func_110138_aP() / 6.0f);
                }
                return super.func_70097_a(source, this.func_110138_aP() / 6.0f);
            }
        }
        return super.func_70097_a(source, amount);
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        float f = 0.91f;
        if (this.field_70122_E) {
            BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
            IBlockState underState = this.field_70170_p.func_180495_p(underPos);
            f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
        }
        float f1 = 0.16277136f / (f * f * f);
        this.func_191958_b(strafe, vertical, forward, this.field_70122_E ? 0.1f * f1 : 0.02f);
        f = 0.91f;
        if (this.field_70122_E) {
            BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
            IBlockState underState = this.field_70170_p.func_180495_p(underPos);
            f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)f;
        this.field_70181_x *= (double)f;
        this.field_70179_y *= (double)f;
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AILookAround(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        if (entityIn instanceof EntityLivingBase) {
            entityIn.func_70015_d(6000);
        }
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        super.func_70100_b_(entityIn);
        if (entityIn instanceof EntityLivingBase) {
            entityIn.func_70015_d(6000);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1000.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(200.0);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187643_bs;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected float func_70599_aP() {
        return 10.0f;
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(20) == 0 && super.func_70601_bi() && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public int func_70641_bl() {
        return 1;
    }

    public static void registerFixesSun(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntitySun.class);
    }

    public float func_70047_e() {
        return 15.0f;
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB p_70972_1_) {
        int i = MathHelper.func_76128_c((double)p_70972_1_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_70972_1_.field_72338_b);
        int k = MathHelper.func_76128_c((double)p_70972_1_.field_72339_c);
        int l = MathHelper.func_76128_c((double)p_70972_1_.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)p_70972_1_.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)p_70972_1_.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                    Block block = iblockstate.func_177230_c();
                    if (block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos)) continue;
                    if (!ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                        flag = true;
                        continue;
                    }
                    if (block.canEntityDestroy(iblockstate, (IBlockAccess)this.field_70170_p, blockpos, (Entity)this) && ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)blockpos, (IBlockState)iblockstate)) {
                        if (block.equals(Blocks.field_150357_h) || block.equals(Blocks.field_150356_k)) continue;
                        if (this.field_70146_Z.nextInt(200) == 0) {
                            flag1 = this.field_70170_p.func_175656_a(blockpos, Blocks.field_150356_k.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(13))) || flag1;
                        } else {
                            boolean bl = flag1 = this.field_70170_p.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P()) || flag1;
                        }
                        if (this.field_70146_Z.nextInt(20) != 0) continue;
                        this.field_70170_p.func_184134_a((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), SoundEvents.field_187659_cY, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
                        continue;
                    }
                    flag = true;
                }
            }
        }
        return flag;
    }

    public boolean scanForIce(AxisAlignedBB p_70972_1_) {
        int i = MathHelper.func_76128_c((double)p_70972_1_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_70972_1_.field_72338_b);
        int k = MathHelper.func_76128_c((double)p_70972_1_.field_72339_c);
        int l = MathHelper.func_76128_c((double)p_70972_1_.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)p_70972_1_.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)p_70972_1_.field_72334_f);
        int iceCount = 0;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                    Block block = iblockstate.func_177230_c();
                    if (block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos) || !ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) || !block.canEntityDestroy(iblockstate, (IBlockAccess)this.field_70170_p, blockpos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)blockpos, (IBlockState)iblockstate) || block.equals(Blocks.field_150357_h)) continue;
                    if (block.equals(Blocks.field_150403_cj)) {
                        ++iceCount;
                    }
                    this.field_70170_p.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        return iceCount >= 25;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
        if (this.bossInfo.func_186757_c().isEmpty()) {
            this.func_70606_j((float)this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
        }
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        float distance = Float.MAX_VALUE;
        if (this.field_70173_aa % MathHelper.func_76123_f((float)(this.func_110143_aJ() * 0.2f)) == 0) {
            this.destroyBlocksInAABB(this.func_174813_aQ().func_72314_b(3.0, 0.0, 3.0));
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    static class SunMoveHelper
    extends EntityMoveHelper {
        private final EntitySun parentEntity;
        private int courseChangeCooldown;

        public SunMoveHelper(EntitySun Sun) {
            super((EntityLiving)Sun);
            this.parentEntity = Sun;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                double d1 = this.field_75647_c - this.parentEntity.field_70163_u;
                double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                    d3 = MathHelper.func_76133_a((double)d3);
                    this.parentEntity.field_70159_w += d0 / d3 * 0.1;
                    this.parentEntity.field_70181_x += d1 / d3 * 0.1;
                    this.parentEntity.field_70179_y += d2 / d3 * 0.1;
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - this.parentEntity.field_70165_t) / p_179926_7_;
            double d1 = (y - this.parentEntity.field_70163_u) / p_179926_7_;
            double d2 = (z - this.parentEntity.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class AIRandomFly
    extends EntityAIBase {
        private final EntitySun parentEntity;

        public AIRandomFly(EntitySun Sun) {
            this.parentEntity = Sun;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 2.0f);
            double d2 = this.parentEntity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 0.3);
        }
    }

    static class AILookAround
    extends EntityAIBase {
        private final EntitySun parentEntity;

        public AILookAround(EntitySun Sun) {
            this.parentEntity = Sun;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)this.parentEntity.field_70159_w, (double)this.parentEntity.field_70179_y)) * 57.295776f;
            } else {
                EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
                double d0 = 64.0;
                double distanceSquared = entitylivingbase.func_70068_e((Entity)this.parentEntity);
                if (distanceSquared < 4096.0) {
                    if (entitylivingbase.field_70170_p.field_73012_v.nextInt((int)MathHelper.func_151237_a((double)distanceSquared, (double)0.0, (double)4096.0)) <= 16) {
                        entitylivingbase.func_70015_d(1);
                    }
                    double d1 = entitylivingbase.field_70165_t - this.parentEntity.field_70165_t;
                    double d2 = entitylivingbase.field_70161_v - this.parentEntity.field_70161_v;
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }

    static class AIAttack
    extends EntityAIBase {
        private final EntitySun parentEntity;
        public int attackTimer;

        public AIAttack(EntitySun Sun) {
            this.parentEntity = Sun;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            double d0 = 64.0;
            if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4096.0 && this.parentEntity.func_70685_l((Entity)entitylivingbase)) {
                World world = this.parentEntity.field_70170_p;
                double d2 = entitylivingbase.field_70165_t;
                double d3 = entitylivingbase.field_70163_u;
                double d4 = entitylivingbase.field_70161_v;
                this.parentEntity.func_70605_aq().func_75642_a(d2, d3, d4, 0.5);
            }
        }
    }
}

