/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.items;

import com.dainxt.dungeonsmod.items.ItemBase;
import com.dainxt.dungeonsmod.util.Location;
import com.dainxt.dungeonsmod.util.TeleportHelper;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHomeGem
extends ItemBase {
    int MAX_COOLDOWN = 18000;

    public ItemHomeGem(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78026_f);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K) {
            int cooldown;
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            if ((cooldown = tag.func_74762_e("cooldown")) > 0) {
                tag.func_74768_a("cooldown", --cooldown);
            }
            stack.func_77982_d(tag);
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityIn, int timeLeft) {
        super.func_77615_a(stack, worldIn, entityIn, timeLeft);
        if (entityIn.func_184607_cu() == stack) {
            EntityPlayer entityplayer = (EntityPlayer)entityIn;
            entityplayer.func_184811_cZ().func_185145_a(stack.func_77973_b(), 0);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        NBTTagCompound tag;
        EntityPlayer entityplayer;
        EntityPlayer entityPlayer = entityplayer = entityLiving instanceof EntityPlayer ? (EntityPlayer)entityLiving : null;
        if (!worldIn.field_72995_K && (tag = stack.func_77978_p()) != null) {
            BlockPos pos = BlockPos.func_177969_a((long)tag.func_74763_f("HomePos"));
            int dimension = tag.func_74762_e("Dimension");
            tag.func_74768_a("cooldown", this.MAX_COOLDOWN);
            stack.func_77982_d(tag);
            Location location = new Location(pos, dimension);
            TeleportHelper.warp((EntityPlayerMP)entityplayer, location);
        }
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            return tag.func_74762_e("cooldown") > 0;
        }
        return super.showDurabilityBar(stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            return tag.func_74767_n("isLinked");
        }
        return super.func_77636_d(stack);
    }

    public int func_77626_a(ItemStack stack) {
        return 100;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            return (double)tag.func_74762_e("cooldown") / (double)this.MAX_COOLDOWN;
        }
        return super.getDurabilityForDisplay(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack;
        NBTTagCompound tag;
        if (!worldIn.field_72995_K && (tag = (stack = playerIn.func_184586_b(handIn)).func_77978_p()) != null) {
            WorldServer worldServer = playerIn.func_130014_f_().func_73046_m().func_71218_a(playerIn.getSpawnDimension());
            if (EntityPlayer.func_180467_a((World)worldServer, (BlockPos)playerIn.getBedLocation(playerIn.getSpawnDimension()), (boolean)false) == null) {
                tag.func_74757_a("isLinked", false);
                return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184586_b(handIn));
            }
            tag.func_74757_a("isLinked", true);
            tag.func_74768_a("Dimension", playerIn.getSpawnDimension());
            tag.func_74772_a("HomePos", playerIn.getBedLocation(playerIn.getSpawnDimension()).func_177986_g());
            if ((float)tag.func_74762_e("cooldown") == 0.0f) {
                playerIn.func_184598_c(handIn);
                playerIn.func_184811_cZ().func_185145_a(playerIn.func_184614_ca().func_77973_b(), 100);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
            }
            stack.func_77982_d(tag);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<String> list, ITooltipFlag advanced) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(3);
            int cooldown = tagCompound.func_74762_e("cooldown");
            float minutesExact = cooldown / 1200;
            int minutes = (int)minutesExact;
            float secondsExact = cooldown / 20;
            int seconds = (int)(secondsExact - (float)(minutes * 60));
            if (tagCompound.func_74767_n("isLinked")) {
                list.add("Linked");
            }
            list.add("Cooldown: " + minutes + " minutes " + seconds + " seconds");
        }
    }
}

