/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.world.gen;

import com.dainxt.dungeonsmod.world.gen.generators.Dungeon1;
import com.dainxt.dungeonsmod.world.gen.generators.Dungeon2;
import com.dainxt.dungeonsmod.world.gen.generators.Dungeon3;
import com.dainxt.dungeonsmod.world.gen.generators.Dungeon4;
import com.dainxt.dungeonsmod.world.gen.generators.Dungeon5;
import com.dainxt.dungeonsmod.world.gen.generators.WorldGenStructure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenCustomStructures
implements IWorldGenerator {
    public static final Dungeon1 THE_HOUSE = new Dungeon1();
    public static final Dungeon2 THE_IRON_MINES = new Dungeon2();
    public static final Dungeon3 THE_SHIP = new Dungeon3();
    public static final Dungeon4 THE_CASTLE = new Dungeon4();
    public static final Dungeon5 THE_LAB = new Dungeon5();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                this.generateStructure(THE_LAB, world, random, chunkX, chunkZ, new Biome[0]);
                this.generateStructure(THE_SHIP, world, random, chunkX, chunkZ, new Biome[0]);
                this.generateStructure(THE_HOUSE, world, random, chunkX, chunkZ, new Biome[0]);
                this.generateStructure(THE_IRON_MINES, world, random, chunkX, chunkZ, new Biome[0]);
                this.generateStructure(THE_CASTLE, world, random, chunkX, chunkZ, new Biome[0]);
            }
        }
    }

    private void generateStructure(WorldGenStructure generator, World world, Random random, int chunkX, int chunkZ, Biome ... biomes) {
        generator.generateStructure(world, random, chunkX, chunkZ);
    }

    public static int calculateGenerationHeight(World world, int x, int z, Block ... ignoreArray) {
        int y = world.func_72800_K();
        boolean foundGround = false;
        ArrayList<Block> ignoreList = new ArrayList<Block>();
        ignoreList.add(Blocks.field_150350_a);
        ignoreList.addAll(Arrays.asList(ignoreArray));
        while (!foundGround && y-- >= 0) {
            Block ignoreBlock;
            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            Iterator iterator = ignoreList.iterator();
            while (iterator.hasNext() && (foundGround = block != (ignoreBlock = (Block)iterator.next()))) {
            }
        }
        return y;
    }
}

