/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.common;

import com.fantasticsource.dynamicstealth.server.senses.sight.EntitySightData;
import com.fantasticsource.tools.Tools;
import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class DSTools {
    public static Vec3d[] entityCheckVectors(Entity target) {
        double halfWidth = (double)target.field_70130_N * 0.499;
        double halfHeight = (double)target.field_70131_O * 0.499;
        double x = target.field_70165_t;
        double y = target.field_70163_u + (double)(target.field_70131_O / 2.0f);
        double z = target.field_70161_v;
        return new Vec3d[]{new Vec3d(x, y, z), new Vec3d(x, y + halfHeight, z), new Vec3d(x, y - halfHeight, z), new Vec3d(x + halfWidth, y, z), new Vec3d(x - halfWidth, y, z), new Vec3d(x, y, z + halfWidth), new Vec3d(x, y, z - halfWidth)};
    }

    public static HashSet<BlockPos> entityCheckBlocks(Entity target) {
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        for (Vec3d vec : DSTools.entityCheckVectors(target)) {
            result.add(new BlockPos(vec));
        }
        return result;
    }

    public static int lightLevelTotal(World world, Vec3d vec) {
        return DSTools.lightLevelTotal(world, new BlockPos(vec));
    }

    public static int lightLevelTotal(World world, BlockPos pos) {
        if (world.field_72995_K) {
            throw new IllegalStateException("Light levels should only be accessed from server-side!");
        }
        if (!world.func_175697_a(pos, 1)) {
            return 0;
        }
        return Tools.max((int[])new int[]{world.func_175671_l(pos), EntitySightData.minimumDimensionLight(world.field_73011_w.getDimension())});
    }

    public static int maxLightLevelTotal(Entity target) {
        int result = 0;
        for (BlockPos pos : DSTools.entityCheckBlocks(target)) {
            result = Tools.max((int[])new int[]{result, DSTools.lightLevelTotal(target.field_70170_p, pos)});
        }
        return result;
    }
}

