/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.common;

import com.fantasticsource.dynamicstealth.common.ClientData;
import com.fantasticsource.dynamicstealth.common.DSTools;
import com.fantasticsource.dynamicstealth.config.DynamicStealthConfig;
import com.fantasticsource.dynamicstealth.server.senses.sight.EntitySightData;
import com.fantasticsource.dynamicstealth.server.senses.sight.Sight;
import com.fantasticsource.dynamicstealth.server.threat.EntityThreatData;
import com.fantasticsource.dynamicstealth.server.threat.Threat;
import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.ServerTickTimer;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class Network {
    public static final SimpleNetworkWrapper WRAPPER = NetworkRegistry.INSTANCE.newSimpleChannel("dynamicstealth");
    private static int discriminator = 0;
    private static HashSet<EntityLivingBase> soulSightCache = new HashSet();

    public static void init() {
        WRAPPER.registerMessage(HUDPacketHandler.class, HUDPacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(ClientInitPacketHandler.class, ClientInitPacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(VisibilityPacketHandler.class, VisibilityPacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(SoulSightPacketHandler.class, SoulSightPacket.class, discriminator++, Side.CLIENT);
    }

    @SubscribeEvent
    public static void sendClientData(TickEvent.PlayerTickEvent event) {
        event.player.field_70170_p.field_72984_F.func_76320_a("DStealth: Send client data");
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            if (EntitySightData.hasSoulSight((EntityLivingBase)player)) {
                if (!soulSightCache.contains(player)) {
                    soulSightCache.add((EntityLivingBase)player);
                    WRAPPER.sendTo((IMessage)new SoulSightPacket(true), player);
                }
            } else if (soulSightCache.contains(player)) {
                soulSightCache.remove(player);
                WRAPPER.sendTo((IMessage)new SoulSightPacket(false), player);
            }
            if (player.field_70170_p.field_72996_f.contains(player)) {
                if (player.func_70089_S()) {
                    boolean stealthGauge;
                    boolean targetElement;
                    boolean opHUD;
                    if (DynamicStealthConfig.serverSettings.senses.usePlayerSenses) {
                        WRAPPER.sendTo((IMessage)new VisibilityPacket(player), player);
                    }
                    if (MCTools.isOP((EntityPlayerMP)player)) {
                        opHUD = DynamicStealthConfig.serverSettings.hud.ophud.allowOPHUD > 0;
                        targetElement = DynamicStealthConfig.serverSettings.hud.targeting.allowTargetElement > 0;
                        stealthGauge = DynamicStealthConfig.serverSettings.hud.allowStealthGauge > 0;
                    } else {
                        opHUD = DynamicStealthConfig.serverSettings.hud.ophud.allowOPHUD > 1;
                        targetElement = DynamicStealthConfig.serverSettings.hud.targeting.allowTargetElement > 1;
                        boolean bl = stealthGauge = DynamicStealthConfig.serverSettings.hud.allowStealthGauge > 1;
                    }
                    if (opHUD || stealthGauge) {
                        player.field_70170_p.field_72984_F.func_76320_a("DStealth: Create HUDPacket");
                        HUDPacket packet = new HUDPacket(player, opHUD, targetElement, !stealthGauge ? -128 : (int)(Sight.globalPlayerStealthLevel((EntityPlayer)player) * 100.0));
                        player.field_70170_p.field_72984_F.func_76318_c("DStealth: Send HUDPacket");
                        WRAPPER.sendTo((IMessage)packet, player);
                        player.field_70170_p.field_72984_F.func_76319_b();
                    }
                } else {
                    player.field_70170_p.field_72984_F.func_76320_a("DStealth: Create HUDPacket");
                    HUDPacket packet = new HUDPacket(player, false, false, -128);
                    player.field_70170_p.field_72984_F.func_76318_c("DStealth: Send HUDPacket");
                    WRAPPER.sendTo((IMessage)packet, player);
                    player.field_70170_p.field_72984_F.func_76319_b();
                }
            }
        }
        event.player.field_70170_p.field_72984_F.func_76319_b();
    }

    @SubscribeEvent
    public static void playerLogon(PlayerEvent.PlayerLoggedInEvent event) {
        WRAPPER.sendTo((IMessage)new ClientInitPacket(event.player), (EntityPlayerMP)event.player);
    }

    public static class HUDPacketHandler
    implements IMessageHandler<HUDPacket, IMessage> {
        public IMessage onMessage(HUDPacket packet, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    ClientData.prevStealthLevel = (ClientData.stealthLevel == -128 || packet.stealthLevel == -128) && ClientData.stealthLevel != packet.stealthLevel ? packet.stealthLevel : ClientData.stealthLevel;
                    ClientData.stealthLevel = packet.stealthLevel;
                    ClientData.lightLevel = packet.lightLevel;
                    if (packet.update) {
                        ClientData.opMap.clear();
                        int target = ClientData.targetData == null ? -1 : ClientData.targetData.targetID;
                        for (ClientData.OnPointData data : packet.outputList) {
                            ClientData.opMap.put(data.searcherID, data);
                            if (data.searcherID != target) continue;
                            ClientData.targetData = data;
                        }
                    }
                });
            }
            return null;
        }
    }

    public static class HUDPacket
    implements IMessage {
        EntityPlayerMP player;
        boolean targetElement;
        boolean update;
        int stealthLevel;
        int lightLevel;
        ArrayList<EntityLivingBase> inputList = new ArrayList();
        ArrayList<ClientData.OnPointData> outputList = new ArrayList();

        public HUDPacket() {
        }

        public HUDPacket(EntityPlayerMP player, boolean opHUD, boolean targetElement, int stealthLevel) {
            this.player = player;
            this.targetElement = targetElement;
            this.lightLevel = DSTools.maxLightLevelTotal((Entity)player);
            this.stealthLevel = stealthLevel;
            BlockPos playerPos = player.func_180425_c();
            int rangeSq = DynamicStealthConfig.serverSettings.hud.ophud.opHUDRange * DynamicStealthConfig.serverSettings.hud.ophud.opHUDRange;
            int delay = DynamicStealthConfig.serverSettings.hud.ophud.opHUDDelay;
            boolean bl = this.update = opHUD && ServerTickTimer.currentTick() % (long)delay == (long)(player.func_145782_y() % delay);
            if (this.update) {
                for (EntityLivingBase searcher : Sight.seenEntities(player).keySet()) {
                    if (!searcher.func_70089_S() || !(searcher.func_174818_b(playerPos) <= (double)rangeSq)) continue;
                    this.inputList.add(searcher);
                }
            }
        }

        public void toBytes(ByteBuf buf) {
            block7: {
                buf.writeByte(this.stealthLevel);
                buf.writeByte(this.lightLevel);
                buf.writeBoolean(this.update);
                if (!this.update) break block7;
                buf.writeBoolean(this.targetElement);
                buf.writeInt(this.inputList.size());
                if (this.targetElement) {
                    for (EntityLivingBase searcher : this.inputList) {
                        if (EntityThreatData.bypassesThreat(searcher)) {
                            buf.writeByte(7);
                            buf.writeInt(searcher.func_145782_y());
                            EntityLivingBase target = searcher instanceof EntityLiving ? ((EntityLiving)searcher).func_70638_az() : null;
                            buf.writeInt(target == null ? -1 : target.func_145782_y());
                            continue;
                        }
                        Threat.ThreatData data = Threat.get(searcher);
                        byte cid = ClientData.getCID((EntityPlayer)this.player, searcher, data.target, data.threatPercentage);
                        buf.writeByte((int)cid);
                        buf.writeInt(searcher.func_145782_y());
                        if (ClientData.canHaveClientTarget(cid)) {
                            buf.writeInt(data.target == null ? -1 : data.target.func_145782_y());
                        }
                        if (!ClientData.canHaveThreat(cid)) continue;
                        buf.writeByte((int)data.threatPercentage);
                    }
                } else {
                    for (EntityLivingBase searcher : this.inputList) {
                        if (EntityThreatData.bypassesThreat(searcher)) {
                            buf.writeByte(7);
                            buf.writeInt(searcher.func_145782_y());
                            continue;
                        }
                        Threat.ThreatData data = Threat.get(searcher);
                        byte cid = ClientData.getCID((EntityPlayer)this.player, searcher, data.target, data.threatPercentage);
                        buf.writeByte((int)ClientData.getCID((EntityPlayer)this.player, searcher, data.target, data.threatPercentage));
                        buf.writeInt(searcher.func_145782_y());
                        if (!ClientData.canHaveThreat(cid)) continue;
                        buf.writeByte((int)data.threatPercentage);
                    }
                }
            }
        }

        public void fromBytes(ByteBuf buf) {
            block4: {
                int remaining;
                this.stealthLevel = buf.readByte();
                this.lightLevel = buf.readByte();
                this.update = buf.readBoolean();
                if (!this.update) break block4;
                this.targetElement = buf.readBoolean();
                if (this.targetElement) {
                    for (remaining = buf.readInt(); remaining > 0; --remaining) {
                        int color = ClientData.getColor(buf.readByte());
                        this.outputList.add(new ClientData.OnPointData(color, buf.readInt(), ClientData.canHaveClientTarget(color) ? buf.readInt() : -1, ClientData.canHaveThreat(color) ? buf.readByte() : (byte)0));
                    }
                } else {
                    while (remaining > 0) {
                        int color = ClientData.getColor(buf.readByte());
                        this.outputList.add(new ClientData.OnPointData(color, buf.readInt(), -2, ClientData.canHaveThreat(color) ? buf.readByte() : (byte)0));
                        --remaining;
                    }
                }
            }
        }
    }

    public static class ClientInitPacketHandler
    implements IMessageHandler<ClientInitPacket, IMessage> {
        public IMessage onMessage(ClientInitPacket packet, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    ClientData.soulSight = packet.soulSight;
                    ClientData.usePlayerSenses = packet.usePlayerSenses;
                    ClientData.allowTargetingName = packet.allowTargetingName;
                    ClientData.allowTargetingHP = packet.allowTargetingHP;
                    ClientData.allowTargetingThreat = packet.allowTargetingThreat;
                    ClientData.allowTargetingDistance = packet.allowTargetingDistance;
                });
            }
            return null;
        }
    }

    public static class ClientInitPacket
    implements IMessage {
        boolean soulSight;
        boolean usePlayerSenses;
        boolean allowTargetingName;
        boolean allowTargetingHP;
        boolean allowTargetingThreat;
        boolean allowTargetingDistance;

        public ClientInitPacket() {
        }

        public ClientInitPacket(EntityPlayer player) {
            this.soulSight = EntitySightData.hasSoulSight((EntityLivingBase)player);
            if (this.soulSight) {
                soulSightCache.add(player);
            }
            if (MCTools.isOP((EntityPlayerMP)((EntityPlayerMP)player))) {
                this.allowTargetingName = DynamicStealthConfig.serverSettings.hud.targeting.allowNameElement > 0;
                this.allowTargetingHP = DynamicStealthConfig.serverSettings.hud.targeting.allowHPElement > 0;
                this.allowTargetingThreat = DynamicStealthConfig.serverSettings.hud.targeting.allowThreatElement > 0;
                this.allowTargetingDistance = DynamicStealthConfig.serverSettings.hud.targeting.allowDistanceElement > 0;
            } else {
                this.allowTargetingName = DynamicStealthConfig.serverSettings.hud.targeting.allowNameElement > 1;
                this.allowTargetingHP = DynamicStealthConfig.serverSettings.hud.targeting.allowHPElement > 1;
                this.allowTargetingThreat = DynamicStealthConfig.serverSettings.hud.targeting.allowThreatElement > 1;
                this.allowTargetingDistance = DynamicStealthConfig.serverSettings.hud.targeting.allowDistanceElement > 1;
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeBoolean(this.soulSight);
            buf.writeBoolean(DynamicStealthConfig.serverSettings.senses.usePlayerSenses);
            buf.writeBoolean(this.allowTargetingName);
            buf.writeBoolean(this.allowTargetingHP);
            buf.writeBoolean(this.allowTargetingThreat);
            buf.writeBoolean(this.allowTargetingDistance);
        }

        public void fromBytes(ByteBuf buf) {
            this.soulSight = buf.readBoolean();
            this.usePlayerSenses = buf.readBoolean();
            this.allowTargetingName = buf.readBoolean();
            this.allowTargetingHP = buf.readBoolean();
            this.allowTargetingThreat = buf.readBoolean();
            this.allowTargetingDistance = buf.readBoolean();
        }
    }

    public static class SoulSightPacketHandler
    implements IMessageHandler<SoulSightPacket, IMessage> {
        public IMessage onMessage(SoulSightPacket packet, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    ClientData.soulSight = packet.soulSight;
                });
            }
            return null;
        }
    }

    public static class SoulSightPacket
    implements IMessage {
        boolean soulSight;

        public SoulSightPacket() {
        }

        public SoulSightPacket(boolean soulSight) {
            this.soulSight = soulSight;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeBoolean(this.soulSight);
        }

        public void fromBytes(ByteBuf buf) {
            this.soulSight = buf.readBoolean();
        }
    }

    public static class VisibilityPacketHandler
    implements IMessageHandler<VisibilityPacket, IMessage> {
        public IMessage onMessage(VisibilityPacket packet, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    ClientData.previousVisibilityMap2 = ClientData.previousVisibilityMap1;
                    ClientData.previousVisibilityMap1 = ClientData.visibilityMap;
                    ClientData.visibilityMap = packet.visibilityMap;
                });
            }
            return null;
        }
    }

    public static class VisibilityPacket
    implements IMessage {
        LinkedHashMap<EntityLivingBase, Double> inputMap;
        LinkedHashMap<Integer, Float> visibilityMap;

        public VisibilityPacket() {
        }

        public VisibilityPacket(EntityPlayerMP player) {
            this.inputMap = Sight.seenEntities(player);
        }

        public void toBytes(ByteBuf buf) {
            int i = this.inputMap.size();
            buf.writeInt(i);
            for (Map.Entry<EntityLivingBase, Double> entry : this.inputMap.entrySet()) {
                buf.writeInt(entry.getKey().func_145782_y());
                buf.writeFloat((float)(1.0 - entry.getValue()));
            }
        }

        public void fromBytes(ByteBuf buf) {
            this.visibilityMap = new LinkedHashMap();
            for (int i = buf.readInt(); i > 0; --i) {
                this.visibilityMap.put(buf.readInt(), Float.valueOf(buf.readFloat()));
            }
        }
    }
}

