/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.config;

import com.fantasticsource.mctools.MCTools;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Loader;

public class ConfigHandler {
    public static final String CONFIG_NAME = "dynamicstealth/1.12.2.095+";
    private static String configDir = Loader.instance().getConfigDir().getAbsolutePath() + File.separator;
    private static String dsDir = configDir + "dynamicstealth" + File.separator;
    private static File currentFile = new File(dsDir + "1.12.2.095" + "+.cfg");
    public static String fullConfigFilename = currentFile.getAbsolutePath();
    private static File mostRecentFile;
    private static BufferedWriter logWriter;
    private static boolean currentAlreadyExists;

    public static void init() {
        File file = new File(MCTools.getConfigDir() + "dynamicstealth.cfg");
        if (file.exists()) {
            file.renameTo(new File(MCTools.getConfigDir() + "dynamicstealth/dynamicstealth (old).cfg"));
        }
        mostRecentFile = ConfigHandler.mostRecent();
        currentAlreadyExists = mostRecentFile.exists();
    }

    private static File mostRecent() {
        if (currentFile.exists()) {
            return currentFile;
        }
        File[] files = new File(dsDir).listFiles();
        File result = null;
        if (files != null && files.length > 0) {
            int resultSubver = -1;
            for (File file : files) {
                int subver;
                String mcVer;
                String ver = ConfigHandler.getVersion(file);
                if (ver == null || (mcVer = ConfigHandler.getMCVer(ver)) == null || !mcVer.equals(ConfigHandler.getMCVer(ConfigHandler.getVersion(currentFile))) || (ver = ConfigHandler.subVer(ver)) == null || !mcVer.equals(ConfigHandler.getMCVer(ConfigHandler.getVersion(currentFile))) || (subver = Integer.parseInt(ver)) <= resultSubver) continue;
                result = file;
                resultSubver = subver;
            }
            if (result != null) {
                return result;
            }
        }
        if ((result = new File(configDir + "dynamicstealth/dynamicstealth.cfg")).exists()) {
            return result;
        }
        return currentFile;
    }

    private static String getVersion(File file) {
        if (file == null || !file.getName().contains(".cfg") || file.getName().contains(".cfg.")) {
            return null;
        }
        String name = file.getName();
        int index = name.lastIndexOf("+");
        if (index < 1) {
            return null;
        }
        return name.substring(0, index);
    }

    private static String subVer(String version) {
        int index = version.lastIndexOf(".");
        if (index < 1) {
            return null;
        }
        return version.substring(index + 1);
    }

    private static String getMCVer(String version) {
        int index = version.lastIndexOf(".");
        if (index < 1) {
            return null;
        }
        return version.substring(0, index);
    }

    public static void update() throws IOException {
        File logFile;
        int recent;
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("Dynamic Stealth is checking config...");
        if (mostRecentFile == currentFile) {
            if (currentAlreadyExists) {
                System.out.println("Compatible config file found; loading existing config file");
            } else {
                System.out.println("No config found; generating new config file");
            }
            System.out.println();
            System.out.println();
            System.out.println();
            System.out.println();
            System.out.println();
            return;
        }
        System.out.println("Old config file found; attempting conversion to new config file (the old file will remain unchanged)...");
        System.out.println();
        System.out.println();
        String mostRecentVer = ConfigHandler.getVersion(mostRecentFile);
        if (mostRecentVer == null || ConfigHandler.subVer(mostRecentVer) == null) {
            recent = 0;
            logFile = new File(dsDir + "update 1.12.2.55- to " + "1.12.2.095" + "+.log");
        } else {
            recent = Integer.parseInt(ConfigHandler.subVer(mostRecentVer));
            logFile = new File(dsDir + "update " + ConfigHandler.getMCVer("1.12.2.095") + recent + "+ to " + "1.12.2.095" + "+.log");
        }
        logWriter = new BufferedWriter(new FileWriter(logFile));
        switch (recent) {
            case 0: {
                ConfigHandler.updatePre56To56();
            }
            case 56: {
                ConfigHandler.update56To69();
            }
            case 69: {
                ConfigHandler.update69To72();
            }
            case 72: {
                ConfigHandler.update72To77();
            }
            case 77: {
                ConfigHandler.update77To85();
            }
            case 85: {
                ConfigHandler.update85To95();
            }
        }
        try {
            MCTools.reloadConfig((String)fullConfigFilename, (String)"dynamicstealth");
        }
        catch (IllegalAccessException e) {
            MCTools.crash((Exception)e, (int)152, (boolean)true);
        }
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
    }

    private static void updatePre56To56() throws IOException {
        Configuration current = new Configuration(currentFile);
        Configuration old = new Configuration(mostRecentFile);
        ConfigHandler.log("Setting \"Allow On-Point HUD For Clients\" based on \"On-Point HUD for OP players\" and \"On-Point HUD for normal players\"");
        Property p = current.getCategory("general.server settings.client hud allowances").get("Allow On-Point HUD For Clients");
        if (old.get("general.server settings.client hud allowances", "On-Point HUD for normal players", 2).getInt() > 0) {
            p.set(2);
        } else if (old.get("general.server settings.client hud allowances", "On-Point HUD for OP players", 2).getInt() > 0) {
            p.set(1);
        } else {
            p.set(0);
        }
        ConfigHandler.log();
        ConfigHandler.log();
        ConfigHandler.log();
        ConfigHandler.rename(old, "general.server settings.client hud allowances", "Allow detailed HUD on clients", "general.server settings.client hud allowances", "Allow Targeting HUD For Clients");
        ConfigHandler.log();
        ConfigHandler.log();
        ConfigHandler.log();
        ConfigHandler.transferAll(old, current);
        current.save();
        logWriter.close();
    }

    private static void update56To69() throws IOException {
        Configuration current = new Configuration(currentFile);
        Configuration old = new Configuration(mostRecentFile);
        ConfigHandler.rename(old, "general.server settings.client hud allowances", "Allow Targeting HUD For Clients", "general.server settings.client hud allowances.targeting allowances", "050 Allow 'Action' Element");
        ConfigHandler.rename(old, "general.server settings.client hud allowances", "Allow On-Point HUD For Clients", "general.server settings.client hud allowances.ophud allowances", "000 Allow On-Point HUD For Clients");
        ConfigHandler.rename(old, "general.server settings.client hud allowances", "OPHUD Range", "general.server settings.client hud allowances.ophud allowances", "010 OPHUD Range");
        ConfigHandler.rename(old, "general.server settings.client hud allowances", "OPHUD Update Delay", "general.server settings.client hud allowances.ophud allowances", "020 OPHUD Update Delay");
        ConfigHandler.rename(old, "general.client settings.hud.targeting hud style.components", "Target's Name", "general.client settings.hud.targeting hud style.components", "010 Name");
        ConfigHandler.rename(old, "general.client settings.hud.targeting hud style.components", "Target's Health", "general.client settings.hud.targeting hud style.components", "020 Health");
        ConfigHandler.rename(old, "general.client settings.hud.targeting hud style.components", "Target's Target", "general.client settings.hud.targeting hud style.components", "030 Action");
        ConfigHandler.rename(old, "general.client settings.hud.targeting hud style.components", "Target's Threat", "general.client settings.hud.targeting hud style.components", "040 Threat");
        ConfigHandler.rename(old, "general.client settings.hud.targeting hud style.components", "Target's Distance", "general.client settings.hud.targeting hud style.components", "050 Distance");
        ConfigHandler.rename(old, "general.client settings.hud.targeting filter", "Max Distance", "general.client settings.hud.targeting filter", "020 Max Distance");
        ConfigHandler.rename(old, "general.client settings.hud.targeting filter", "Max Angle", "general.client settings.hud.targeting filter", "030 Max Angle");
        ConfigHandler.rename(old, "general.client settings.hud.targeting filter", "Bypass", "general.client settings.hud.targeting filter", "070 Bypass");
        ConfigHandler.rename(old, "general.client settings.hud.targeting filter", "Passive", "general.client settings.hud.targeting filter", "071 Idle (Passive)");
        ConfigHandler.rename(old, "general.client settings.hud.targeting filter", "Idle", "general.client settings.hud.targeting filter", "072 Idle (Non-Passive)");
        ConfigHandler.rename(old, "general.client settings.hud.targeting filter", "Attacking You", "general.client settings.hud.targeting filter", "073 Attacking You");
        ConfigHandler.rename(old, "general.client settings.hud.targeting filter", "Attacking Other", "general.client settings.hud.targeting filter", "074 Attacking Other");
        ConfigHandler.rename(old, "general.client settings.hud.targeting filter", "Alert", "general.client settings.hud.targeting filter", "075 Searching");
        ConfigHandler.rename(old, "general.client settings.hud.targeting filter", "Flee2", "general.client settings.hud.targeting filter", "076 Fleeing (Passive)");
        ConfigHandler.rename(old, "general.client settings.hud.targeting filter", "Flee", "general.client settings.hud.targeting filter", "077 Fleeing (Non-Passive)");
        ConfigHandler.rename(old, "general.client settings.hud.on-point hud filter", "Bypass", "general.client settings.hud.on-point hud filter", "070 Bypass");
        ConfigHandler.rename(old, "general.client settings.hud.on-point hud filter", "Passive", "general.client settings.hud.on-point hud filter", "071 Idle (Passive)");
        ConfigHandler.rename(old, "general.client settings.hud.on-point hud filter", "Idle", "general.client settings.hud.on-point hud filter", "072 Idle (Non-Passive)");
        ConfigHandler.rename(old, "general.client settings.hud.on-point hud filter", "Attacking You", "general.client settings.hud.on-point hud filter", "073 Attacking You");
        ConfigHandler.rename(old, "general.client settings.hud.on-point hud filter", "Attacking Other", "general.client settings.hud.on-point hud filter", "074 Attacking Other");
        ConfigHandler.rename(old, "general.client settings.hud.on-point hud filter", "Alert", "general.client settings.hud.on-point hud filter", "075 Searching");
        ConfigHandler.rename(old, "general.client settings.hud.on-point hud filter", "Flee2", "general.client settings.hud.on-point hud filter", "076 Fleeing (Passive)");
        ConfigHandler.rename(old, "general.client settings.hud.on-point hud filter", "Flee", "general.client settings.hud.on-point hud filter", "077 Fleeing (Non-Passive)");
        ConfigHandler.rename(old, "general.server settings.threat system", "Bypass Threat System (Global)", "general.server settings.threat system", "000 Bypass Threat System (Global)");
        ConfigHandler.rename(old, "general.server settings.threat system", "Maximum Threat", "general.server settings.threat system", "005 Maximum Threat");
        ConfigHandler.rename(old, "general.server settings.threat system", "Initial 'Target Spotted' Threat", "general.server settings.threat system", "010 Initial 'Target Spotted' Threat");
        ConfigHandler.rename(old, "general.server settings.threat system", "Initial Attack Multiplier", "general.server settings.threat system", "015 Initial Attack Multiplier");
        ConfigHandler.rename(old, "general.server settings.threat system", "Dealt Damage Multiplier", "general.server settings.threat system", "020 Dealt Damage Multiplier");
        ConfigHandler.rename(old, "general.server settings.threat system", "'Attacked By Same' Multiplier", "general.server settings.threat system", "025 'Attacked By Same' Multiplier");
        ConfigHandler.rename(old, "general.server settings.threat system", "'Attacked By Other' Multiplier", "general.server settings.threat system", "030 'Attacked By Other' Multiplier");
        ConfigHandler.rename(old, "general.server settings.threat system", "'Warned' Threat", "general.server settings.threat system", "035 'Warned' Threat");
        ConfigHandler.rename(old, "general.server settings.threat system", "'Ally Killed' Threat", "general.server settings.threat system", "040 'Ally Killed' Threat");
        ConfigHandler.rename(old, "general.server settings.threat system", "Seen Target Threat Rate", "general.server settings.threat system", "060 Seen Target Threat Rate");
        ConfigHandler.rename(old, "general.server settings.threat system", "Unseen Target Degredation Rate", "general.server settings.threat system", "065 Unseen Target Degredation Rate");
        ConfigHandler.rename(old, "general.server settings.ai.flee", "Degredation Rate", "general.server settings.threat system", "070 Flee Degredation Rate");
        ConfigHandler.rename(old, "general.server settings.threat system", "Owned Can't Reach Degredation Rate", "general.server settings.threat system", "075 Owned Can't Reach Degredation Rate");
        ConfigHandler.log();
        ConfigHandler.log();
        ConfigHandler.log();
        ConfigHandler.transferAll(old, current);
        current.save();
        logWriter.close();
    }

    private static void update69To72() throws IOException {
        Configuration current = new Configuration(currentFile);
        Configuration old = new Configuration(mostRecentFile);
        ConfigHandler.rename(old, "general.server settings.senses.sight.lighting", "Light (High/Bright)", "general.server settings.senses.sight.lighting", "000 Light Level (High/Bright)");
        if (old.get("general.server settings.senses.sight.lighting", "Light (Low/Dark)", -1).getInt() < 0) {
            old.getCategory("general.server settings.senses.sight.lighting").get("Light (Low/Dark)").set(0);
        }
        ConfigHandler.rename(old, "general.server settings.senses.sight.lighting", "Light (Low/Dark)", "general.server settings.senses.sight.lighting", "040 Light Level (Low/Dark)");
        ConfigHandler.rename(old, "general.server settings.senses.sight.lighting", "Nightvision Bonus", "general.server settings.senses.sight.lighting", "080 Nightvision Bonus");
        ConfigHandler.log("Clearing entity-specific lighting settings due to changes; your old config file is available for reference if you need it (config/dynamicstealth/1.12.2.069+.cfg)");
        old.get("general.server settings.senses.sight.entity-specific settings (advanced)", "Lighting", new String[0]).set(new String[0]);
        ConfigHandler.log();
        ConfigHandler.log();
        ConfigHandler.log();
        ConfigHandler.transferAll(old, current);
        current.save();
        logWriter.close();
    }

    private static void update72To77() throws IOException {
        Configuration current = new Configuration(currentFile);
        Configuration old = new Configuration(mostRecentFile);
        ConfigHandler.transferAll(old, current);
        ConfigHandler.log();
        ConfigHandler.log();
        ConfigHandler.log();
        ConfigHandler.log("Setting new threat config settings based on existing ones; in theory you should see no change in gameplay");
        int oldMax = old.get("general.server settings.threat", "005 Maximum Threat", 1000).getInt();
        double ratio = 100.0 / (double)oldMax;
        current.get("general.server settings.threat system", "010 Initial 'Target Spotted' Threat", 30.0).set(ratio * (double)old.get("general.server settings.threat system", "010 Initial 'Target Spotted' Threat", 300).getInt());
        current.get("general.server settings.threat system", "015 Initial Attack Multiplier", 400.0).set(ratio * old.get("general.server settings.threat system", "015 Initial Attack Multiplier", 4000).getDouble());
        current.get("general.server settings.threat system", "020 Dealt Damage Multiplier", 200.0).set(ratio * old.get("general.server settings.threat system", "020 Dealt Damage Multiplier", 2000).getDouble());
        current.get("general.server settings.threat system", "025 'Attacked By Same' Multiplier", 400.0).set(ratio * old.get("general.server settings.threat system", "025 'Attacked By Same' Multiplier", 4000).getDouble());
        current.get("general.server settings.threat system", "030 'Attacked By Other' Multiplier", 400.0).set(ratio * old.get("general.server settings.threat system", "030 'Attacked By Other' Multiplier", 4000).getDouble());
        current.get("general.server settings.threat system", "035 'Warned' Threat", 30.0).set(ratio * (double)old.get("general.server settings.threat system", "035 'Warned' Threat", 300).getInt());
        current.get("general.server settings.threat system", "040 'Ally Killed' Threat", 100.0).set(ratio * (double)old.get("general.server settings.threat system", "040 'Ally Killed' Threat", 1000).getInt());
        current.get("general.server settings.threat system", "060 Seen Target Threat Rate", 0.1).set(ratio * (double)old.get("general.server settings.threat system", "060 Seen Target Threat Rate", 1).getInt());
        current.get("general.server settings.threat system", "065 Unseen Target Degredation Rate", 0.1).set(ratio * (double)old.get("general.server settings.threat system", "065 Unseen Target Degredation Rate", 1).getInt());
        current.get("general.server settings.threat system", "070 Flee Degredation Rate", 0.3).set(ratio * (double)old.get("general.server settings.threat system", "070 Flee Degredation Rate", 3).getInt());
        current.get("general.server settings.threat system", "075 Owned Can't Reach Degredation Rate", 0.5).set(ratio * (double)old.get("general.server settings.threat system", "075 Owned Can't Reach Degredation Rate", 5).getInt());
        current.save();
        logWriter.close();
    }

    private static void update77To85() throws IOException {
        Configuration current = new Configuration(currentFile);
        Configuration old = new Configuration(mostRecentFile);
        ConfigHandler.rename(old, "general.server settings.threat system", "010 Initial 'Target Spotted' Threat", "general.server settings.threat system", "010 'Start of Combat' Threat");
        ConfigHandler.log();
        ConfigHandler.log();
        ConfigHandler.log();
        ConfigHandler.transferAll(old, current);
        current.save();
        logWriter.close();
    }

    private static void update85To95() throws IOException {
        Configuration current = new Configuration(currentFile);
        Configuration old = new Configuration(mostRecentFile);
        ConfigHandler.transferAll(old, current);
        ConfigHandler.log();
        ConfigHandler.log();
        ConfigHandler.log();
        ConfigHandler.log("Setting entity-specific flee thresholds based on old fearless configs; in theory you should see no change in gameplay");
        ArrayList<String> newData = new ArrayList<String>();
        for (String name : old.get("general.server settings.ai.flee", "Fearless", new String[0]).getStringList()) {
            ConfigHandler.log(name + " -> " + name + ", 0");
            newData.add(name + ", 0");
        }
        current.get("general.server settings.ai.entity-specific settings (advanced)", "Entity-Specific Flee Threshold", new String[0]).set(newData.toArray(new String[0]));
        current.save();
        logWriter.close();
    }

    private static void rename(Configuration old, String oldCat, String oldName, String newCat, String newName) throws IOException {
        ConfigHandler.log("* Renaming... " + oldCat + " -> " + oldName);
        ConfigHandler.log("* To... " + newCat + " -> " + newName);
        old.moveProperty(oldCat, oldName, newCat);
        old.renameProperty(newCat, oldName, newName);
    }

    private static void transferAll(Configuration old, Configuration current) throws IOException {
        String k;
        for (String string : current.getCategoryNames()) {
            if (old.hasCategory(string)) {
                ConfigHandler.log("~ Found matching category: \"" + string + "\"...");
                ConfigHandler.log();
                ConfigCategory oldCat = old.getCategory(string);
                Set oldKeys = oldCat.keySet();
                for (Map.Entry entry : current.getCategory(string).entrySet()) {
                    k = (String)entry.getKey();
                    if (oldKeys.contains(k)) {
                        if (oldCat.get(k).getType() == ((Property)entry.getValue()).getType()) {
                            entry.setValue(oldCat.get(k));
                            ConfigHandler.log("~ Copied values for matching entry: \"" + k + "\"");
                            continue;
                        }
                        ConfigHandler.log("$ Changing type of existing entry: \"" + k + "\" from " + oldCat.get(k).getType() + " to " + ((Property)entry.getValue()).getType());
                        continue;
                    }
                    ConfigHandler.log("+ Adding new entry: \"" + k + "\"");
                }
            } else {
                ConfigHandler.log("+ Adding new category: \"" + string + "\"...");
                ConfigHandler.log();
                for (Map.Entry entry : current.getCategory(string).entrySet()) {
                    ConfigHandler.log("+ Adding new entry: \"" + (String)entry.getKey() + "\"");
                }
            }
            ConfigHandler.log();
            ConfigHandler.log();
        }
        ConfigHandler.log();
        ConfigHandler.log();
        for (String string : old.getCategoryNames()) {
            if (!current.hasCategory(string)) {
                ConfigHandler.log("- Removing old category: \"" + string + "\"...");
                ConfigHandler.log();
                for (Map.Entry entry : old.getCategory(string).entrySet()) {
                    ConfigHandler.log("- Removing old entry: \"" + (String)entry.getKey() + "\"");
                }
                ConfigHandler.log();
                ConfigHandler.log();
                continue;
            }
            boolean printedCat = false;
            Set newKeys = current.getCategory(string).keySet();
            for (Map.Entry entry : old.getCategory(string).entrySet()) {
                k = (String)entry.getKey();
                if (newKeys.contains(k)) continue;
                if (!printedCat) {
                    ConfigHandler.log("- Removing some entries from category: \"" + string + "\"...");
                    ConfigHandler.log();
                    printedCat = true;
                }
                ConfigHandler.log("- Removing old entry: \"" + k + "\"");
            }
            if (!printedCat) continue;
            ConfigHandler.log();
            ConfigHandler.log();
        }
    }

    private static void log() throws IOException {
        logWriter.write("\r\n");
        System.out.println();
    }

    private static void log(String string) throws IOException {
        logWriter.write(string + "\r\n");
        System.out.println(string);
    }

    static {
        currentAlreadyExists = false;
    }
}

