/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.config.server.senses.sight;

import net.minecraftforge.common.config.Config;

public class LightingConfig {
    @Config.Name(value="000 Light Level (High/Bright)")
    @Config.LangKey(value="dynamicstealth.config.lightLevelHigh")
    @Config.Comment(value={"At or above this light level, entities receive the maximum light level multiplier"})
    @Config.RangeInt(min=0, max=15)
    public int lightLevelHigh = 11;
    @Config.Name(value="020 Multiplier (High/Bright)")
    @Config.LangKey(value="dynamicstealth.config.lightMultHigh")
    @Config.Comment(value={"The light level visibility multiplier when standing in bright areas", "0 means invisible, 1 means fully visible (other factors not accounted for)"})
    @Config.RangeDouble(min=0.0, max=1.0)
    public double lightMultHigh = 1.0;
    @Config.Name(value="040 Light Level (Low/Dark)")
    @Config.LangKey(value="dynamicstealth.config.lightLevelLow")
    @Config.Comment(value={"At or below this light level, entities receive the minimum light level multiplier"})
    @Config.RangeInt(min=0, max=15)
    public int lightLevelLow = 0;
    @Config.Name(value="060 Multiplier (Low/Dark)")
    @Config.LangKey(value="dynamicstealth.config.lightMultLow")
    @Config.Comment(value={"The light level visibility multiplier when standing in dark areas", "0 means invisible, 1 means fully visible (other factors not accounted for)"})
    @Config.RangeDouble(min=0.0, max=1.0)
    public double lightMultLow = 0.1;
    @Config.Name(value="080 Nightvision Bonus")
    @Config.LangKey(value="dynamicstealth.config.nightvisionBonus")
    @Config.Comment(value={"When an entity has the nightvision effect, this value is added to their perceived light levels (and then set to 15 if larger than 15)"})
    @Config.RangeInt(min=0, max=15)
    public int nightvisionBonus = 15;
    @Config.Name(value="Minimum Dimension Light Levels")
    @Config.LangKey(value="dynamicstealth.config.minimumDimensionLightLevels")
    @Config.Comment(value={"The minimum light level Dynamic Stealth will detect when in a given dimension", "These are mostly for dimensions with ambient lighting (eg. the nether and the end)", "The 1st number is the dimension id, the 2nd is the minimum light level for that dimension"})
    public String[] z_minimumDimensionLightLevels = new String[]{"0, 0", "-1, 7", "1, 8"};
}

