/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.config.server.threat;

import com.fantasticsource.dynamicstealth.config.server.threat.CNPCThreatConfig;
import com.fantasticsource.dynamicstealth.config.server.threat.SpecificThreatConfig;
import net.minecraftforge.common.config.Config;

public class ThreatConfig {
    @Config.Name(value="Entity-Specific Settings (Advanced)")
    @Config.LangKey(value="dynamicstealth.config.threatEntitySpecific")
    public SpecificThreatConfig y_entityOverrides = new SpecificThreatConfig();
    @Config.Name(value="CNPC Threat Settings")
    @Config.LangKey(value="dynamicstealth.config.threatCNPC")
    public CNPCThreatConfig cnpcThreatConfig = new CNPCThreatConfig();
    @Config.Name(value="000 Bypass Threat System (Global)")
    @Config.LangKey(value="dynamicstealth.config.threatBypassGlobal")
    @Config.Comment(value={"If enabled, all entities should bypass the threat system"})
    public boolean bypassThreatSystem = false;
    @Config.Name(value="010 'Start of Combat' Threat")
    @Config.LangKey(value="dynamicstealth.config.threatCombatStart")
    @Config.Comment(value={"When an out-of-combat entity first enters combat, its threat is set to this", "This can happen from an entity seeing a valid target to attack or from an entity taking damage while out of combat"})
    @Config.RangeDouble(min=0.0)
    public double combatStart = 30.0;
    @Config.Name(value="020 Dealt Damage Multiplier")
    @Config.LangKey(value="dynamicstealth.config.threatDealtDamage")
    @Config.Comment(value={"When an in-combat entity damages its current target, its threat is increased by the damage dealt times this, divided by its target's max HP"})
    @Config.RangeDouble(min=0.0)
    public double damageDealtMultiplier = 200.0;
    @Config.Name(value="025 'Attacked By Same' Multiplier")
    @Config.LangKey(value="dynamicstealth.config.threatAttackedBySame")
    @Config.Comment(value={"When an in-combat entity is attacked by its current target, its threat is increased by the damage taken times this, divided by its max HP"})
    @Config.RangeDouble(min=0.0)
    public double attackedBySameMultiplier = 400.0;
    @Config.Name(value="030 'Attacked By Other' Multiplier")
    @Config.LangKey(value="dynamicstealth.config.threatAttackedByOther")
    @Config.Comment(value={"When an in-combat entity is attacked by something that is *not* its current target, its threat is decreased by damage taken times this, divided by its max HP"})
    @Config.RangeDouble(min=0.0)
    public double attackedByOtherMultiplier = 400.0;
    @Config.Name(value="035 'Warned' Threat")
    @Config.LangKey(value="dynamicstealth.config.threatWarned")
    @Config.Comment(value={"When an entity heeds a warning from another entity, its threat is set to this (if less than this)"})
    @Config.RangeDouble(min=0.0)
    public double warnedThreat = 30.0;
    @Config.Name(value="040 'Ally Killed' Threat")
    @Config.LangKey(value="dynamicstealth.config.threatAllyKilled")
    @Config.Comment(value={"When an entity sees an ally die, increase threat"})
    @Config.RangeDouble(min=0.0)
    public double allyKilledThreat = 100.0;
    @Config.Name(value="060 Seen Target Threat Rate")
    @Config.LangKey(value="dynamicstealth.config.threatSeenRate")
    @Config.Comment(value={"Every time an entity updates and their target is visible and reachable, this is added to their threat"})
    @Config.RangeDouble(min=0.0)
    public double seenTargetThreatRate = 0.1;
    @Config.Name(value="065 Unseen Target Degredation Rate")
    @Config.LangKey(value="dynamicstealth.config.threatUnseenRate")
    @Config.Comment(value={"Every time an entity updates and their target's position is unknown, this is subtracted from their threat"})
    @Config.RangeDouble(min=0.0)
    public double unseenTargetDegredationRate = 0.1;
    @Config.Name(value="070 Flee Degredation Rate")
    @Config.LangKey(value="dynamicstealth.config.threatFleeRate")
    @Config.Comment(value={"How fast the threat gauge decreases while fleeing; lower number means they flee for a longer time"})
    @Config.RangeDouble(min=0.0)
    public double fleeDegredationRate = 0.3;
    @Config.Name(value="075 Owned Can't Reach Degredation Rate")
    @Config.LangKey(value="dynamicstealth.config.threatCantReachRate")
    @Config.Comment(value={"Every time an owned entity updates and can't reach their target, this is subtracted from their threat"})
    @Config.RangeDouble(min=0.0)
    public double ownedCantReachDegredationRate = 0.5;
}

