/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server;

import com.fantasticsource.dynamicstealth.compat.Compat;
import com.fantasticsource.dynamicstealth.config.DynamicStealthConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.scoreboard.Team;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.handler.data.IFaction;

public class HelperSystem {
    public static boolean isAlly(EntityLivingBase helper, EntityLivingBase troubledOne) {
        return HelperSystem.rep(helper, troubledOne) > 0;
    }

    public static int rep(EntityLivingBase helper, EntityLivingBase troubledOne) {
        IEntity cnpcEntityHelper;
        Entity helperOwner;
        if (helper == null || troubledOne == null) {
            return 0;
        }
        if (helper instanceof IEntityOwnable && (helperOwner = ((IEntityOwnable)helper).func_70902_q()) != null) {
            if (troubledOne == helperOwner) {
                if (DynamicStealthConfig.serverSettings.helperSystemSettings.ownership.helpOwner) {
                    return 100;
                }
            } else if (troubledOne instanceof IEntityOwnable && ((IEntityOwnable)troubledOne).func_70902_q() == helperOwner) {
                if (DynamicStealthConfig.serverSettings.helperSystemSettings.ownership.helpOtherWithSameOwner) {
                    return 90;
                }
            } else if (DynamicStealthConfig.serverSettings.helperSystemSettings.ownership.dedicated) {
                return 0;
            }
        }
        if (troubledOne instanceof IEntityOwnable && ((IEntityOwnable)troubledOne).func_70902_q() == helper && DynamicStealthConfig.serverSettings.helperSystemSettings.ownership.helpOwned) {
            return 80;
        }
        Team troubledOneTeam = troubledOne.func_96124_cp();
        if (troubledOneTeam != null) {
            if (troubledOneTeam.func_142054_a(helper.func_96124_cp())) {
                if (DynamicStealthConfig.serverSettings.helperSystemSettings.teams.helpSame) {
                    return 70;
                }
            } else if (helper.func_96124_cp() != null && DynamicStealthConfig.serverSettings.helperSystemSettings.teams.dontHelpOther) {
                return 0;
            }
        }
        IEntity cnpcEntityTroubled = Compat.customnpcs ? NpcAPI.Instance().getIEntity((Entity)troubledOne) : null;
        IEntity iEntity = cnpcEntityHelper = Compat.customnpcs ? NpcAPI.Instance().getIEntity((Entity)helper) : null;
        if (cnpcEntityHelper != null && cnpcEntityTroubled != null) {
            int factionStatus = HelperSystem.cnpcRep(cnpcEntityHelper, cnpcEntityTroubled);
            if (factionStatus > 0) {
                if (DynamicStealthConfig.serverSettings.helperSystemSettings.cnpcFactions.helpGoodRep) {
                    return 60;
                }
            } else if (factionStatus < 0 && DynamicStealthConfig.serverSettings.helperSystemSettings.cnpcFactions.dontHelpBadRep) {
                return 0;
            }
        }
        if (troubledOne.getClass() == helper.getClass() && !(cnpcEntityTroubled instanceof ICustomNpc) && DynamicStealthConfig.serverSettings.helperSystemSettings.helpSameType) {
            return 50;
        }
        return 0;
    }

    private static int cnpcRep(IEntity entity1, IEntity entity2) {
        if (entity1 instanceof ICustomNpc) {
            if (entity2 instanceof ICustomNpc) {
                return HelperSystem.cnpcRep((ICustomNpc)entity1, (ICustomNpc)entity2);
            }
            if (entity2 instanceof IPlayer) {
                return HelperSystem.cnpcRep((ICustomNpc)entity1, (IPlayer)entity2);
            }
        } else if (entity1 instanceof IPlayer && entity2 instanceof ICustomNpc) {
            return HelperSystem.cnpcRep((ICustomNpc)entity2, (IPlayer)entity1);
        }
        return 0;
    }

    private static int cnpcRep(ICustomNpc entity1, ICustomNpc entity2) {
        boolean nonNull2;
        boolean nonNull1;
        IFaction faction1 = entity1.getFaction();
        boolean bl = nonNull1 = faction1 != null;
        if (nonNull1 && faction1.hostileToNpc(entity2)) {
            return -1;
        }
        IFaction faction2 = entity2.getFaction();
        boolean bl2 = nonNull2 = faction2 != null;
        if (nonNull2) {
            if (faction2.hostileToNpc(entity1)) {
                return -1;
            }
            if (nonNull1) {
                if (faction1 == faction2) {
                    return 1;
                }
                if (faction1.hostileToFaction(faction2.getId()) || faction2.hostileToFaction(faction1.getId())) {
                    return -1;
                }
            }
        }
        return 0;
    }

    private static int cnpcRep(ICustomNpc entity1, IPlayer entity2) {
        IFaction faction = entity1.getFaction();
        if (faction == null) {
            return 0;
        }
        return entity2.factionStatus(faction.getId());
    }
}

