/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.ai;

import com.fantasticsource.dynamicstealth.DynamicStealth;
import com.fantasticsource.dynamicstealth.compat.Compat;
import com.fantasticsource.dynamicstealth.compat.CompatEBWizardry;
import com.fantasticsource.dynamicstealth.config.DynamicStealthConfig;
import com.fantasticsource.dynamicstealth.server.CombatTracker;
import com.fantasticsource.dynamicstealth.server.ai.EntityAIData;
import com.fantasticsource.dynamicstealth.server.ai.edited.AITargetEdit;
import com.fantasticsource.dynamicstealth.server.event.BasicEvent;
import com.fantasticsource.dynamicstealth.server.event.EventData;
import com.fantasticsource.dynamicstealth.server.senses.hearing.Communication;
import com.fantasticsource.dynamicstealth.server.senses.sight.Sight;
import com.fantasticsource.dynamicstealth.server.threat.EntityThreatData;
import com.fantasticsource.dynamicstealth.server.threat.Threat;
import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.NPEAttackTargetTaskHolder;
import com.fantasticsource.tools.ReflectionTool;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.TrigLookupTable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIFollow;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIRunAroundLikeCrazy;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.ICustomNpc;

public class AIDynamicStealth
extends EntityAIBase {
    public static final int MODE_NONE = 0;
    public static final int MODE_FIND_PATH = 1;
    public static final int MODE_FOLLOW_PATH = 2;
    public static final int MODE_SPIN = 3;
    public static final int MODE_FIND_RANDOM_PATH = 4;
    public static final int MODE_FACE_RANDOM_PATH = 5;
    public static final int MODE_FOLLOW_RANDOM_PATH = 6;
    public static final int MODE_FLEE = -1;
    public static final int MODE_COWER = -2;
    public static final int FLEE_NONE = 0;
    public static final int FLEE_PASSIVE = 1;
    public static final int FLEE_CANTREACH = 2;
    public static final int FLEE_HP = 3;
    private static Method navigatorCanNavigateMethod;
    private static TrigLookupTable trigTable;
    private final EntityLiving searcher;
    private final PathNavigate navigator;
    public double speed;
    public double fleeSpeed;
    public Path path = null;
    public BlockPos lastKnownPosition = null;
    public BlockPos fleeToPos = null;
    public boolean triedTriggerCantReach = false;
    public int fleeReason;
    private int mode;
    private int timeAtPos;
    private boolean spinDirection;
    private Vec3d lastPos = null;
    private Vec3d nextPos = null;
    private double startAngle;
    private double angleDif;
    private double pathAngle;
    private int headTurnSpeed;
    private boolean isCNPC;
    private float cornerLookYaw;
    private float cornerLookPitch;

    private AIDynamicStealth(EntityLiving living, double speedIn) {
        this.searcher = living;
        this.navigator = living.func_70661_as();
        this.speed = speedIn;
        this.fleeSpeed = this.speed * 1.25;
        this.headTurnSpeed = EntityAIData.headTurnSpeed((EntityLivingBase)this.searcher);
        this.isCNPC = Compat.customnpcs && NpcAPI.Instance().getIEntity((Entity)this.searcher) instanceof ICustomNpc;
        this.func_75248_a(3);
    }

    public static AIDynamicStealth getInstance(EntityLiving living) {
        double lowSpeed = 0.0;
        double normalSpeed = 0.0;
        double highSpeed = 2.147483647E9;
        for (EntityAITasks.EntityAITaskEntry entry : living.field_70714_bg.field_75782_a) {
            EntityAIBase ai = entry.field_75733_a;
            if (ai instanceof NPEAttackTargetTaskHolder) {
                ai = ((NPEAttackTargetTaskHolder)ai).getBadAI();
            }
            if (ai instanceof EntityAIAttackMelee) {
                normalSpeed = Tools.max((double[])new double[]{normalSpeed, ((EntityAIAttackMelee)ai).field_75440_e});
                continue;
            }
            if (ai instanceof EntityAIAttackRanged) {
                normalSpeed = Tools.max((double[])new double[]{normalSpeed, ((EntityAIAttackRanged)ai).field_75321_e});
                continue;
            }
            if (ai instanceof EntityAIAttackRangedBow) {
                normalSpeed = Tools.max((double[])new double[]{normalSpeed, ((EntityAIAttackRangedBow)ai).field_188500_b});
                continue;
            }
            if (ai instanceof EntityAIFollow) {
                normalSpeed = Tools.max((double[])new double[]{normalSpeed, ((EntityAIFollow)ai).field_192375_d});
                continue;
            }
            if (ai instanceof EntityAIFollowOwner) {
                normalSpeed = Tools.max((double[])new double[]{normalSpeed, ((EntityAIFollowOwner)ai).field_75336_f});
                continue;
            }
            if (ai instanceof EntityAIMate) {
                normalSpeed = Tools.max((double[])new double[]{normalSpeed, ((EntityAIMate)ai).field_75393_c});
                continue;
            }
            if (ai instanceof EntityAIFleeSun) {
                normalSpeed = Tools.max((double[])new double[]{normalSpeed, ((EntityAIFleeSun)ai).field_75369_e});
                continue;
            }
            if (ai instanceof EntityAIFollowParent) {
                normalSpeed = Tools.max((double[])new double[]{normalSpeed, ((EntityAIFollowParent)ai).field_75347_c});
                continue;
            }
            if (ai instanceof EntityAIWander) {
                lowSpeed = Tools.max((double[])new double[]{lowSpeed, ((EntityAIWander)ai).field_75454_e});
                continue;
            }
            if (ai instanceof EntityAIPanic) {
                highSpeed = Tools.min((double[])new double[]{highSpeed, ((EntityAIPanic)ai).field_75265_b});
                continue;
            }
            if (ai instanceof EntityAIRunAroundLikeCrazy) {
                highSpeed = Tools.min((double[])new double[]{highSpeed, ((EntityAIRunAroundLikeCrazy)ai).field_111178_b});
                continue;
            }
            if (!(ai instanceof EntityAIAvoidEntity)) continue;
            highSpeed = Tools.min((double[])new double[]{highSpeed, ((EntityAIAvoidEntity)ai).field_75379_c});
        }
        if (normalSpeed != 0.0) {
            return new AIDynamicStealth(living, normalSpeed);
        }
        if (highSpeed != 2.147483647E9) {
            return new AIDynamicStealth(living, highSpeed / 1.2);
        }
        if (lowSpeed != 0.0) {
            return new AIDynamicStealth(living, lowSpeed * 1.7);
        }
        return new AIDynamicStealth(living, 1.0);
    }

    public static AIDynamicStealth getStealthAI(EntityLiving living) {
        for (EntityAITasks.EntityAITaskEntry task : living.field_70714_bg.field_75782_a) {
            if (!(task.field_75733_a instanceof AIDynamicStealth)) continue;
            return (AIDynamicStealth)task.field_75733_a;
        }
        return null;
    }

    public boolean isFleeing() {
        return this.fleeReason != 0;
    }

    public int getMode() {
        return this.mode;
    }

    public void fleeIfYouShould(float hpOffset) {
        int threshold = EntityAIData.fleeThreshold((EntityLivingBase)this.searcher);
        if (this.fleeReason == 2 || threshold > 0) {
            if (EntityThreatData.isPassive((EntityLivingBase)this.searcher)) {
                this.fleeReason = 1;
                this.mode = 0;
            } else if (threshold > 0 && (int)((this.searcher.func_110143_aJ() + hpOffset) / this.searcher.func_110138_aP() * 100.0f) < threshold) {
                this.fleeReason = 3;
                this.mode = 0;
            }
        }
    }

    private boolean canReachTarget() {
        if (CombatTracker.timeSinceLastIdle((EntityLivingBase)this.searcher) >= (long)DynamicStealthConfig.serverSettings.ai.cantReach.lastIdleThreshold && CombatTracker.timeSinceLastSuccessfulAttack((EntityLivingBase)this.searcher) >= (long)DynamicStealthConfig.serverSettings.ai.cantReach.lastAttackThreshold && CombatTracker.timeSinceLastSuccessfulPath((EntityLivingBase)this.searcher) >= (long)DynamicStealthConfig.serverSettings.ai.cantReach.lastPathThreshold && CombatTracker.timeSinceLastNoTarget((EntityLivingBase)this.searcher) >= (long)DynamicStealthConfig.serverSettings.ai.cantReach.lastNoTargetThreshold) {
            EntityLivingBase target = Threat.getTarget((EntityLivingBase)this.searcher);
            if (target == null) {
                return false;
            }
            Path newPath = this.navigator.func_75494_a((Entity)target);
            if (newPath == null || newPath.func_75876_a(this.navigator.func_75505_d())) {
                return false;
            }
            return CombatTracker.pathReachesThreatTarget(this.searcher, newPath);
        }
        return true;
    }

    public boolean func_75250_a() {
        this.searcher.field_70170_p.field_72984_F.func_76320_a("DStealth: AI");
        if (!this.searcher.func_70089_S()) {
            this.mode(0);
            Threat.set((EntityLivingBase)this.searcher, null, 0.0f);
            this.searcher.field_70170_p.field_72984_F.func_76319_b();
            return false;
        }
        if (CompatEBWizardry.mindTrickPotion != null && this.searcher.func_70660_b(CompatEBWizardry.mindTrickPotion) != null) {
            this.mode(0);
            Threat.set((EntityLivingBase)this.searcher, null, 0.0f);
            this.searcher.field_70170_p.field_72984_F.func_76319_b();
            return false;
        }
        EntityLivingBase target = Threat.getTarget((EntityLivingBase)this.searcher);
        if (target != null && CompatEBWizardry.mindControllerIs((EntityLivingBase)this.searcher, target)) {
            Threat.set((EntityLivingBase)this.searcher, null, 0.0f);
        }
        if (DynamicStealthConfig.serverSettings.ai.cnpcsResetInWater && this.isCNPC && this.searcher.func_70090_H()) {
            ((ICustomNpc)NpcAPI.Instance().getIEntity((Entity)this.searcher)).reset();
            Threat.setThreat((EntityLivingBase)this.searcher, 0.0f);
        }
        Threat.ThreatData threatData = Threat.get((EntityLivingBase)this.searcher);
        float threatPercentage = threatData.threatPercentage;
        if (threatPercentage <= 0.0f) {
            EntityLivingBase attackTarget = this.searcher.func_70638_az();
            if (AITargetEdit.isSuitableTarget(this.searcher, attackTarget)) {
                Threat.apply((EntityLivingBase)this.searcher, attackTarget, DynamicStealthConfig.serverSettings.threat.combatStart, Threat.THREAT_TYPE.GEN_TARGET_SPOTTED, true);
                this.lastKnownPosition = attackTarget.func_180425_c();
                this.clearAIPath();
                Communication.warn((EntityLivingBase)this.searcher, attackTarget, attackTarget.func_180425_c(), true);
                this.searcher.field_70170_p.field_72984_F.func_76319_b();
                return false;
            }
            Compat.clearAttackTargetAndCancelBadTasks(this.searcher);
            this.searcher.field_70170_p.field_72984_F.func_76319_b();
            return false;
        }
        if (this.fleeReason != 0) {
            this.searcher.field_70170_p.field_72984_F.func_76319_b();
            return true;
        }
        EntityLivingBase threatTarget = threatData.target;
        if (threatTarget == null) {
            EntityLivingBase attackTarget = this.searcher.func_70638_az();
            if (AITargetEdit.isSuitableTarget(this.searcher, attackTarget)) {
                Threat.apply((EntityLivingBase)this.searcher, attackTarget, DynamicStealthConfig.serverSettings.threat.combatStart, Threat.THREAT_TYPE.GEN_TARGET_SPOTTED, true);
                this.lastKnownPosition = attackTarget.func_180425_c();
                this.clearAIPath();
                Communication.warn((EntityLivingBase)this.searcher, attackTarget, attackTarget.func_180425_c(), true);
                this.searcher.field_70170_p.field_72984_F.func_76319_b();
                return false;
            }
            Compat.clearAttackTargetAndCancelBadTasks(this.searcher);
            this.searcher.field_70170_p.field_72984_F.func_76319_b();
            return this.unseenTargetDegredation(threatPercentage);
        }
        if (!this.canReachTarget() && !EventData.checkCantReachPotionFilter((EntityLivingBase)this.searcher)) {
            if (MCTools.isOwned((Entity)this.searcher)) {
                Threat.apply((EntityLivingBase)this.searcher, null, DynamicStealthConfig.serverSettings.threat.ownedCantReachDegredationRate, Threat.THREAT_TYPE.DEG_OWNED_CANT_REACH, false);
                this.clearAIPath();
                return false;
            }
            if (!this.triedTriggerCantReach && !MinecraftForge.EVENT_BUS.post((Event)new BasicEvent.CantReachEvent((EntityLivingBase)this.searcher))) {
                if (Sight.canSee((EntityLivingBase)this.searcher, (Entity)threatTarget, true)) {
                    Communication.warn((EntityLivingBase)this.searcher, threatTarget, threatTarget.func_180425_c(), true);
                } else {
                    int distance = (int)this.searcher.func_70032_d((Entity)threatTarget);
                    if (this.lastKnownPosition == null) {
                        this.lastKnownPosition = this.searcher.func_180425_c();
                    }
                    Communication.warn((EntityLivingBase)this.searcher, threatTarget, MCTools.randomPos((BlockPos)this.lastKnownPosition, (int)Tools.min((int[])new int[]{distance >> 1, 7}), (int)Tools.min((int[])new int[]{distance >> 2, 4})), false);
                }
                for (PotionEffect potionEffect : EventData.cantReachPotions) {
                    this.searcher.func_70690_d(new PotionEffect(potionEffect));
                }
                if (DynamicStealthConfig.serverSettings.ai.cantReach.flee) {
                    this.fleeReason = 2;
                    this.searcher.field_70170_p.field_72984_F.func_76319_b();
                    return true;
                }
            }
            this.triedTriggerCantReach = true;
        } else {
            this.triedTriggerCantReach = false;
        }
        if (AITargetEdit.isSuitableTarget(this.searcher, threatTarget)) {
            this.lastKnownPosition = threatTarget.func_180425_c();
            this.clearAIPath();
            this.searcher.func_70624_b(threatTarget);
            Threat.apply((EntityLivingBase)this.searcher, null, DynamicStealthConfig.serverSettings.threat.seenTargetThreatRate, Threat.THREAT_TYPE.GEN_TARGET_VISIBLE, true);
            this.searcher.field_70170_p.field_72984_F.func_76319_b();
            return false;
        }
        Compat.clearAttackTargetAndCancelBadTasks(this.searcher);
        this.searcher.field_70170_p.field_72984_F.func_76319_b();
        return this.unseenTargetDegredation(threatPercentage);
    }

    private boolean unseenTargetDegredation(float threatPercentage) {
        if (this.fleeReason != 0) {
            return threatPercentage > 0.0f;
        }
        Compat.clearAttackTargetAndCancelBadTasks(this.searcher);
        Threat.apply((EntityLivingBase)this.searcher, null, DynamicStealthConfig.serverSettings.threat.unseenTargetDegredationRate, Threat.THREAT_TYPE.DEG_TARGET_NOT_VISIBLE, false);
        if (Threat.getThreat((EntityLivingBase)this.searcher) <= 0.0f) {
            this.clearAIPath();
            if (DynamicStealthConfig.serverSettings.interactions.giveUpSearch.fullHPRecovery) {
                this.searcher.func_70606_j(this.searcher.func_110138_aP());
            }
            if (this.isCNPC && DynamicStealthConfig.serverSettings.interactions.giveUpSearch.cnpcsWarpHome) {
                ICustomNpc cnpc = (ICustomNpc)NpcAPI.Instance().getIEntity((Entity)this.searcher);
                MCTools.teleport((EntityLivingBase)this.searcher, (double)((double)cnpc.getHomeX() + 0.5), (double)((double)cnpc.getHomeY() + 1.5), (double)((double)cnpc.getHomeZ() + 0.5), (boolean)false, (float)0.0f);
            }
            return false;
        }
        return true;
    }

    private void clearAIPath() {
        if (this.path != null && this.path.equals(this.navigator.func_75505_d())) {
            this.navigator.func_75499_g();
            this.searcher.field_70177_z = this.searcher.field_70759_as;
        }
        this.path = null;
    }

    public void func_75249_e() {
        this.searcher.field_70170_p.field_72984_F.func_76320_a("DStealth: AI");
        this.lastPos = null;
        this.timeAtPos = 0;
        if (this.fleeReason == 0) {
            if (this.lastKnownPosition == null) {
                this.mode(3);
            } else {
                this.mode(1);
            }
        }
        this.searcher.field_70170_p.field_72984_F.func_76319_b();
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    private void mode(int newMode) {
        if (this.mode == 3 && newMode != 3) {
            this.timeAtPos = 0;
        }
        if (newMode != -1 && newMode != -2) {
            this.fleeReason = 0;
        }
        if (newMode == 3) {
            this.startAngle = this.searcher.field_70759_as;
            this.spinDirection = this.searcher.func_70681_au().nextBoolean();
            this.angleDif = 0.0;
        } else if (newMode == 2 || newMode == 6) {
            this.timeAtPos = 0;
            this.searcher.field_70177_z = this.searcher.field_70759_as;
        } else {
            if (newMode == -1) {
                throw new IllegalArgumentException();
            }
            if (newMode == 4) {
                this.lastKnownPosition = MCTools.randomPos((BlockPos)this.searcher.func_180425_c(), (int)((int)((double)this.navigator.func_111269_d() * 0.5)), (int)((int)((double)this.navigator.func_111269_d() * 0.25)));
            } else if (newMode == -2) {
                this.path = null;
                this.navigator.func_75499_g();
                EntityLivingBase target = Threat.getTarget((EntityLivingBase)this.searcher);
                if (Sight.canSee((EntityLivingBase)this.searcher, (Entity)target, true, false, true, MCTools.getYawDeg((Vec3d)this.searcher.func_174791_d(), (Vec3d)new Vec3d((Vec3i)this.lastKnownPosition), (TrigLookupTable)DynamicStealth.TRIG_TABLE), MCTools.getPitchDeg((Vec3d)this.searcher.func_174791_d(), (Vec3d)new Vec3d((Vec3i)this.lastKnownPosition), (TrigLookupTable)DynamicStealth.TRIG_TABLE))) {
                    this.lastKnownPosition = target.func_180425_c();
                    this.timeAtPos = 0;
                    Communication.warn((EntityLivingBase)this.searcher, target, this.lastKnownPosition, true);
                    if (this.fleeReason == 3 && this.canReachTarget() && !MinecraftForge.EVENT_BUS.post((Event)new BasicEvent.DesperationEvent((EntityLivingBase)this.searcher))) {
                        this.mode(0);
                        this.restart(this.lastKnownPosition);
                        for (PotionEffect potionEffect : EventData.desperationPotions) {
                            this.searcher.func_70690_d(new PotionEffect(potionEffect));
                        }
                    }
                } else {
                    this.searcher.field_70177_z = this.cornerLookYaw = (float)MCTools.getYawDeg((Vec3d)this.searcher.func_174791_d(), (Vec3d)new Vec3d((Vec3i)this.lastKnownPosition), (TrigLookupTable)DynamicStealth.TRIG_TABLE);
                    this.searcher.field_70759_as = this.cornerLookYaw;
                    this.searcher.field_70125_A = this.cornerLookPitch = (float)MCTools.getPitchDeg((Vec3d)this.searcher.func_174791_d(), (Vec3d)new Vec3d((Vec3i)this.lastKnownPosition), (TrigLookupTable)DynamicStealth.TRIG_TABLE);
                }
            }
        }
        this.mode = newMode;
    }

    /*
     * WARNING - void declaration
     */
    public void func_75246_d() {
        block63: {
            EntityLivingBase target;
            block64: {
                block67: {
                    block65: {
                        block66: {
                            Object cnpc;
                            double distSquared;
                            this.searcher.field_70170_p.field_72984_F.func_76320_a("DStealth: AI");
                            if (!this.searcher.func_70089_S()) {
                                this.mode(0);
                                Threat.set((EntityLivingBase)this.searcher, null, 0.0f);
                                this.searcher.field_70170_p.field_72984_F.func_76319_b();
                                return;
                            }
                            Vec3d currentPos = this.searcher.func_174791_d();
                            this.timeAtPos = this.lastPos != null && this.lastPos.func_72436_e(currentPos) < this.speed * 0.001 ? ++this.timeAtPos : 0;
                            this.lastPos = currentPos;
                            if (this.fleeReason != 0 && this.mode != -1 && this.mode != -2) {
                                this.mode = -1;
                                this.clearAIPath();
                                this.fleeToPos = null;
                                this.timeAtPos = 0;
                            }
                            if (this.mode == 1) {
                                distSquared = this.lastKnownPosition.func_177951_i((Vec3i)this.searcher.func_180425_c());
                                if (distSquared < 1.0 || this.timeAtPos > 60) {
                                    this.mode(3);
                                } else {
                                    try {
                                        void var4_6;
                                        if (!((Boolean)navigatorCanNavigateMethod.invoke((Object)this.navigator, new Object[0])).booleanValue()) {
                                            this.searcher.field_70170_p.field_72984_F.func_76319_b();
                                            return;
                                        }
                                        if (distSquared < Math.pow(this.navigator.func_111269_d() - 2.0f, 2.0)) {
                                            Path path = this.navigator.func_179680_a(this.lastKnownPosition);
                                        } else {
                                            BlockPos blockPos = this.searcher.func_180425_c();
                                            BlockPos dif = this.lastKnownPosition.func_177973_b((Vec3i)blockPos);
                                            double ratio = (double)this.navigator.func_111269_d() * 0.75 / Math.sqrt(dif.func_177954_c(0.0, 0.0, 0.0));
                                            Path path = this.navigator.func_179680_a(blockPos.func_177971_a((Vec3i)new BlockPos((double)dif.func_177958_n() * ratio, (double)dif.func_177956_o() * ratio, (double)dif.func_177952_p() * ratio)));
                                        }
                                        if (var4_6 == null || var4_6.func_75876_a(this.path)) {
                                            this.mode(3);
                                        } else {
                                            this.path = var4_6;
                                            this.mode(2);
                                        }
                                    }
                                    catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                                        MCTools.crash((Exception)reflectiveOperationException, (int)150, (boolean)false);
                                    }
                                }
                            }
                            if (this.mode == 2) {
                                if (this.timeAtPos > 5 || this.path == null) {
                                    this.mode(1);
                                } else if (this.navigator.func_75505_d() != this.path) {
                                    this.navigator.func_75484_a(this.path, this.speed);
                                }
                            }
                            if (this.mode == 3) {
                                this.navigator.func_75499_g();
                                this.angleDif = this.spinDirection ? (this.angleDif += (double)this.headTurnSpeed) : (this.angleDif -= (double)this.headTurnSpeed);
                                double angleRad = Tools.degtorad((double)(this.startAngle + this.angleDif));
                                this.searcher.func_70671_ap().func_75650_a(this.searcher.field_70165_t - trigTable.sin(angleRad), this.searcher.field_70163_u + (double)this.searcher.func_70047_e(), this.searcher.field_70161_v + trigTable.cos(angleRad), (float)this.headTurnSpeed, (float)this.headTurnSpeed);
                                if (Math.abs(this.angleDif) >= 360.0) {
                                    this.mode(4);
                                }
                            }
                            if (this.mode == 4) {
                                distSquared = this.lastKnownPosition.func_177951_i((Vec3i)this.searcher.func_180425_c());
                                if (distSquared < 1.0 || this.timeAtPos > 60) {
                                    this.mode(3);
                                } else {
                                    try {
                                        if (!((Boolean)navigatorCanNavigateMethod.invoke((Object)this.navigator, new Object[0])).booleanValue()) {
                                            this.searcher.field_70170_p.field_72984_F.func_76319_b();
                                            return;
                                        }
                                        Path path = this.navigator.func_179680_a(this.lastKnownPosition);
                                        if (path == null || path.func_75876_a(this.path)) {
                                            this.mode(3);
                                        } else {
                                            this.path = path;
                                            if (this.findPathAngle()) {
                                                this.mode(5);
                                            } else {
                                                this.mode(3);
                                            }
                                        }
                                    }
                                    catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                                        MCTools.crash((Exception)reflectiveOperationException, (int)151, (boolean)false);
                                    }
                                }
                            }
                            if (this.mode == 5) {
                                this.navigator.func_75499_g();
                                double headYaw = Tools.posMod((float)this.searcher.field_70759_as, (float)360.0f);
                                if (headYaw > this.pathAngle && headYaw - this.pathAngle <= 1.0 || headYaw <= this.pathAngle && this.pathAngle - headYaw <= 1.0) {
                                    this.mode(6);
                                } else {
                                    this.searcher.func_70671_ap().func_75650_a(this.nextPos.field_72450_a, this.searcher.field_70163_u + (double)this.searcher.func_70047_e(), this.nextPos.field_72449_c, (float)this.headTurnSpeed, (float)this.headTurnSpeed);
                                }
                            }
                            if (this.mode == 6) {
                                if (this.timeAtPos > 5 || this.path == null) {
                                    this.mode(3);
                                } else if (this.navigator.func_75505_d() != this.path) {
                                    this.navigator.func_75484_a(this.path, this.speed);
                                }
                            }
                            if (this.mode != -1 && this.mode != -2) break block63;
                            Threat.apply((EntityLivingBase)this.searcher, null, DynamicStealthConfig.serverSettings.threat.fleeDegredationRate, Threat.THREAT_TYPE.DEG_FLEE, false);
                            int oldReason = this.fleeReason;
                            if (Threat.getThreat((EntityLivingBase)this.searcher) <= 0.0f) {
                                this.mode(0);
                                if (DynamicStealthConfig.serverSettings.interactions.calmDown.fullHPRecovery) {
                                    this.searcher.func_70606_j(this.searcher.func_110138_aP());
                                }
                                if (this.isCNPC && DynamicStealthConfig.serverSettings.interactions.calmDown.cnpcsWarpHome) {
                                    cnpc = (ICustomNpc)NpcAPI.Instance().getIEntity((Entity)this.searcher);
                                    MCTools.teleport((EntityLivingBase)this.searcher, (double)((double)cnpc.getHomeX() + 0.5), (double)((double)cnpc.getHomeY() + 1.5), (double)((double)cnpc.getHomeZ() + 0.5), (boolean)false, (float)0.0f);
                                }
                                if (!MinecraftForge.EVENT_BUS.post((Event)new BasicEvent.CalmDownEvent((EntityLivingBase)this.searcher, oldReason))) {
                                    for (PotionEffect potionEffect : EventData.calmDownPotions) {
                                        this.searcher.func_70690_d(new PotionEffect(potionEffect));
                                    }
                                }
                            } else {
                                if (this.fleeReason == 2 && this.canReachTarget()) {
                                    this.mode(0);
                                    this.fleeIfYouShould(0.0f);
                                    if (this.fleeReason == 0 && !MinecraftForge.EVENT_BUS.post((Event)new BasicEvent.RallyEvent((EntityLivingBase)this.searcher, oldReason))) {
                                        target = Threat.getTarget((EntityLivingBase)this.searcher);
                                        Communication.warn((EntityLivingBase)this.searcher, target, this.lastKnownPosition, Sight.canSee((EntityLivingBase)this.searcher, (Entity)target, true));
                                        for (PotionEffect potionEffect : EventData.rallyPotions) {
                                            this.searcher.func_70690_d(new PotionEffect(potionEffect));
                                        }
                                    }
                                }
                                oldReason = this.fleeReason;
                                if (this.fleeReason == 3 && (int)(this.searcher.func_110143_aJ() / this.searcher.func_110138_aP() * 100.0f) > EntityAIData.fleeThreshold((EntityLivingBase)this.searcher)) {
                                    this.mode(0);
                                    this.fleeIfYouShould(0.0f);
                                    if (this.fleeReason == 0 && !MinecraftForge.EVENT_BUS.post((Event)new BasicEvent.RallyEvent((EntityLivingBase)this.searcher, oldReason))) {
                                        target = Threat.getTarget((EntityLivingBase)this.searcher);
                                        Communication.warn((EntityLivingBase)this.searcher, target, this.lastKnownPosition, Sight.canSee((EntityLivingBase)this.searcher, (Entity)target, true));
                                        for (PotionEffect potionEffect : EventData.rallyPotions) {
                                            this.searcher.func_70690_d(new PotionEffect(potionEffect));
                                        }
                                    }
                                }
                            }
                            if (this.fleeReason == 0) {
                                this.clearAIPath();
                                if (Threat.getThreat((EntityLivingBase)this.searcher) > 0.0f) {
                                    this.restart(this.lastKnownPosition);
                                }
                                this.searcher.field_70170_p.field_72984_F.func_76319_b();
                                return;
                            }
                            if (this.lastKnownPosition == null) {
                                this.lastKnownPosition = MCTools.randomPos((BlockPos)this.searcher.func_180425_c(), (int)5, (int)0);
                            }
                            if (this.mode != -1) break block64;
                            if (!this.isCNPC || !DynamicStealthConfig.serverSettings.ai.flee.cnpcsRunHome) break block65;
                            cnpc = (ICustomNpc)NpcAPI.Instance().getIEntity((Entity)this.searcher);
                            this.fleeToPos = new BlockPos(cnpc.getHomeX(), cnpc.getHomeY(), cnpc.getHomeZ());
                            if (this.fleeToPos.func_177958_n() == this.searcher.func_180425_c().func_177958_n() && this.fleeToPos.func_177952_p() == this.searcher.func_180425_c().func_177952_p() || this.path != null && !this.path.func_75879_b()) break block66;
                            this.path = this.navigator.func_179680_a(this.fleeToPos);
                            this.navigator.func_75484_a(this.path, this.fleeSpeed);
                            break block63;
                        }
                        if (this.navigator.func_75505_d() == this.path) break block63;
                        this.navigator.func_75484_a(this.path, this.fleeSpeed);
                        break block63;
                    }
                    BlockPos oldFleePos = this.fleeToPos;
                    if (this.fleeToPos == null || this.searcher.func_180425_c().func_177951_i((Vec3i)this.fleeToPos) < 5.0 || this.path != null && this.path.func_75879_b() || this.timeAtPos > 2) {
                        if (this.timeAtPos <= 3) {
                            this.fleeToPos = new BlockPos(this.searcher.func_174791_d().func_178787_e(this.searcher.func_174791_d().func_178788_d(new Vec3d((Vec3i)this.lastKnownPosition)).func_72432_b().func_186678_a(10.0)));
                        } else if (this.timeAtPos == 4) {
                            this.findShortRangeGoalPos();
                        } else if (this.fleeReason == 1) {
                            this.timeAtPos = 0;
                        } else {
                            this.mode(-2);
                        }
                    }
                    if (this.fleeToPos == oldFleePos && this.path != null) break block67;
                    if (this.fleeToPos == null) {
                        this.clearAIPath();
                    } else {
                        this.path = this.navigator.func_179680_a(this.fleeToPos);
                        this.navigator.func_75484_a(this.path, this.fleeSpeed);
                    }
                    break block63;
                }
                if (this.navigator.func_75505_d() == this.path) break block63;
                this.navigator.func_75484_a(this.path, this.fleeSpeed);
                break block63;
            }
            if (this.mode == -2) {
                this.path = null;
                this.navigator.func_75499_g();
                this.searcher.field_70759_as = (float)((double)this.cornerLookYaw + 45.0 * DynamicStealth.TRIG_TABLE.sin((double)this.timeAtPos * 0.1));
                this.searcher.field_70125_A = this.cornerLookPitch;
                target = Threat.getTarget((EntityLivingBase)this.searcher);
                if (Sight.canSee((EntityLivingBase)this.searcher, (Entity)target, true)) {
                    this.lastKnownPosition = target.func_180425_c();
                    Communication.warn((EntityLivingBase)this.searcher, target, this.lastKnownPosition, true);
                    if (this.fleeReason == 3 && this.canReachTarget() && !MinecraftForge.EVENT_BUS.post((Event)new BasicEvent.DesperationEvent((EntityLivingBase)this.searcher))) {
                        this.mode(0);
                        this.restart(this.lastKnownPosition);
                        for (PotionEffect potionEffect : EventData.desperationPotions) {
                            this.searcher.func_70690_d(new PotionEffect(potionEffect));
                        }
                    }
                }
            }
        }
        this.searcher.field_70170_p.field_72984_F.func_76319_b();
    }

    private void findShortRangeGoalPos() {
        BlockPos searcherPos = this.searcher.func_180425_c();
        int xFactor = searcherPos.func_177958_n() - this.lastKnownPosition.func_177958_n();
        int zFactor = searcherPos.func_177952_p() - this.lastKnownPosition.func_177952_p();
        int maxFactor = Tools.max((int[])new int[]{Math.abs(xFactor), Math.abs(zFactor)});
        if (maxFactor == 0) {
            maxFactor = 5;
            if (Math.random() < 0.5) {
                xFactor = 0;
                zFactor = Math.random() < 0.5 ? 5 : -5;
            } else {
                xFactor = Math.random() < 0.5 ? 5 : -5;
                zFactor = 0;
            }
        }
        xFactor = (int)((double)xFactor * 5.0 / (double)maxFactor);
        zFactor = (int)((double)zFactor * 5.0 / (double)maxFactor);
        int xStep = xFactor < 0 ? -1 : 1;
        int zStep = zFactor < 0 ? -1 : 1;
        boolean found = false;
        for (int iy = 1; iy > -4 && !found; --iy) {
            for (int ix = xFactor; ix != -xStep && !found; ix -= xStep) {
                for (int iz = zFactor; iz != -zStep && !found; iz -= zStep) {
                    BlockPos testPos = searcherPos.func_177982_a(ix, iy, iz);
                    if (ix == 0 && iy == 0 && iz == 0 || !this.navigator.func_188555_b(testPos) || this.searcher.field_70170_p.func_180495_p(testPos).func_185904_a().func_76230_c()) continue;
                    this.fleeToPos = testPos;
                    found = true;
                }
            }
        }
    }

    public void restart(BlockPos newPos) {
        this.lastKnownPosition = newPos;
        this.func_75249_e();
    }

    private boolean findPathAngle() {
        int length = this.path.func_75874_d();
        if (length < 2) {
            return false;
        }
        int i = 1;
        Vec3d pos = this.searcher.func_174791_d();
        this.nextPos = this.path.func_75881_a((Entity)this.searcher, i);
        while (true) {
            BlockPos blockPos = new BlockPos(pos);
            BlockPos blockPos2 = new BlockPos(this.nextPos);
            if (!(blockPos.func_177951_i((Vec3i)blockPos2) < 2.0)) break;
            if (length < i + 2) {
                return false;
            }
            this.nextPos = this.path.func_75881_a((Entity)this.searcher, ++i);
        }
        this.pathAngle = 360.0 - Tools.radtodeg((double)DynamicStealth.TRIG_TABLE.arctanFullcircle(pos.field_72449_c, -pos.field_72450_a, this.nextPos.field_72449_c, -this.nextPos.field_72450_a));
        return true;
    }

    static {
        trigTable = DynamicStealth.TRIG_TABLE;
        navigatorCanNavigateMethod = ReflectionTool.getMethod(PathNavigate.class, (String[])new String[]{"func_75485_k", "canNavigate"});
    }
}

