/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.ai;

import com.fantasticsource.dynamicstealth.config.DynamicStealthConfig;
import com.fantasticsource.mctools.MCTools;
import java.util.LinkedHashMap;
import net.minecraft.entity.EntityLivingBase;

public class EntityAIData {
    private static LinkedHashMap<Class<? extends EntityLivingBase>, LinkedHashMap<String, Integer>> entityHeadTurnSpeeds;
    private static LinkedHashMap<Class<? extends EntityLivingBase>, LinkedHashMap<String, Integer>> entityFleePercentages;

    public static void update() {
        entityHeadTurnSpeeds = new LinkedHashMap();
        entityFleePercentages = new LinkedHashMap();
        MCTools.populateEntityIntMap((String[])DynamicStealthConfig.serverSettings.ai.y_entityOverrides.headTurnSpeed, entityHeadTurnSpeeds);
        MCTools.populateEntityIntMap((String[])DynamicStealthConfig.serverSettings.ai.y_entityOverrides.specificFleeThresholds, entityFleePercentages);
    }

    public static int headTurnSpeed(EntityLivingBase searcher) {
        return MCTools.entityMatchesIntMapOrDefault((EntityLivingBase)searcher, entityHeadTurnSpeeds, (int)DynamicStealthConfig.serverSettings.ai.headTurnSpeed);
    }

    public static int fleeThreshold(EntityLivingBase searcher) {
        return MCTools.entityMatchesIntMapOrDefault((EntityLivingBase)searcher, entityFleePercentages, (int)DynamicStealthConfig.serverSettings.ai.flee.threshold);
    }
}

